/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.files;

import com.google.appengine.api.files.AppEngineFile;
import com.google.appengine.api.files.FileServiceImpl;
import com.google.appengine.api.files.FileWriteChannel;
import com.google.appengine.api.files.FinalizationException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;

class FileWriteChannelImpl
implements FileWriteChannel {
    private FileServiceImpl fileService;
    private AppEngineFile file;
    private boolean lockHeld;
    private boolean isOpen;
    private final Object lock = new Object();

    FileWriteChannelImpl(AppEngineFile f, boolean lock, FileServiceImpl fs) {
        this.file = f;
        this.lockHeld = lock;
        this.fileService = fs;
        this.isOpen = true;
        if (null == this.file) {
            throw new NullPointerException("file is null");
        }
        if (!f.isWritable()) {
            throw new IllegalArgumentException("file is not writable");
        }
    }

    private void checkOpen() throws ClosedChannelException {
        if (!this.isOpen) {
            throw new ClosedChannelException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int write(ByteBuffer src) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            return this.write(src, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int write(ByteBuffer buffer, String sequenceKey) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.checkOpen();
            return this.fileService.append(this.file, buffer, sequenceKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isOpen() {
        Object object = this.lock;
        synchronized (object) {
            return this.isOpen;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.isOpen) {
                return;
            }
            this.fileService.close(this.file, false);
            this.isOpen = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeFinally() throws IllegalStateException, IOException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.lockHeld) {
                throw new IllegalStateException("The lock for this file is not held by the current request");
            }
            if (this.isOpen) {
                this.fileService.close(this.file, true);
            } else {
                try {
                    this.fileService.openForAppend(this.file, true);
                    this.fileService.close(this.file, true);
                }
                catch (FinalizationException finalizationException) {
                    // empty catch block
                }
            }
            this.isOpen = false;
        }
    }
}

