/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.collect;

import com.google.appengine.repackaged.com.google.common.annotations.GwtCompatible;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableAsList;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableCollection;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableMap;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableSet;
import com.google.appengine.repackaged.com.google.common.collect.Maps;
import com.google.appengine.repackaged.com.google.common.collect.RegularImmutableTable;
import com.google.appengine.repackaged.com.google.common.collect.Table;
import com.google.appengine.repackaged.com.google.common.collect.Tables;
import com.google.appengine.repackaged.com.google.common.collect.UnmodifiableIterator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@GwtCompatible
@Immutable
final class SparseImmutableTable<R, C, V>
extends RegularImmutableTable<R, C, V> {
    private final ImmutableMap<R, Map<C, V>> rowMap;
    private final ImmutableMap<C, Map<R, V>> columnMap;
    private final int[] iterationOrderRow;
    private final int[] iterationOrderColumn;

    SparseImmutableTable(ImmutableList<Table.Cell<R, C, V>> cellList, ImmutableSet<R> rowSpace, ImmutableSet<C> columnSpace) {
        HashMap rowIndex = Maps.newHashMap();
        LinkedHashMap rows = Maps.newLinkedHashMap();
        for (Object row : rowSpace) {
            rowIndex.put(row, rows.size());
            rows.put(row, new LinkedHashMap());
        }
        LinkedHashMap columns = Maps.newLinkedHashMap();
        for (Object col : columnSpace) {
            columns.put(col, new LinkedHashMap());
        }
        int[] iterationOrderRow = new int[cellList.size()];
        int[] iterationOrderColumn = new int[cellList.size()];
        for (int i = 0; i < cellList.size(); ++i) {
            Table.Cell cell = (Table.Cell)cellList.get(i);
            Object rowKey = cell.getRowKey();
            Object columnKey = cell.getColumnKey();
            Object value = cell.getValue();
            iterationOrderRow[i] = (Integer)rowIndex.get(rowKey);
            Map thisRow = (Map)rows.get(rowKey);
            iterationOrderColumn[i] = thisRow.size();
            Object oldValue = thisRow.put(columnKey, value);
            if (oldValue != null) {
                throw new IllegalArgumentException("Duplicate value for row=" + rowKey + ", column=" + columnKey + ": " + value + ", " + oldValue);
            }
            ((Map)columns.get(columnKey)).put(rowKey, value);
        }
        this.iterationOrderRow = iterationOrderRow;
        this.iterationOrderColumn = iterationOrderColumn;
        ImmutableMap.Builder rowBuilder = ImmutableMap.builder();
        for (Map.Entry row : rows.entrySet()) {
            rowBuilder.put(row.getKey(), ImmutableMap.copyOf((Map)row.getValue()));
        }
        this.rowMap = rowBuilder.build();
        ImmutableMap.Builder columnBuilder = ImmutableMap.builder();
        for (Map.Entry col : columns.entrySet()) {
            columnBuilder.put(col.getKey(), ImmutableMap.copyOf((Map)col.getValue()));
        }
        this.columnMap = columnBuilder.build();
    }

    @Override
    public ImmutableMap<C, Map<R, V>> columnMap() {
        return this.columnMap;
    }

    @Override
    public ImmutableMap<R, Map<C, V>> rowMap() {
        return this.rowMap;
    }

    @Override
    public V get(@Nullable Object rowKey, @Nullable Object columnKey) {
        Map<C, V> row = this.rowMap.get(rowKey);
        return row == null ? null : (V)row.get(columnKey);
    }

    @Override
    ImmutableCollection<V> createValues() {
        return new ImmutableList<V>(){

            @Override
            public int size() {
                return SparseImmutableTable.this.iterationOrderRow.length;
            }

            @Override
            public V get(int index) {
                int rowIndex = SparseImmutableTable.this.iterationOrderRow[index];
                ImmutableMap row = (ImmutableMap)((ImmutableCollection)SparseImmutableTable.this.rowMap.values()).asList().get(rowIndex);
                int columnIndex = SparseImmutableTable.this.iterationOrderColumn[index];
                return ((ImmutableCollection)row.values()).asList().get(columnIndex);
            }

            @Override
            boolean isPartialView() {
                return true;
            }
        };
    }

    @Override
    public int size() {
        return this.iterationOrderRow.length;
    }

    @Override
    ImmutableSet<Table.Cell<R, C, V>> createCellSet() {
        return new SparseCellSet();
    }

    class SparseCellSet
    extends RegularImmutableTable.CellSet {
        SparseCellSet() {
        }

        @Override
        public UnmodifiableIterator<Table.Cell<R, C, V>> iterator() {
            return this.asList().iterator();
        }

        @Override
        ImmutableList<Table.Cell<R, C, V>> createAsList() {
            return new ImmutableAsList<Table.Cell<R, C, V>>(){

                @Override
                public Table.Cell<R, C, V> get(int index) {
                    int rowIndex = SparseImmutableTable.this.iterationOrderRow[index];
                    Map.Entry rowEntry = (Map.Entry)((ImmutableCollection)((Object)SparseImmutableTable.this.rowMap.entrySet())).asList().get(rowIndex);
                    ImmutableMap row = (ImmutableMap)rowEntry.getValue();
                    int columnIndex = SparseImmutableTable.this.iterationOrderColumn[index];
                    Map.Entry colEntry = (Map.Entry)((ImmutableCollection)((Object)row.entrySet())).asList().get(columnIndex);
                    return Tables.immutableCell(rowEntry.getKey(), colEntry.getKey(), colEntry.getValue());
                }

                @Override
                ImmutableCollection<Table.Cell<R, C, V>> delegateCollection() {
                    return SparseCellSet.this;
                }
            };
        }
    }
}

