/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.protobuf;

import com.google.appengine.repackaged.com.google.protobuf.AbstractMessageLite;
import com.google.appengine.repackaged.com.google.protobuf.AbstractParser;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.appengine.repackaged.com.google.protobuf.CodedInputStream;
import com.google.appengine.repackaged.com.google.protobuf.CodedOutputStream;
import com.google.appengine.repackaged.com.google.protobuf.ExtensionRegistryLite;
import com.google.appengine.repackaged.com.google.protobuf.InvalidProtocolBufferException;
import com.google.appengine.repackaged.com.google.protobuf.MessageLite;
import com.google.appengine.repackaged.com.google.protobuf.MutableMessageLite;
import com.google.appengine.repackaged.com.google.protobuf.Parser;
import com.google.appengine.repackaged.com.google.protobuf.UninitializedMessageException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.AbstractList;
import java.util.Collection;
import java.util.List;

public abstract class AbstractMutableMessageLite<MessageType extends AbstractMutableMessageLite>
implements MutableMessageLite {
    private boolean isMutable = true;
    protected int cachedSize = -1;

    protected void makeImmutable() {
        this.isMutable = false;
    }

    protected void assertMutable() {
        if (!this.isMutable) {
            throw new IllegalStateException("Try to modify an immutable message.");
        }
    }

    @Override
    public MessageLite.Builder toBuilder() {
        throw new UnsupportedOperationException("toBuilder() is not supported in mutable messages.");
    }

    @Override
    public MessageLite.Builder newBuilderForType() {
        throw new UnsupportedOperationException("newBuilderForType() is not supported in mutable messages.");
    }

    @Override
    public MutableMessageLite mutableCopy() {
        throw new UnsupportedOperationException("mutableCopy() is not supported in mutable messages. Use clone() if you need to make a copy of the mutable message.");
    }

    public MessageType clone() {
        throw new UnsupportedOperationException("clone() should be implemented by subclasses.");
    }

    @Override
    public ByteString toByteString() {
        try {
            ByteString.CodedBuilder out = ByteString.newCodedBuilder(this.getSerializedSize());
            this.writeTo(out.getCodedOutput());
            return out.build();
        }
        catch (IOException e) {
            throw new RuntimeException("Serializing to a ByteString threw an IOException (should never happen).", e);
        }
    }

    @Override
    public byte[] toByteArray() {
        try {
            byte[] result = new byte[this.getSerializedSize()];
            CodedOutputStream output = CodedOutputStream.newInstance(result);
            this.writeTo(output);
            output.checkNoSpaceLeft();
            return result;
        }
        catch (IOException e) {
            throw new RuntimeException("Serializing to a byte array threw an IOException (should never happen).", e);
        }
    }

    @Override
    public void writeTo(OutputStream output) throws IOException {
        int bufferSize = CodedOutputStream.computePreferredBufferSize(this.getSerializedSize());
        CodedOutputStream codedOutput = CodedOutputStream.newInstance(output, bufferSize);
        this.writeTo(codedOutput);
        codedOutput.flush();
    }

    @Override
    public void writeDelimitedTo(OutputStream output) throws IOException {
        int serialized = this.getSerializedSize();
        int bufferSize = CodedOutputStream.computePreferredBufferSize(CodedOutputStream.computeRawVarint32Size(serialized) + serialized);
        CodedOutputStream codedOutput = CodedOutputStream.newInstance(output, bufferSize);
        codedOutput.writeRawVarint32(serialized);
        this.writeTo(codedOutput);
        codedOutput.flush();
    }

    UninitializedMessageException newUninitializedMessageException() {
        return new UninitializedMessageException(this);
    }

    @Override
    public final int getCachedSize() {
        return this.cachedSize;
    }

    @Override
    public void writeTo(CodedOutputStream output) throws IOException {
        this.getSerializedSize();
        this.writeToWithCachedSizes(output);
    }

    public MessageType mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        this.mergePartialFrom(input, extensionRegistry);
        if (!this.isInitialized()) {
            throw AbstractMutableMessageLite.newUninitializedMessageException(this);
        }
        return (MessageType)this;
    }

    public MessageType mergeFrom(CodedInputStream input) throws IOException {
        return (MessageType)this.mergeFrom(input, ExtensionRegistryLite.getEmptyRegistry());
    }

    public MessageType mergePartialFrom(CodedInputStream input) throws IOException {
        return (MessageType)this.mergePartialFrom(input, ExtensionRegistryLite.getEmptyRegistry());
    }

    public abstract MessageType mergePartialFrom(CodedInputStream var1, ExtensionRegistryLite var2) throws IOException;

    public abstract MessageType clear();

    public MessageType mergeFrom(ByteString data) throws InvalidProtocolBufferException {
        try {
            CodedInputStream input = data.newCodedInput();
            this.mergeFrom(input);
            input.checkLastTagWas(0);
            return (MessageType)this;
        }
        catch (InvalidProtocolBufferException e) {
            throw e;
        }
        catch (IOException e) {
            throw new RuntimeException("Reading from a ByteString threw an IOException (should never happen).", e);
        }
    }

    public MessageType mergeFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        try {
            CodedInputStream input = data.newCodedInput();
            this.mergeFrom(input, extensionRegistry);
            input.checkLastTagWas(0);
            return (MessageType)this;
        }
        catch (InvalidProtocolBufferException e) {
            throw e;
        }
        catch (IOException e) {
            throw new RuntimeException("Reading from a ByteString threw an IOException (should never happen).", e);
        }
    }

    public MessageType mergeFrom(byte[] data) throws InvalidProtocolBufferException {
        return (MessageType)this.mergeFrom(data, 0, data.length);
    }

    public MessageType mergeFrom(byte[] data, int off, int len) throws InvalidProtocolBufferException {
        try {
            CodedInputStream input = CodedInputStream.newInstance(data, off, len);
            this.mergeFrom(input);
            input.checkLastTagWas(0);
            return (MessageType)this;
        }
        catch (InvalidProtocolBufferException e) {
            throw e;
        }
        catch (IOException e) {
            throw new RuntimeException("Reading from a byte array threw an IOException (should never happen).", e);
        }
    }

    public MessageType mergeFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (MessageType)this.mergeFrom(data, 0, data.length, extensionRegistry);
    }

    public MessageType mergeFrom(byte[] data, int off, int len, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        try {
            CodedInputStream input = CodedInputStream.newInstance(data, off, len);
            this.mergeFrom(input, extensionRegistry);
            input.checkLastTagWas(0);
            return (MessageType)this;
        }
        catch (InvalidProtocolBufferException e) {
            throw e;
        }
        catch (IOException e) {
            throw new RuntimeException("Reading from a byte array threw an IOException (should never happen).", e);
        }
    }

    public MessageType mergeFrom(InputStream input) throws IOException {
        CodedInputStream codedInput = CodedInputStream.newInstance(input);
        this.mergeFrom(input);
        codedInput.checkLastTagWas(0);
        return (MessageType)this;
    }

    public MessageType mergeFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        CodedInputStream codedInput = CodedInputStream.newInstance(input);
        this.mergeFrom(codedInput, extensionRegistry);
        codedInput.checkLastTagWas(0);
        return (MessageType)this;
    }

    @Override
    public boolean mergeDelimitedFrom(InputStream input) throws IOException {
        return this.mergeDelimitedFrom(input, ExtensionRegistryLite.getEmptyRegistry());
    }

    @Override
    public boolean mergeDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        int firstByte = input.read();
        if (firstByte == -1) {
            return false;
        }
        int size = CodedInputStream.readRawVarint32(firstByte, input);
        AbstractMessageLite.Builder.LimitedInputStream limitedInput = new AbstractMessageLite.Builder.LimitedInputStream(input, size);
        this.mergeFrom(limitedInput, extensionRegistry);
        return true;
    }

    public MessageType parseFrom(CodedInputStream input) throws IOException {
        this.clear();
        return (MessageType)this.mergeFrom(input);
    }

    public MessageType parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        this.clear();
        return (MessageType)this.mergeFrom(input, extensionRegistry);
    }

    public MessageType parsePartialFrom(CodedInputStream input) throws IOException {
        this.clear();
        return (MessageType)this.mergePartialFrom(input);
    }

    public MessageType parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        this.clear();
        return (MessageType)this.mergePartialFrom(input, extensionRegistry);
    }

    public MessageType parseFrom(ByteString data) throws InvalidProtocolBufferException {
        this.clear();
        return (MessageType)this.mergeFrom(data);
    }

    public MessageType parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        this.clear();
        return (MessageType)this.mergeFrom(data, extensionRegistry);
    }

    public MessageType parseFrom(byte[] data) throws InvalidProtocolBufferException {
        this.clear();
        return (MessageType)this.mergeFrom(data, 0, data.length);
    }

    public MessageType parseFrom(byte[] data, int off, int len) throws InvalidProtocolBufferException {
        this.clear();
        return (MessageType)this.mergeFrom(data, off, len);
    }

    public MessageType parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        this.clear();
        return (MessageType)this.mergeFrom(data, 0, data.length, extensionRegistry);
    }

    public MessageType parseFrom(byte[] data, int off, int len, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        this.clear();
        return (MessageType)this.mergeFrom(data, off, len, extensionRegistry);
    }

    public MessageType parseFrom(InputStream input) throws IOException {
        this.clear();
        return (MessageType)this.mergeFrom(input);
    }

    public MessageType parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        this.clear();
        return (MessageType)this.mergeFrom(input, extensionRegistry);
    }

    @Override
    public boolean parseDelimitedFrom(InputStream input) throws IOException {
        this.clear();
        return this.mergeDelimitedFrom(input);
    }

    @Override
    public boolean parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        this.clear();
        return this.mergeDelimitedFrom(input, extensionRegistry);
    }

    protected static UninitializedMessageException newUninitializedMessageException(MessageLite message) {
        return new UninitializedMessageException(message);
    }

    protected static <T extends MutableMessageLite> Parser<T> internalNewParserForType(final T defaultInstance) {
        return new AbstractParser<T>(){

            @Override
            public T parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                MutableMessageLite message = defaultInstance.newMessageForType();
                try {
                    message.mergePartialFrom(input, extensionRegistry);
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.setUnfinishedMessage(message);
                }
                catch (IOException e) {
                    throw new InvalidProtocolBufferException(e.getMessage()).setUnfinishedMessage(message);
                }
                return message;
            }
        };
    }

    protected static <T> void addAll(Iterable<T> values, Collection<? super T> list) {
        AbstractMessageLite.Builder.addAll(values, list);
    }

    protected static boolean internalAddStrings(Iterable<? extends String> values, List<ByteString> list) {
        boolean modified = false;
        if (values != null) {
            for (String string : values) {
                if (!list.add(ByteString.copyFromUtf8(string))) continue;
                modified = true;
            }
        }
        return modified;
    }

    protected static List<String> internalToMutableStringList(List<ByteString> list) {
        return new MutableStringList(list);
    }

    private static class MutableStringList
    extends AbstractList<String> {
        private List<ByteString> list;

        public MutableStringList(List<ByteString> list) {
            this.list = list;
        }

        @Override
        public String get(int index) {
            return this.list.get(index).toStringUtf8();
        }

        @Override
        public int size() {
            return this.list.size();
        }

        @Override
        public String set(int index, String s) {
            this.list.set(index, ByteString.copyFromUtf8(s));
            return s;
        }

        @Override
        public void add(int index, String s) {
            this.list.add(index, ByteString.copyFromUtf8(s));
        }

        @Override
        public String remove(int index) {
            return this.list.remove(index).toStringUtf8();
        }
    }
}

