/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.utils.servlet;

import com.google.apphosting.api.ApiProxy;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class JdbcMySqlConnectionCleanupFilter
implements Filter {
    private static final Logger logger = Logger.getLogger(JdbcMySqlConnectionCleanupFilter.class.getCanonicalName());
    static final String CONNECTION_KEY = "com.google.appengine.cloudsql.connections";
    static final String CLOUD_SQL_JDBC_CONNECTIVITY_ENABLED_KEY = "com.google.appengine.runtime.new_database_connectivity";
    private AppEngineApiWrapper appEngineApiWrapper = new AppEngineApiWrapper();

    void setAppEngineApiWrapper(AppEngineApiWrapper appEngineApiWrapper) {
        this.appEngineApiWrapper = appEngineApiWrapper;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            chain.doFilter(request, response);
        }
        finally {
            this.cleanupConnections();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cleanupConnections() {
        Map<String, Object> attributes = this.appEngineApiWrapper.getRequestEnvironmentAttributes();
        if (attributes == null) {
            return;
        }
        Object cloudSqlJdbcConnectivityEnabledValue = attributes.get(CLOUD_SQL_JDBC_CONNECTIVITY_ENABLED_KEY);
        if (cloudSqlJdbcConnectivityEnabledValue == null || !(cloudSqlJdbcConnectivityEnabledValue instanceof Boolean)) {
            return;
        }
        if (!((Boolean)cloudSqlJdbcConnectivityEnabledValue).booleanValue()) {
            return;
        }
        Object connectionValue = attributes.get(CONNECTION_KEY);
        if (connectionValue == null || !(connectionValue instanceof Set)) {
            return;
        }
        Set connections = (Set)connectionValue;
        if (connections.isEmpty()) {
            return;
        }
        try {
            for (Object connectionImpl : connections) {
                try {
                    connectionImpl.getClass().getMethod("close", new Class[0]).invoke(connectionImpl, new Object[0]);
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Exception while closing connections", e);
                }
            }
        }
        finally {
            connections.clear();
        }
    }

    public void destroy() {
    }

    static class AppEngineApiWrapper {
        AppEngineApiWrapper() {
        }

        Map<String, Object> getRequestEnvironmentAttributes() {
            ApiProxy.Environment environment = ApiProxy.getCurrentEnvironment();
            if (environment == null) {
                logger.warning("Unable to fetch the request environment.");
                return null;
            }
            Map<String, Object> attributes = environment.getAttributes();
            if (attributes == null) {
                logger.warning("Unable to fetch the request environment attributes.");
                return null;
            }
            return attributes;
        }
    }
}

