/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.conversion;

import com.google.appengine.api.conversion.Conversion;
import com.google.appengine.api.conversion.ConversionProtoConverter;
import com.google.appengine.api.conversion.ConversionServicePb;
import com.google.appengine.repackaged.com.google.common.base.Converter;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;

class ConversionRequestProtoConverter
extends Converter<List<Conversion>, ConversionServicePb.ConversionRequest> {
    private final ConversionProtoConverter conversionProtoConverter = new ConversionProtoConverter();

    ConversionRequestProtoConverter() {
    }

    @Override
    public ConversionServicePb.ConversionRequest doForward(List<Conversion> conversions) {
        Preconditions.checkArgument(conversions.size() > 0, "At least one conversion is required in the request");
        Preconditions.checkArgument(conversions.size() <= 10, String.format("At most %d conversions are allowed in one request.", 10));
        ConversionServicePb.ConversionRequest.Builder request = ConversionServicePb.ConversionRequest.newBuilder();
        for (Conversion conversion : conversions) {
            request.addConversion((ConversionServicePb.ConversionInput)this.conversionProtoConverter.convert(conversion));
        }
        return request.build();
    }

    @Override
    public List<Conversion> doBackward(ConversionServicePb.ConversionRequest requestPb) {
        ArrayList<Conversion> conversions = Lists.newArrayList();
        for (ConversionServicePb.ConversionInput conversion : requestPb.getConversionList()) {
            conversions.add((Conversion)this.conversionProtoConverter.reverse().convert(conversion));
        }
        return conversions;
    }
}

