/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.prospectivesearch;

import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.EntityTranslator;
import com.google.appengine.api.prospectivesearch.ErrorPb;
import com.google.appengine.api.prospectivesearch.FieldType;
import com.google.appengine.api.prospectivesearch.ProspectiveSearchPb;
import com.google.appengine.api.prospectivesearch.ProspectiveSearchService;
import com.google.appengine.api.prospectivesearch.QuerySyntaxException;
import com.google.appengine.api.prospectivesearch.Subscription;
import com.google.appengine.repackaged.com.google.common.util.Base64;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolMessage;
import com.google.apphosting.api.ApiProxy;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;

class ProspectiveSearchServiceImpl
implements ProspectiveSearchService {
    static final String PACKAGE = "matcher";
    static final Logger LOGGER = Logger.getLogger(ProspectiveSearchServiceImpl.class.getName());

    ProspectiveSearchServiceImpl() {
    }

    @Override
    public void subscribe(String topic, String subId, long leaseDurationSeconds, String query, Map<String, FieldType> schema) throws QuerySyntaxException {
        ProspectiveSearchPb.SubscribeRequest req = new ProspectiveSearchPb.SubscribeRequest();
        req.setTopic(topic);
        req.setSubId(subId);
        if (leaseDurationSeconds < 0L) {
            throw new IllegalArgumentException("Lease duration must be non-negative: " + leaseDurationSeconds);
        }
        req.setLeaseDurationSec(leaseDurationSeconds);
        req.setVanillaQuery(query);
        for (Map.Entry<String, FieldType> entries : schema.entrySet()) {
            ProspectiveSearchPb.SchemaEntry entry = new ProspectiveSearchPb.SchemaEntry();
            entry.setName(entries.getKey());
            entry.setType(entries.getValue().internalType);
            req.addSchemaEntry(entry);
        }
        try {
            ProspectiveSearchServiceImpl.doCall("Subscribe", req, new ProspectiveSearchPb.SubscribeResponse());
        }
        catch (ApiProxy.ApplicationException e) {
            switch (ErrorPb.Error.ErrorCode.valueOf(e.getApplicationError())) {
                case BAD_REQUEST: {
                    throw new QuerySyntaxException(subId, topic, query, e.getErrorDetail());
                }
            }
            throw e;
        }
    }

    @Override
    public void unsubscribe(String topic, String subId) {
        ProspectiveSearchPb.UnsubscribeRequest req = new ProspectiveSearchPb.UnsubscribeRequest();
        req.setTopic(topic);
        req.setSubId(subId);
        try {
            ProspectiveSearchServiceImpl.doCall("Unsubscribe", req, new ProspectiveSearchPb.UnsubscribeResponse());
        }
        catch (ApiProxy.ApplicationException e) {
            switch (ErrorPb.Error.ErrorCode.valueOf(e.getApplicationError())) {
                case BAD_REQUEST: {
                    throw new IllegalArgumentException(e.getErrorDetail());
                }
            }
            throw e;
        }
    }

    @Override
    public void match(Entity entity, String topic) {
        this.match(entity, topic, "");
    }

    @Override
    public void match(Entity entity, String topic, String resultKey) {
        this.match(entity, topic, resultKey, "/_ah/prospective_search", DEFAULT_RESULT_TASK_QUEUE_NAME, 100, true);
    }

    @Override
    public void match(Entity entity, String topic, String resultKey, String relativeUrl, String taskQueueName, int batchSize, boolean resultReturnDocument) {
        ProspectiveSearchPb.MatchRequest req = new ProspectiveSearchPb.MatchRequest();
        req.setDocument(EntityTranslator.convertToPb(entity));
        req.setTopic(topic);
        req.setResultKey(resultKey);
        req.setResultRelativeUrl(relativeUrl);
        req.setResultTaskQueue(taskQueueName);
        req.setResultBatchSize(batchSize);
        if (resultReturnDocument) {
            req.setResultPythonDocumentClass(ProspectiveSearchPb.MatchRequest.PythonDocumentClass.ENTITY);
        }
        ProspectiveSearchServiceImpl.doCall("Match", req, new ProspectiveSearchPb.MatchResponse());
    }

    @Override
    public List<Subscription> listSubscriptions(String topic) {
        return this.listSubscriptions(topic, "", 1000, 0L);
    }

    @Override
    public List<Subscription> listSubscriptions(String topic, String subIdStart, int maxResults, long expiresBefore) {
        ProspectiveSearchPb.ListSubscriptionsRequest req = new ProspectiveSearchPb.ListSubscriptionsRequest();
        req.setTopic(topic);
        req.setSubscriptionIdStart(subIdStart);
        req.setMaxResults(maxResults);
        if (expiresBefore > 0L) {
            req.setExpiresBefore(expiresBefore);
        }
        ProspectiveSearchPb.ListSubscriptionsResponse rsp = new ProspectiveSearchPb.ListSubscriptionsResponse();
        ProspectiveSearchServiceImpl.doCall("ListSubscriptions", req, rsp);
        return ProspectiveSearchServiceImpl.convertSubscriptionList(rsp.subscriptions());
    }

    @Override
    public Subscription getSubscription(String topic, String subId) {
        Subscription sub;
        List<Subscription> subs = this.listSubscriptions(topic, subId, 1, 0L);
        if (subs.size() > 0 && (sub = subs.get(0)).getId().equals(subId)) {
            return sub;
        }
        throw new IllegalArgumentException(String.format("No such subscription topic: %s, id: %s", topic, subId));
    }

    @Override
    public List<String> listTopics(String topicStart, long maxResults) {
        ProspectiveSearchPb.ListTopicsRequest req = new ProspectiveSearchPb.ListTopicsRequest();
        if (!topicStart.equals("")) {
            req.setTopicStart(topicStart);
        }
        req.setMaxResults(maxResults);
        ProspectiveSearchPb.ListTopicsResponse rsp = new ProspectiveSearchPb.ListTopicsResponse();
        ProspectiveSearchServiceImpl.doCall("ListTopics", req, rsp);
        return rsp.topics();
    }

    @Override
    public Entity getDocument(HttpServletRequest matchCallbackPost) {
        try {
            byte[] docBuf = Base64.decodeWebSafe(matchCallbackPost.getParameter("document").getBytes());
            return EntityTranslator.createFromPbBytes(docBuf);
        }
        catch (IllegalArgumentException e) {
            LOGGER.log(Level.WARNING, "Could not decode returned matching message.", e);
            return null;
        }
    }

    static void doCall(String name, ProtocolMessage<?> request, ProtocolMessage<?> response) {
        byte[] serializedResponse = ApiProxy.makeSyncCall(PACKAGE, name, request.toByteArray());
        if (!response.mergeFrom(serializedResponse)) {
            throw new ApiProxy.ArgumentException(PACKAGE, name);
        }
    }

    static List<Subscription> convertSubscriptionList(List<ProspectiveSearchPb.SubscriptionRecord> from) {
        ArrayList<Subscription> to = new ArrayList<Subscription>();
        for (ProspectiveSearchPb.SubscriptionRecord internal : from) {
            to.add(new Subscription(internal));
        }
        return to;
    }
}

