/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.client.datastoreservice.intern;

import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.repackaged.com.google.net.util.error.Codes;
import com.google.appengine.repackaged.com.google.protobuf.Parser;
import com.google.apphosting.client.datastoreservice.api.DatastoreServiceRpcProto;
import com.google.apphosting.client.datastoreservice.intern.DatastoreRpcException;
import com.google.apphosting.client.datastoreservice.intern.DatastoreRpcHandler;
import com.google.apphosting.client.datastoreservice.intern.EntityV4Normalizer;
import com.google.apphosting.client.datastoreservice.intern.InternDatastoreRpcService;
import com.google.apphosting.datastore.DatastoreV4;

class WriteHandler
extends DatastoreRpcHandler<DatastoreServiceRpcProto.WriteRequest, DatastoreServiceRpcProto.WriteResponse> {
    @VisibleForTesting
    static final InternDatastoreRpcService.RpcSpec<DatastoreV4.WriteResponse> INTERN_RPC_SPEC = InternDatastoreRpcService.createRpcSpec("datastore_v4", "Write", DatastoreV4.WriteResponse.PARSER);
    private final EntityV4Normalizer entityNormalizer;

    public WriteHandler(EntityV4Normalizer entityNormalizer, InternDatastoreRpcService internDatastoreRpcService) {
        super(internDatastoreRpcService);
        this.entityNormalizer = entityNormalizer;
    }

    @Override
    public Parser<DatastoreServiceRpcProto.WriteRequest> getParser() {
        return DatastoreServiceRpcProto.WriteRequest.PARSER;
    }

    @Override
    public DatastoreServiceRpcProto.WriteResponse call(DatastoreRpcHandler.CallOptions options, DatastoreServiceRpcProto.WriteRequest apiRequest) throws DatastoreRpcException {
        DatastoreV4.WriteRequest.Builder internRequestBuilder = DatastoreV4.WriteRequest.newBuilder().setMutation(WriteHandler.convertMutation(this.entityNormalizer, apiRequest.getMutation()));
        DatastoreV4.WriteResponse internResponse = this.internDatastoreRpcService.call(INTERN_RPC_SPEC, internRequestBuilder.build()).getResponse();
        return DatastoreServiceRpcProto.WriteResponse.newBuilder().setMutationResult(WriteHandler.convertMutationResult(this.entityNormalizer, internResponse.getMutationResult())).build();
    }

    static DatastoreV4.Mutation convertMutation(EntityV4Normalizer entityNormalizer, DatastoreServiceRpcProto.Mutation apiMutation) {
        DatastoreV4.Mutation.Builder internMutation = DatastoreV4.Mutation.newBuilder();
        internMutation.addAllUpsert(entityNormalizer.normalizeEntityList(apiMutation.getUpsertList()));
        internMutation.addAllUpdate(entityNormalizer.normalizeEntityList(apiMutation.getUpdateList()));
        internMutation.addAllInsert(entityNormalizer.normalizeEntityList(apiMutation.getInsertList()));
        internMutation.addAllInsertAutoId(entityNormalizer.normalizeEntityList(apiMutation.getInsertAutoIdList()));
        internMutation.addAllDelete(entityNormalizer.normalizeKeyList(apiMutation.getDeleteList()));
        internMutation.setForce(apiMutation.getForce());
        return internMutation.build();
    }

    static DatastoreServiceRpcProto.MutationResult convertMutationResult(EntityV4Normalizer entityNormalizer, DatastoreV4.MutationResult internMutationResult) {
        DatastoreServiceRpcProto.MutationResult.Builder apiMutationResult = DatastoreServiceRpcProto.MutationResult.newBuilder();
        apiMutationResult.setIndexUpdates(internMutationResult.getIndexUpdates());
        apiMutationResult.addAllInsertAutoIdKey(internMutationResult.getInsertAutoIdKeyList());
        return apiMutationResult.build();
    }

    @Override
    public DatastoreServiceRpcProto.WriteResponse makeError(Codes.Code errorCode, String message) {
        return DatastoreServiceRpcProto.WriteResponse.newBuilder().setHeader(this.makeErrorHeader(errorCode, message)).build();
    }
}

