/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.search.checkers;

import com.google.appengine.api.search.checkers.IndexChecker;
import com.google.appengine.api.search.checkers.Preconditions;
import com.google.appengine.repackaged.com.google.common.base.Pair;
import com.google.appengine.repackaged.com.google.common.base.Strings;
import com.google.appengine.repackaged.com.google.common.collect.Sets;
import com.google.apphosting.api.search.DocumentPb;
import java.util.HashSet;

public final class DocumentChecker {
    private static final long MILLIS_UP_TO_1ST_JAN_2011 = 1293840000000L;

    public static String checkDocumentId(String documentId) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(documentId), "Document id is null or empty");
        Preconditions.checkArgument(documentId.length() <= 500, "Document id is longer than %d: %s", 500, documentId);
        Preconditions.checkArgument(IndexChecker.isAsciiVisiblePrintable(documentId), "Document id must be ASCII visible printable: %s", documentId);
        Preconditions.checkArgument(!IndexChecker.isReserved(documentId), "Document id must not start with !: %s", documentId);
        return documentId;
    }

    public static void checkFieldSet(DocumentPb.Document document) {
        HashSet<Pair<String, DocumentPb.FieldValue.ContentType>> noRepeatNames = Sets.newHashSet();
        for (DocumentPb.Field field : document.getFieldList()) {
            Pair<String, DocumentPb.FieldValue.ContentType> typedField;
            DocumentPb.FieldValue.ContentType type = field.getValue().getType();
            if (type != DocumentPb.FieldValue.ContentType.NUMBER && type != DocumentPb.FieldValue.ContentType.DATE || noRepeatNames.add(typedField = new Pair<String, DocumentPb.FieldValue.ContentType>(field.getName(), type))) continue;
            throw new IllegalArgumentException("Invalid document " + document.getId() + ": field " + field.getName() + " with type date or number may not be repeated.");
        }
    }

    public static DocumentPb.Document checkValid(DocumentPb.Document pb) {
        Preconditions.checkArgument(pb.getSerializedSize() <= 0x100000, "Document length %d is greater than the maximum %d bytes", pb.getSerializedSize(), 0x100000);
        if (pb.hasId()) {
            DocumentChecker.checkDocumentId(pb.getId());
        }
        DocumentChecker.mandatoryCheckValid(pb);
        return pb;
    }

    static void mandatoryCheckValid(DocumentPb.Document pb) {
        Preconditions.checkArgument(!pb.getFieldList().isEmpty(), "Empty list of fields in document for indexing");
        DocumentChecker.checkFieldSet(pb);
    }

    public static int getNumberOfSecondsSince() {
        long millisSince = Math.max(0L, (System.currentTimeMillis() - 1293840000000L) / 1000L);
        Preconditions.checkArgument(millisSince <= Integer.MAX_VALUE, "API failure due to date conversion overflow");
        return (int)millisSince;
    }
}

