/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.client.datastoreservice.intern;

import com.google.appengine.repackaged.com.google.common.collect.Lists;
import com.google.apphosting.datastore.EntityV4;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

class EntityV4Normalizer {
    private final EntityV4.PartitionId defaultPartitionId;

    public EntityV4Normalizer(String defaultDatasetId) {
        this.defaultPartitionId = EntityV4.PartitionId.newBuilder().setDatasetId(defaultDatasetId).build();
    }

    private boolean isNormalPartitionId(@Nullable EntityV4.PartitionIdOrBuilder partitionId) {
        return partitionId != null && partitionId.hasDatasetId();
    }

    public EntityV4.PartitionId normalizePartitionId(@Nullable EntityV4.PartitionId partitionId) {
        if (this.isNormalPartitionId(partitionId)) {
            return partitionId;
        }
        if (partitionId == null) {
            return this.defaultPartitionId;
        }
        EntityV4.PartitionId.Builder normalizedPartitionIdBuidler = partitionId.toBuilder();
        normalizedPartitionIdBuidler.setDatasetId(this.defaultPartitionId.getDatasetId());
        return normalizedPartitionIdBuidler.build();
    }

    private boolean isNormalKey(EntityV4.KeyOrBuilder key) {
        return key.hasPartitionId() && key.getPartitionId().hasDatasetId();
    }

    public EntityV4.Key normalizeKey(EntityV4.Key key) {
        if (this.isNormalKey(key)) {
            return key;
        }
        EntityV4.Key.Builder normalizedKeyBuilder = key.toBuilder();
        normalizedKeyBuilder.setPartitionId(this.normalizePartitionId(key.getPartitionId()));
        return normalizedKeyBuilder.build();
    }

    private boolean isNormalValue(EntityV4.ValueOrBuilder value, int remainingRecursionAllowed) {
        if (value.hasKeyValue() ? !this.isNormalKey(value.getKeyValue()) : value.hasEntityValue() && !this.isNormalEntity(value.getEntityValue(), remainingRecursionAllowed)) {
            return false;
        }
        for (EntityV4.ValueOrBuilder valueOrBuilder : value.getListValueList()) {
            if (this.isNormalValue(valueOrBuilder, remainingRecursionAllowed)) continue;
            return false;
        }
        return true;
    }

    private boolean isNormalEntity(EntityV4.EntityOrBuilder entity, int remainingRecursionAllowed) {
        if (remainingRecursionAllowed <= 0) {
            return false;
        }
        --remainingRecursionAllowed;
        if (entity.hasKey() && !this.isNormalKey(entity.getKey())) {
            return false;
        }
        for (EntityV4.PropertyOrBuilder propertyOrBuilder : entity.getPropertyOrBuilderList()) {
            if (propertyOrBuilder.hasValue() && !this.isNormalValue(propertyOrBuilder.getValueOrBuilder(), remainingRecursionAllowed)) {
                return false;
            }
            for (EntityV4.ValueOrBuilder valueOrBuilder : propertyOrBuilder.getDeprecatedValueOrBuilderList()) {
                if (this.isNormalValue(valueOrBuilder, remainingRecursionAllowed)) continue;
                return false;
            }
        }
        return true;
    }

    private EntityV4.Value normalizeValue(EntityV4.Value value) {
        if (value.hasKeyValue()) {
            EntityV4.Key key = value.getKeyValue();
            EntityV4.Key normalizedKey = this.normalizeKey(key);
            if (normalizedKey != key) {
                EntityV4.Value.Builder valueBuilder = value.toBuilder();
                valueBuilder.setKeyValue(normalizedKey);
                return valueBuilder.build();
            }
        } else if (value.hasEntityValue()) {
            EntityV4.Entity subEntity = value.getEntityValue();
            EntityV4.Entity normalizedSubEntity = this.normalizeEntity(subEntity);
            if (normalizedSubEntity != subEntity) {
                EntityV4.Value.Builder valueBuilder = value.toBuilder();
                valueBuilder.setEntityValue(normalizedSubEntity);
                return valueBuilder.build();
            }
        } else if (value.getListValueCount() > 0) {
            EntityV4.Value.Builder valueBuilder = null;
            for (int index = 0; index < value.getListValueCount(); ++index) {
                EntityV4.Value normalizedSubValue;
                EntityV4.Value subValue = value.getListValue(index);
                if (subValue == (normalizedSubValue = this.normalizeValue(subValue))) continue;
                if (valueBuilder == null) {
                    valueBuilder = value.toBuilder();
                }
                valueBuilder.setListValue(index, normalizedSubValue);
            }
            if (valueBuilder != null) {
                return valueBuilder.build();
            }
        }
        return value;
    }

    public EntityV4.Entity normalizeEntity(EntityV4.Entity entity) {
        if (this.isNormalEntity(entity, 2)) {
            return entity;
        }
        EntityV4.Entity.Builder entityBuilder = entity.toBuilder();
        if (entityBuilder.hasKey()) {
            entityBuilder.setKey(this.normalizeKey(entityBuilder.getKey()));
        }
        for (int propertyIndex = 0; propertyIndex < entityBuilder.getPropertyCount(); ++propertyIndex) {
            EntityV4.Value normalizedValue;
            EntityV4.PropertyOrBuilder property = entityBuilder.getPropertyOrBuilder(propertyIndex);
            if (property.hasValue() && (normalizedValue = this.normalizeValue(property.getValue())) != property.getValue()) {
                entityBuilder.getPropertyBuilder(propertyIndex).setValue(normalizedValue);
            }
            for (int valueIndex = 0; valueIndex < property.getDeprecatedValueCount(); ++valueIndex) {
                EntityV4.Entity subEntity;
                EntityV4.Entity normalizedSubEntity;
                EntityV4.Value.Builder valueBuilder;
                EntityV4.ValueOrBuilder value = property.getDeprecatedValueOrBuilder(valueIndex);
                if (value.hasKeyValue()) {
                    EntityV4.Key key = value.getKeyValue();
                    EntityV4.Key normalizedKey = this.normalizeKey(key);
                    if (normalizedKey == key) continue;
                    valueBuilder = entityBuilder.getPropertyBuilder(propertyIndex).getDeprecatedValueBuilder(valueIndex);
                    valueBuilder.setKeyValue(normalizedKey);
                    continue;
                }
                if (!value.hasEntityValue() || (normalizedSubEntity = this.normalizeEntity(subEntity = value.getEntityValue())) == subEntity) continue;
                valueBuilder = entityBuilder.getPropertyBuilder(propertyIndex).getDeprecatedValueBuilder(valueIndex);
                valueBuilder.setEntityValue(normalizedSubEntity);
            }
        }
        return entityBuilder.build();
    }

    public List<EntityV4.Key> normalizeKeyList(List<EntityV4.Key> keyList) {
        ArrayList<EntityV4.Key> normalizedKeyList = Lists.newArrayListWithCapacity(keyList.size());
        for (EntityV4.Key key : keyList) {
            normalizedKeyList.add(this.normalizeKey(key));
        }
        return normalizedKeyList;
    }

    public List<EntityV4.Entity> normalizeEntityList(List<EntityV4.Entity> entityList) {
        ArrayList<EntityV4.Entity> normalizedEntityList = Lists.newArrayListWithCapacity(entityList.size());
        for (EntityV4.Entity entity : entityList) {
            normalizedEntityList.add(this.normalizeEntity(entity));
        }
        return normalizedEntityList;
    }
}

