/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.AppIdNamespace;
import com.google.appengine.api.datastore.AsyncDatastoreService;
import com.google.appengine.api.datastore.BaseDatastoreServiceImpl;
import com.google.appengine.api.datastore.Batcher;
import com.google.appengine.api.datastore.CurrentTransactionProvider;
import com.google.appengine.api.datastore.DatastoreApiHelper;
import com.google.appengine.api.datastore.DatastoreAttributes;
import com.google.appengine.api.datastore.DatastoreServiceConfig;
import com.google.appengine.api.datastore.DeleteContext;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.EntityCachingStrategy;
import com.google.appengine.api.datastore.EntityNotFoundException;
import com.google.appengine.api.datastore.EntityTranslator;
import com.google.appengine.api.datastore.FutureHelper;
import com.google.appengine.api.datastore.ImplicitTransactionManagementPolicy;
import com.google.appengine.api.datastore.Index;
import com.google.appengine.api.datastore.IndexTranslator;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.KeyRange;
import com.google.appengine.api.datastore.KeyTranslator;
import com.google.appengine.api.datastore.MultiQueryBuilder;
import com.google.appengine.api.datastore.PostDeleteFuture;
import com.google.appengine.api.datastore.PostLoadFuture;
import com.google.appengine.api.datastore.PostPutFuture;
import com.google.appengine.api.datastore.PreGetContext;
import com.google.appengine.api.datastore.PreQueryContext;
import com.google.appengine.api.datastore.PreparedMultiQuery;
import com.google.appengine.api.datastore.PreparedQuery;
import com.google.appengine.api.datastore.PreparedQueryImpl;
import com.google.appengine.api.datastore.PutContext;
import com.google.appengine.api.datastore.Query;
import com.google.appengine.api.datastore.QuerySplitHelper;
import com.google.appengine.api.datastore.ReadPolicy;
import com.google.appengine.api.datastore.Transaction;
import com.google.appengine.api.datastore.TransactionImpl;
import com.google.appengine.api.datastore.TransactionOptions;
import com.google.appengine.api.datastore.TransactionStack;
import com.google.appengine.api.utils.FutureWrapper;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.com.google.common.collect.Lists;
import com.google.appengine.repackaged.com.google.common.collect.Sets;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolMessage;
import com.google.apphosting.api.ApiBasePb;
import com.google.apphosting.api.DatastorePb;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;

class AsyncDatastoreServiceImpl
extends BaseDatastoreServiceImpl
implements AsyncDatastoreService,
CurrentTransactionProvider {
    private final V3KeyBatcher<DatastorePb.DeleteResponse, DatastorePb.DeleteRequest> deleteBatcher = new V3KeyBatcher<DatastorePb.DeleteResponse, DatastorePb.DeleteRequest>(){

        @Override
        void addToBatch(OnestoreEntity.Reference value, DatastorePb.DeleteRequest batch) {
            batch.addKey(value);
        }

        @Override
        int getMaxCount() {
            return AsyncDatastoreServiceImpl.this.datastoreServiceConfig.maxBatchWriteEntities;
        }

        @Override
        protected Future<DatastorePb.DeleteResponse> makeCall(DatastorePb.DeleteRequest batch) {
            return DatastoreApiHelper.makeAsyncCall(AsyncDatastoreServiceImpl.this.apiConfig, "Delete", batch, new DatastorePb.DeleteResponse());
        }
    };
    private final V3KeyBatcher<DatastorePb.GetResponse, DatastorePb.GetRequest> getBatcher = new V3KeyBatcher<DatastorePb.GetResponse, DatastorePb.GetRequest>(){

        @Override
        void addToBatch(OnestoreEntity.Reference value, DatastorePb.GetRequest batch) {
            batch.addKey(value);
        }

        @Override
        int getMaxCount() {
            return AsyncDatastoreServiceImpl.this.datastoreServiceConfig.maxBatchReadEntities;
        }

        @Override
        protected Future<DatastorePb.GetResponse> makeCall(DatastorePb.GetRequest batch) {
            return DatastoreApiHelper.makeAsyncCall(AsyncDatastoreServiceImpl.this.apiConfig, "Get", batch, new DatastorePb.GetResponse());
        }
    };
    private final V3Batcher<DatastorePb.PutResponse, DatastorePb.PutRequest, Entity, OnestoreEntity.EntityProto> putBatcher = new V3Batcher<DatastorePb.PutResponse, DatastorePb.PutRequest, Entity, OnestoreEntity.EntityProto>(){

        @Override
        Object getGroup(Entity value) {
            return value.getKey().getRootKey();
        }

        @Override
        void addToBatch(OnestoreEntity.EntityProto value, DatastorePb.PutRequest batch) {
            batch.addEntity(value);
        }

        @Override
        int getMaxCount() {
            return AsyncDatastoreServiceImpl.this.datastoreServiceConfig.maxBatchWriteEntities;
        }

        @Override
        protected Future<DatastorePb.PutResponse> makeCall(DatastorePb.PutRequest batch) {
            return DatastoreApiHelper.makeAsyncCall(AsyncDatastoreServiceImpl.this.apiConfig, "Put", batch, new DatastorePb.PutResponse());
        }

        @Override
        OnestoreEntity.EntityProto toPb(Entity value) {
            return EntityTranslator.convertToPb(value);
        }
    };
    private DatastoreAttributes.DatastoreType datastoreType;

    public AsyncDatastoreServiceImpl(DatastoreServiceConfig datastoreServiceConfig, TransactionStack defaultTxnProvider) {
        super(AsyncDatastoreServiceImpl.validateDatastoreServiceConfig(datastoreServiceConfig), defaultTxnProvider);
    }

    private static DatastoreServiceConfig validateDatastoreServiceConfig(DatastoreServiceConfig datastoreServiceConfig) {
        if (datastoreServiceConfig.getImplicitTransactionManagementPolicy() == ImplicitTransactionManagementPolicy.AUTO) {
            throw new IllegalArgumentException("The async datastore service does not support an implicit transaction management policy of AUTO");
        }
        return datastoreServiceConfig;
    }

    @Override
    public Future<Entity> get(Key key) {
        BaseDatastoreServiceImpl.GetOrCreateTransactionResult result = this.getOrCreateTransaction();
        return this.get(result.getTransaction(), key);
    }

    @Override
    public Future<Entity> get(Transaction txn, final Key key) {
        if (key == null) {
            throw new NullPointerException("key cannot be null");
        }
        Future<Map<Key, Entity>> entities = this.get(txn, Arrays.asList(key));
        return new FutureWrapper<Map<Key, Entity>, Entity>(entities){

            @Override
            protected Entity wrap(Map<Key, Entity> entities) throws Exception {
                Entity entity = entities.get(key);
                if (entity == null) {
                    throw new EntityNotFoundException(key);
                }
                return entity;
            }

            @Override
            protected Throwable convertException(Throwable cause) {
                return cause;
            }
        };
    }

    @Override
    public Future<Map<Key, Entity>> get(Iterable<Key> keys) {
        BaseDatastoreServiceImpl.GetOrCreateTransactionResult result = this.getOrCreateTransaction();
        return this.get(result.getTransaction(), keys);
    }

    @Override
    public Future<Map<Key, Entity>> get(Transaction txn, Iterable<Key> keys) {
        if (keys == null) {
            throw new NullPointerException("keys cannot be null");
        }
        ArrayList<Key> keyList = Lists.newArrayList(keys);
        HashMap<Key, Entity> resultMap = new HashMap<Key, Entity>();
        PreGetContext preGetContext = new PreGetContext(this, keyList, resultMap);
        this.datastoreServiceConfig.getDatastoreCallbacks().executePreGetCallbacks(preGetContext);
        if (!resultMap.isEmpty()) {
            keyList.removeAll(resultMap.keySet());
        }
        EntityCachingStrategy.PreGetCachingResult preGetCachingResult = this.entityCachingStrategy.preGet(this, keyList, resultMap);
        keyList.removeAll(preGetCachingResult.getKeysToSkipLoading());
        Future<Map<Key, Entity>> result = this.doBatchGet(txn, keyList, resultMap);
        result = this.entityCachingStrategy.createPostGetFuture(result, preGetCachingResult);
        return new PostLoadFuture(result, this.datastoreServiceConfig.getDatastoreCallbacks(), this);
    }

    private Future<Map<Key, Entity>> doBatchGet(Transaction txn, final List<Key> keys, final Map<Key, Entity> resultMap) {
        boolean group;
        DatastorePb.GetRequest baseReq = new DatastorePb.GetRequest();
        boolean bl = group = this.getDatastoreType() != DatastoreAttributes.DatastoreType.MASTER_SLAVE;
        if (txn != null) {
            TransactionImpl.ensureTxnActive(txn);
            baseReq.setTransaction(AsyncDatastoreServiceImpl.localTxnToRemoteTxn(txn));
            group = false;
        }
        if (this.datastoreServiceConfig.getReadPolicy().getConsistency() == ReadPolicy.Consistency.EVENTUAL) {
            baseReq.setFailoverMs(-1L);
            baseReq.setStrong(false);
            group = false;
        }
        ArrayList<Integer> order = Lists.newArrayList();
        Iterator<DatastorePb.GetRequest> batches = this.getBatcher.getBatches(keys, baseReq, group, order);
        List futures = this.getBatcher.makeCalls(batches);
        return this.registerInTransaction(txn, new Batcher.ReorderingMultiFuture<DatastorePb.GetResponse, Map<Key, Entity>>(futures, order){

            @Override
            protected Map<Key, Entity> initResult(int size) {
                return resultMap;
            }

            @Override
            protected Map<Key, Entity> aggregate(DatastorePb.GetResponse response, Iterator<Integer> indexItr, Map<Key, Entity> results) {
                for (DatastorePb.GetResponse.Entity responseEntity : response.entitys()) {
                    int index = indexItr.next();
                    if (!responseEntity.hasEntity()) continue;
                    Key key = (Key)keys.get(index);
                    results.put(key, EntityTranslator.createFromPb(responseEntity.getEntity()));
                }
                return results;
            }
        });
    }

    @Override
    public Future<Key> put(Entity entity) {
        BaseDatastoreServiceImpl.GetOrCreateTransactionResult result = this.getOrCreateTransaction();
        return this.put(result.getTransaction(), entity);
    }

    @Override
    public Future<Key> put(Transaction txn, Entity entity) {
        return new FutureWrapper<List<Key>, Key>(this.put(txn, Arrays.asList(entity))){

            @Override
            protected Key wrap(List<Key> keys) throws Exception {
                return keys.get(0);
            }

            @Override
            protected Throwable convertException(Throwable cause) {
                return cause;
            }
        };
    }

    @Override
    public Future<List<Key>> put(Iterable<Entity> entities) {
        BaseDatastoreServiceImpl.GetOrCreateTransactionResult result = this.getOrCreateTransaction();
        return this.put(result.getTransaction(), entities);
    }

    @Override
    public Future<List<Key>> put(Transaction txn, Iterable<Entity> entities) {
        ArrayList<Entity> entitiesToPut;
        ArrayList<Entity> entityList = List.class.isAssignableFrom(entities.getClass()) ? (ArrayList<Entity>)entities : Lists.newArrayList(entities);
        PutContext prePutContext = new PutContext((CurrentTransactionProvider)this, (List<Entity>)entityList);
        this.datastoreServiceConfig.getDatastoreCallbacks().executePrePutCallbacks(prePutContext);
        EntityCachingStrategy.PreMutationCachingResult preMutationCachingResult = this.entityCachingStrategy.prePut(this, entityList);
        ArrayList<Batcher.IndexedItem<Key>> indexedKeysToSkip = Lists.newArrayList();
        Set<Key> mutationKeysToSkip = preMutationCachingResult.getMutationKeysToSkip();
        if (!mutationKeysToSkip.isEmpty()) {
            entitiesToPut = Lists.newArrayList();
            int index = 0;
            for (Entity entity : entityList) {
                if (mutationKeysToSkip.contains(entity.getKey())) {
                    indexedKeysToSkip.add(new Batcher.IndexedItem<Key>(index++, entity.getKey()));
                    continue;
                }
                entitiesToPut.add(entity);
                ++index;
            }
        } else {
            entitiesToPut = ImmutableList.copyOf(entities);
        }
        PostPutFuture result = this.combinePutResult(this.doBatchPut(txn, entitiesToPut), indexedKeysToSkip);
        if (txn == null) {
            result = this.entityCachingStrategy.createPostMutationFuture(result, preMutationCachingResult);
            PutContext postPutContext = new PutContext((CurrentTransactionProvider)this, (List<Entity>)entityList);
            result = new PostPutFuture(result, this.datastoreServiceConfig.getDatastoreCallbacks(), postPutContext);
        } else {
            this.defaultTxnProvider.addPutEntities(txn, entityList);
        }
        return result;
    }

    private Future<List<Key>> combinePutResult(Future<List<Key>> rpcResult, final List<Batcher.IndexedItem<Key>> skippedKeys) {
        if (skippedKeys.isEmpty()) {
            return rpcResult;
        }
        return new FutureWrapper<List<Key>, List<Key>>(rpcResult){

            @Override
            protected List<Key> wrap(List<Key> result) throws Exception {
                LinkedList<Key> combined = Lists.newLinkedList(result);
                for (Batcher.IndexedItem indexedKey : skippedKeys) {
                    combined.add(indexedKey.index, (Key)indexedKey.item);
                }
                return combined;
            }

            @Override
            protected Throwable convertException(Throwable cause) {
                return cause;
            }
        };
    }

    private Future<List<Key>> doBatchPut(Transaction txn, final List<Entity> entities) {
        DatastorePb.PutRequest baseReq = new DatastorePb.PutRequest();
        if (txn != null) {
            TransactionImpl.ensureTxnActive(txn);
            baseReq.setTransaction(AsyncDatastoreServiceImpl.localTxnToRemoteTxn(txn));
        }
        boolean group = !baseReq.hasTransaction();
        ArrayList<Integer> order = Lists.newArrayListWithCapacity(entities.size());
        Iterator<DatastorePb.PutRequest> batches = this.putBatcher.getBatches(entities, baseReq, group, order);
        List<Future<DatastorePb.PutResponse>> futures = this.putBatcher.makeCalls(batches);
        return this.registerInTransaction(txn, new Batcher.ReorderingMultiFuture<DatastorePb.PutResponse, List<Key>>(futures, order){

            @Override
            protected List<Key> aggregate(DatastorePb.PutResponse intermediateResult, Iterator<Integer> indexItr, List<Key> result) {
                for (OnestoreEntity.Reference reference : intermediateResult.keys()) {
                    int index = indexItr.next();
                    Key key = ((Entity)entities.get(index)).getKey();
                    KeyTranslator.updateKey(reference, key);
                    result.set(index, key);
                }
                return result;
            }

            @Override
            protected List<Key> initResult(int size) {
                ArrayList<Object> result = new ArrayList<Object>(Collections.nCopies(size, null));
                return result;
            }
        });
    }

    @Override
    public Future<Void> delete(Key ... keys) {
        BaseDatastoreServiceImpl.GetOrCreateTransactionResult result = this.getOrCreateTransaction();
        return this.delete(result.getTransaction(), keys);
    }

    @Override
    public Future<Void> delete(Transaction txn, Key ... keys) {
        return this.delete(txn, Arrays.asList(keys));
    }

    @Override
    public Future<Void> delete(Iterable<Key> keys) {
        BaseDatastoreServiceImpl.GetOrCreateTransactionResult result = this.getOrCreateTransaction();
        return this.delete(result.getTransaction(), keys);
    }

    @Override
    public Future<Void> delete(Transaction txn, Iterable<Key> keys) {
        AbstractCollection keysToDelete;
        ImmutableList<Key> allKeys = List.class.isAssignableFrom(keys.getClass()) ? (ImmutableList<Key>)keys : ImmutableList.copyOf(keys);
        DeleteContext preDeleteContext = new DeleteContext((CurrentTransactionProvider)this, (List<Key>)allKeys);
        this.datastoreServiceConfig.getDatastoreCallbacks().executePreDeleteCallbacks(preDeleteContext);
        EntityCachingStrategy.PreMutationCachingResult preMutationCachingResult = this.entityCachingStrategy.preDelete(this, allKeys);
        PostDeleteFuture result = null;
        Set<Key> keysToSkip = preMutationCachingResult.getMutationKeysToSkip();
        if (keysToSkip.isEmpty()) {
            keysToDelete = allKeys;
        } else {
            HashSet<Key> keySet = Sets.newHashSet(allKeys);
            keySet.removeAll(keysToSkip);
            keysToDelete = keySet;
        }
        result = this.doBatchDelete(txn, keysToDelete);
        if (txn == null) {
            result = this.entityCachingStrategy.createPostMutationFuture(result, preMutationCachingResult);
            result = new PostDeleteFuture(result, this.datastoreServiceConfig.getDatastoreCallbacks(), new DeleteContext((CurrentTransactionProvider)this, (List<Key>)allKeys));
        } else {
            this.defaultTxnProvider.addDeletedKeys(txn, allKeys);
        }
        return result;
    }

    private Future<Void> doBatchDelete(Transaction txn, Collection<Key> keys) {
        DatastorePb.DeleteRequest baseReq = new DatastorePb.DeleteRequest();
        if (txn != null) {
            TransactionImpl.ensureTxnActive(txn);
            baseReq.setTransaction(AsyncDatastoreServiceImpl.localTxnToRemoteTxn(txn));
        }
        boolean group = !baseReq.hasTransaction();
        Iterator<DatastorePb.DeleteRequest> batches = this.deleteBatcher.getBatches(keys, baseReq, group);
        List futures = this.deleteBatcher.makeCalls(batches);
        return this.registerInTransaction(txn, new FutureHelper.MultiFuture<DatastorePb.DeleteResponse, Void>(futures){

            @Override
            public Void get() throws InterruptedException, ExecutionException {
                for (Future future : this.futures) {
                    future.get();
                }
                return null;
            }

            @Override
            public Void get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                for (Future future : this.futures) {
                    future.get(timeout, unit);
                }
                return null;
            }
        });
    }

    @Override
    public Collection<Transaction> getActiveTransactions() {
        return this.defaultTxnProvider.getAll();
    }

    private <T> Future<T> registerInTransaction(Transaction txn, Future<T> future) {
        if (txn != null) {
            this.defaultTxnProvider.addFuture(txn, future);
            return new FutureHelper.TxnAwareFuture<T>(future, txn, this.defaultTxnProvider);
        }
        return future;
    }

    @Override
    public Future<Transaction> beginTransaction() {
        return this.beginTransaction(TransactionOptions.Builder.withDefaults());
    }

    @Override
    public Future<Transaction> beginTransaction(TransactionOptions options) {
        return new FutureHelper.FakeFuture<Transaction>(this.beginTransactionInternal(options));
    }

    @Override
    public PreparedQuery prepare(Query query) {
        return this.prepare(null, query);
    }

    @Override
    public PreparedQuery prepare(Transaction txn, Query query) {
        PreQueryContext context = new PreQueryContext((CurrentTransactionProvider)this, query);
        this.datastoreServiceConfig.getDatastoreCallbacks().executePreQueryCallbacks(context);
        query = (Query)context.getElements().get(0);
        AsyncDatastoreServiceImpl.validateQuery(query);
        List<MultiQueryBuilder> queriesToRun = QuerySplitHelper.splitQuery(query);
        query.setFilter(null);
        query.getFilterPredicates().clear();
        if (queriesToRun.size() == 1 && queriesToRun.get(0).isSingleton()) {
            query.getFilterPredicates().addAll(queriesToRun.get(0).getBaseFilters());
            return new PreparedQueryImpl(this.apiConfig, this.datastoreServiceConfig, query, txn);
        }
        return new PreparedMultiQuery(this.apiConfig, this.datastoreServiceConfig, query, queriesToRun, txn);
    }

    @Override
    public Future<KeyRange> allocateIds(String kind, long num) {
        return this.allocateIds(null, kind, num);
    }

    static OnestoreEntity.Reference buildAllocateIdsRef(Key parent, String kind, AppIdNamespace appIdNamespace) {
        if (parent != null && !parent.isComplete()) {
            throw new IllegalArgumentException("parent key must be complete");
        }
        Key key = new Key(kind, parent, 0L, "ignored", appIdNamespace);
        return KeyTranslator.convertToPb(key);
    }

    @Override
    public Future<KeyRange> allocateIds(final Key parent, final String kind, long num) {
        if (num <= 0L) {
            throw new IllegalArgumentException("num must be > 0");
        }
        if (num > 1000000000L) {
            throw new IllegalArgumentException("num must be < 1 billion");
        }
        final AppIdNamespace appIdNamespace = this.datastoreServiceConfig.getAppIdNamespace();
        OnestoreEntity.Reference allocateIdsRef = AsyncDatastoreServiceImpl.buildAllocateIdsRef(parent, kind, appIdNamespace);
        DatastorePb.AllocateIdsRequest req = new DatastorePb.AllocateIdsRequest().setSize(num).setModelKey(allocateIdsRef);
        DatastorePb.AllocateIdsResponse resp = new DatastorePb.AllocateIdsResponse();
        Future<DatastorePb.AllocateIdsResponse> future = DatastoreApiHelper.makeAsyncCall(this.apiConfig, "AllocateIds", req, resp);
        return new FutureWrapper<DatastorePb.AllocateIdsResponse, KeyRange>(future){

            @Override
            protected KeyRange wrap(DatastorePb.AllocateIdsResponse resp) throws Exception {
                return new KeyRange(parent, kind, resp.getStart(), resp.getEnd(), appIdNamespace);
            }

            @Override
            protected Throwable convertException(Throwable cause) {
                return cause;
            }
        };
    }

    protected DatastoreAttributes.DatastoreType getDatastoreType() {
        if (this.datastoreType == null) {
            this.datastoreType = FutureHelper.quietGet(this.getDatastoreAttributes()).getDatastoreType();
        }
        return this.datastoreType;
    }

    @Override
    public Future<DatastoreAttributes> getDatastoreAttributes() {
        String appId = this.datastoreServiceConfig.getAppIdNamespace().getAppId();
        DatastoreAttributes attributes = new DatastoreAttributes(appId);
        return new FutureHelper.FakeFuture<DatastoreAttributes>(attributes);
    }

    @Override
    public Future<Map<Index, Index.IndexState>> getIndexes() {
        ApiBasePb.StringProto req = new ApiBasePb.StringProto();
        req.setValue(this.datastoreServiceConfig.getAppIdNamespace().getAppId());
        return new FutureWrapper<DatastorePb.CompositeIndices, Map<Index, Index.IndexState>>(DatastoreApiHelper.makeAsyncCall(this.apiConfig, "GetIndices", req, new DatastorePb.CompositeIndices())){

            @Override
            protected Map<Index, Index.IndexState> wrap(DatastorePb.CompositeIndices indices) throws Exception {
                LinkedHashMap<Index, Index.IndexState> answer = new LinkedHashMap<Index, Index.IndexState>();
                block6: for (OnestoreEntity.CompositeIndex ci : indices.indexs()) {
                    Index index = IndexTranslator.convertFromPb(ci);
                    switch (ci.getStateEnum()) {
                        case DELETED: {
                            answer.put(index, Index.IndexState.DELETING);
                            continue block6;
                        }
                        case ERROR: {
                            answer.put(index, Index.IndexState.ERROR);
                            continue block6;
                        }
                        case READ_WRITE: {
                            answer.put(index, Index.IndexState.SERVING);
                            continue block6;
                        }
                        case WRITE_ONLY: {
                            answer.put(index, Index.IndexState.BUILDING);
                            continue block6;
                        }
                    }
                    AsyncDatastoreServiceImpl.this.logger.log(Level.WARNING, "Unrecognized index state for " + index);
                }
                return answer;
            }

            @Override
            protected Throwable convertException(Throwable cause) {
                return cause;
            }
        };
    }

    private abstract class V3KeyBatcher<S extends ProtocolMessage<S>, R extends ProtocolMessage<R>>
    extends V3Batcher<S, R, Key, OnestoreEntity.Reference> {
        private V3KeyBatcher() {
        }

        @Override
        final Object getGroup(Key value) {
            return value.getRootKey();
        }

        @Override
        final OnestoreEntity.Reference toPb(Key value) {
            return KeyTranslator.convertToPb(value);
        }
    }

    private abstract class V3Batcher<S extends ProtocolMessage<S>, R extends ProtocolMessage<R>, F, T extends ProtocolMessage<T>>
    extends Batcher<R, F, T> {
        private V3Batcher() {
        }

        protected abstract Future<S> makeCall(R var1);

        @Override
        final R newBatch(R baseBatch) {
            return (R)((ProtocolMessage)baseBatch).clone();
        }

        @Override
        final int getMaxSize() {
            return AsyncDatastoreServiceImpl.this.datastoreServiceConfig.maxRpcSizeBytes;
        }

        @Override
        final int getMaxGroups() {
            return AsyncDatastoreServiceImpl.this.datastoreServiceConfig.maxEntityGroupsPerRpc;
        }

        final List<Future<S>> makeCalls(Iterator<R> batches) {
            ArrayList<Future<S>> futures = new ArrayList<Future<S>>();
            while (batches.hasNext()) {
                futures.add(this.makeCall((ProtocolMessage)batches.next()));
            }
            return futures;
        }
    }
}

