/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.client.datastoreservice.app;

import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.repackaged.com.google.common.base.Function;
import com.google.appengine.repackaged.com.google.common.collect.Lists;
import com.google.appengine.repackaged.com.google.net.util.error.Codes;
import com.google.appengine.repackaged.com.google.protobuf.Parser;
import com.google.apphosting.client.datastoreservice.app.DatastoreRpcHandler;
import com.google.apphosting.client.datastoreservice.app.EquivalentMessageConverter;
import com.google.apphosting.client.datastoreservice.app.InternDatastoreRpcService;
import com.google.apphosting.client.datastoreservice.proto.DatastoreService;
import com.google.apphosting.client.serviceapp.RpcException;
import com.google.apphosting.client.serviceapp.RpcHandler;
import com.google.apphosting.datastore.DatastoreV4;
import com.google.apphosting.datastore.EntityV4;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

class LookupHandler
extends DatastoreRpcHandler<DatastoreService.LookupRequest, DatastoreService.LookupResponse> {
    @VisibleForTesting
    static final int INTERN_MAX_KEYS_PER_REQUEST = 1000;
    @VisibleForTesting
    static final InternDatastoreRpcService.RpcSpec<DatastoreV4.LookupResponse> INTERN_RPC_SPEC = InternDatastoreRpcService.createRpcSpec("datastore_v4", "Lookup", DatastoreV4.LookupResponse.PARSER);
    public static final Function<DatastoreService.ReadOptions, DatastoreV4.ReadOptions> READ_OPTIONS_CONVERTER = EquivalentMessageConverter.create(DatastoreV4.ReadOptions.PARSER);
    private final Function<EntityV4.Key, EntityV4.Key> inputKeyTransform;
    private final Function<DatastoreV4.EntityResult, DatastoreService.EntityResult> outputEntityResultTransform;

    LookupHandler(InternDatastoreRpcService internService, Function<EntityV4.Key, EntityV4.Key> inputKeyTransform, Function<DatastoreV4.EntityResult, DatastoreService.EntityResult> outputEntityResultTransform) {
        super(internService);
        this.inputKeyTransform = inputKeyTransform;
        this.outputEntityResultTransform = outputEntityResultTransform;
    }

    @Override
    public Parser<DatastoreService.LookupRequest> getParser() {
        return DatastoreService.LookupRequest.PARSER;
    }

    @Override
    public Class<DatastoreService.LookupRequest> getRequestClass() {
        return DatastoreService.LookupRequest.class;
    }

    @Override
    public DatastoreService.LookupResponse call(RpcHandler.CallOptions callOptions, DatastoreService.LookupRequest req) throws RpcException {
        DatastoreV4.ReadOptions internReadOptions = req.hasReadOptions() ? READ_OPTIONS_CONVERTER.apply(req.getReadOptions()) : null;
        ArrayList<EntityV4.Key> internRequestKeyList = Lists.newArrayList(Lists.transform(req.getKeyList(), this.inputKeyTransform));
        int numRemainingApiResponseBytes = callOptions.getMaxResponseBytes() - this.determineNumKeyAndOverheadApiResponseBytes(internRequestKeyList);
        if (numRemainingApiResponseBytes < 0) {
            throw new RpcException(Codes.Code.INVALID_ARGUMENT, "Too many keys for the response size limit.");
        }
        DatastoreV4.LookupRequest internReq = this.createInternRequest(internReadOptions, internRequestKeyList);
        InternDatastoreRpcService.ResponseFutureWrapper<DatastoreV4.LookupResponse> internResponseFutureWrapper = this.internService.call(INTERN_RPC_SPEC, internReq);
        DatastoreService.LookupResponse.Builder res = DatastoreService.LookupResponse.newBuilder();
        do {
            DatastoreV4.LookupResponse internRes = internResponseFutureWrapper.getResponse();
            internRequestKeyList.addAll(internRes.getDeferredList());
            if (internRequestKeyList.isEmpty()) {
                internResponseFutureWrapper = null;
            } else {
                internReq = this.createInternRequest(internReadOptions, internRequestKeyList);
                internResponseFutureWrapper = this.internService.call(INTERN_RPC_SPEC, internReq);
            }
            res.addAllMissing(Lists.transform(internRes.getMissingList(), this.outputEntityResultTransform));
            for (DatastoreV4.EntityResult internFoundEntityResult : internRes.getFoundList()) {
                DatastoreService.EntityResult foundEntityResult = this.outputEntityResultTransform.apply(internFoundEntityResult);
                int numNonKeyBytes = foundEntityResult.getSerializedSize() - foundEntityResult.getEntity().getKey().getSerializedSize();
                if (numNonKeyBytes > numRemainingApiResponseBytes) {
                    internResponseFutureWrapper = null;
                    res.addDeferred(foundEntityResult.getEntity().getKey());
                    continue;
                }
                res.addFound(foundEntityResult);
                numRemainingApiResponseBytes -= numNonKeyBytes;
            }
        } while (internResponseFutureWrapper != null);
        res.addAllDeferred(internRequestKeyList);
        return res.build();
    }

    private int determineNumKeyAndOverheadApiResponseBytes(List<EntityV4.Key> adjustedRequestApiKeyList) {
        int numKeyAndOverheadApiResponseBytes = 0;
        for (EntityV4.Key adjustedRequestApiKey : adjustedRequestApiKeyList) {
            numKeyAndOverheadApiResponseBytes = numKeyAndOverheadApiResponseBytes + adjustedRequestApiKey.getSerializedSize() + 10;
        }
        return numKeyAndOverheadApiResponseBytes;
    }

    private DatastoreV4.LookupRequest createInternRequest(@Nullable DatastoreV4.ReadOptions internReadOptions, List<EntityV4.Key> internRequestKeyList) {
        DatastoreV4.LookupRequest.Builder internRequestBuilder = DatastoreV4.LookupRequest.newBuilder();
        if (internReadOptions != null) {
            internRequestBuilder.setReadOptions(internReadOptions);
        }
        List<EntityV4.Key> internLimitedRequestKeyList = internRequestKeyList.size() <= 1000 ? internRequestKeyList : internRequestKeyList.subList(0, 1000);
        internRequestBuilder.addAllKey(internLimitedRequestKeyList);
        internLimitedRequestKeyList.clear();
        return internRequestBuilder.build();
    }

    @Override
    public DatastoreService.LookupResponse makeError(Codes.Code errorCode, String message) {
        return DatastoreService.LookupResponse.newBuilder().setHeader(LookupHandler.makeErrorHeader(errorCode, message)).build();
    }
}

