/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.flags;

import com.google.appengine.repackaged.com.google.common.flags.AmbiguousFlagException;
import com.google.appengine.repackaged.com.google.common.flags.DocLevel;
import com.google.appengine.repackaged.com.google.common.flags.ExternalFlagsLoadException;
import com.google.appengine.repackaged.com.google.common.flags.Flag;
import com.google.appengine.repackaged.com.google.common.flags.FlagDescription;
import com.google.appengine.repackaged.com.google.common.flags.FlagException;
import com.google.appengine.repackaged.com.google.common.flags.FlagInfo;
import com.google.appengine.repackaged.com.google.common.flags.FlagSpec;
import com.google.appengine.repackaged.com.google.common.flags.FlagsExtension;
import com.google.appengine.repackaged.com.google.common.flags.IllegalFlagStateException;
import com.google.appengine.repackaged.com.google.common.flags.InvalidFlagSyntaxException;
import com.google.appengine.repackaged.com.google.common.flags.InvalidFlagValueException;
import com.google.appengine.repackaged.com.google.common.flags.InvalidFlagsException;
import com.google.appengine.repackaged.com.google.common.flags.MalformedFlagDescriptionException;
import com.google.appengine.repackaged.com.google.common.flags.UnrecognizedFlagException;
import com.google.appengine.repackaged.com.google.common.flags.XmlSupport;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;

public class Flags {
    private static final Collection<Runnable> completionHooks = new ArrayList<Runnable>();
    private static final Logger logger = Logger.getLogger(Flags.class.getName());
    private static final String DISABLE_EXIT = "com.google.appengine.repackaged.com.google.common.flags.noExit";
    private static PrintStream outputStream = System.out;
    public static final String DISABLE_CHECKING = "com.google.appengine.repackaged.com.google.common.flags.disableStateChecking";
    private static final String CLASS_LOADER = "com.google.appengine.repackaged.com.google.common.flags.classLoader";
    static final String ENABLE_FLAG_EXTENSION = "com.google.appengine.repackaged.com.google.common.flags.useFlagsExtension";
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static ParseState parseState = ParseState.NOT_STARTED;
    @Nullable
    private static Throwable parseStackTrace;
    @Nullable
    private static String usagePrefix;
    private static final Set<String> preferredClasses;
    @Nullable
    private static ClassLoader flagClassLoader;
    private static final String UNDEF_OK_FLAG_NAME = "undefok";
    @Nullable
    private static final String cachedMainClassName;
    @FlagSpec(name="force_ignore_nonflag_arguments", help="Emergency override Flags.parse()'s strictness: Ignore non-flag arguments instead of throwing an exception. For emergencies only: Instead of setting this flag, switch to parseAndReturnLeftovers() when possible.")
    static final Flag<Boolean> forceIgnoreNonflagArguments;
    @FlagSpec(name="show_all_arguments_for_nonflag_errors", help="When Flags.parse() detects non-flag arguments, make the exception message include all arguments instead of only the non-flag arguments.")
    private static final Flag<Boolean> showAllArgumentsForNonflagErrors;
    private static final String NON_FLAG_MESSAGE = "Received unexpected non-flag argument (see <http://go/non-flag-parameter>). ";
    private static final Pattern HELP_PATTERN;
    private static final Pattern HELPSHORT_PATTERN;
    private static final Pattern XML_HELP_PATTERN;
    private static final Pattern FLAG_PATTERN;
    private static final Pattern FLAG_FILE_PATTERN;
    private static final Pattern FLAG_RESOURCE_PATTERN;
    private static final Pattern BLANK_LINE_PATTERN;
    private static final Pattern COMMENT_LINE_PATTERN;
    private static final Pattern FLAG_NAME_PATTERN;

    private Flags() {
    }

    static void setOutputStreamForTesting(PrintStream stream) {
        outputStream = stream;
    }

    static void resetOutputStreamForTesting() {
        outputStream = System.out;
    }

    @Nullable
    private static String getMainClassNameFromStackTrace(StackTraceElement[] stack) {
        StackTraceElement stackRoot;
        String methodName;
        if (stack.length > 0 && ("main".equals(methodName = (stackRoot = stack[stack.length - 1]).getMethodName()) || "<clinit>".equals(methodName))) {
            return stackRoot.getClassName();
        }
        return null;
    }

    public static void setFlagClassLoader(@Nullable ClassLoader loader) {
        flagClassLoader = loader;
    }

    static Map<String, FlagDescription> canonicalFlagMap() {
        Map<String, FlagDescription> canonicalFlagMap = FlagMapHolder.canonicalFlagMap;
        if (canonicalFlagMap == null) {
            canonicalFlagMap = Flags.initCanonicalFlagMap();
        }
        return canonicalFlagMap;
    }

    private static Map<String, Set<FlagDescription>> expandedFlagMap() {
        Map<String, Set<FlagDescription>> expandedFlagMap = FlagMapHolder.expandedFlagMap;
        if (expandedFlagMap == null) {
            expandedFlagMap = Flags.initExpandedFlagMap();
        }
        return expandedFlagMap;
    }

    @Nullable
    private static FlagDescription getBestFlag(String flag) {
        Set<FlagDescription> allDesc = Flags.expandedFlagMap().get(flag);
        if (allDesc == null) {
            return null;
        }
        if (allDesc.size() == 1) {
            return allDesc.iterator().next();
        }
        FlagDescription result = null;
        for (FlagDescription desc : allDesc) {
            if (!preferredClasses.contains(desc.getContainerClassName())) continue;
            if (result != null) {
                return null;
            }
            result = desc;
        }
        return result;
    }

    private static Map<String, Flag<?>> manuallyRegisteredFlags() {
        return FlagMapHolder.manuallyRegisteredFlags;
    }

    private static Map<String, FlagDescription> longNameMap() {
        return FlagMapHolder.longNameMap;
    }

    static void clearFlagMapsForTesting() {
        Flags.reallyClearFlagMapsForTesting();
        FlagMapHolder.longNameMap = Flags.loadFlagManifests();
    }

    static void reallyClearFlagMapsForTesting() {
        parseState = ParseState.NOT_STARTED;
        FlagMapHolder.longNameMap.clear();
        FlagMapHolder.canonicalFlagMap = null;
        FlagMapHolder.expandedFlagMap = null;
        FlagMapHolder.manuallyRegisteredFlags.clear();
        FlagMapHolder.whitelistedPrefixes = null;
    }

    public static void clearFlagData() {
        if (parseState != ParseState.DONE) {
            throw new IllegalStateException("Flag parsing must be completed");
        }
        FlagMapHolder.manuallyRegisteredFlags.clear();
        FlagMapHolder.canonicalFlagMap = Collections.emptyMap();
        FlagMapHolder.expandedFlagMap = Collections.emptyMap();
        FlagMapHolder.whitelistedPrefixes = null;
        FlagMapHolder.longNameMap = Collections.emptyMap();
    }

    private static Map<String, Set<FlagDescription>> initExpandedFlagMap() {
        FlagMapHolder.expandedFlagMap = Flags.expandFlagMap(Flags.longNameMap().values());
        return FlagMapHolder.expandedFlagMap;
    }

    private static Map<String, FlagDescription> initCanonicalFlagMap() {
        FlagMapHolder.canonicalFlagMap = Flags.createCanonicalFlagMap(Flags.longNameMap().values(), Flags.initExpandedFlagMap());
        return FlagMapHolder.canonicalFlagMap;
    }

    private static void initMaps() {
        Flags.initCanonicalFlagMap();
    }

    private static Map<String, FlagDescription> loadFlagManifests() {
        HashMap<String, FlagDescription> map = new HashMap<String, FlagDescription>();
        ClassLoader myLoader = Flags.getFlagManifestClassLoader();
        try {
            Enumeration<URL> flagURLs = myLoader.getResources("flags.xml");
            while (flagURLs.hasMoreElements()) {
                URL url = flagURLs.nextElement();
                BufferedInputStream is = new BufferedInputStream(url.openStream());
                try {
                    XmlSupport.fromXml(is, map);
                }
                catch (MalformedFlagDescriptionException ex) {
                    throw new MalformedFlagDescriptionException("Failed to parse " + url, ex);
                }
                finally {
                    ((InputStream)is).close();
                }
            }
        }
        catch (IOException ex) {
            throw new AssertionError((Object)ex);
        }
        return map;
    }

    private static ClassLoader getFlagManifestClassLoader() {
        String className = System.getProperty(CLASS_LOADER);
        if (className != null && className.length() > 0) {
            try {
                ClassLoader loader = (ClassLoader)Class.forName(className).newInstance();
                logger.info("User specified classloader: " + className);
                return loader;
            }
            catch (InstantiationException e) {
                logger.log(Level.WARNING, String.format("Couldn't instantiate ClassLoader '%s'", className), e);
            }
            catch (IllegalAccessException e) {
                logger.log(Level.WARNING, String.format("Couldn't instantiate ClassLoader '%s'", className), e);
            }
            catch (ClassNotFoundException e) {
                logger.log(Level.WARNING, String.format("Couldn't instantiate ClassLoader '%s'", className), e);
            }
        }
        return FlagDescription.checkStateNotNull(Flags.class.getClassLoader());
    }

    static List<String> getAllNamesForFlag(FlagDescription flag) {
        LinkedHashSet<String> aliases = new LinkedHashSet<String>();
        if (Flags.whitelistAllowsAliasing(flag)) {
            if (flag.getAltName() != null) {
                aliases.add(flag.getAltName());
            }
            aliases.add(flag.getShortFlagName());
        }
        aliases.add(flag.getLongFlagName());
        if (!flag.isShortFlagNameSpecified()) {
            aliases.add(flag.getFullyQualifiedFieldName());
        }
        if (flag.getType().equals("java.lang.Boolean")) {
            aliases.addAll(Flags.getNoPrefixedAliases(aliases));
        }
        return new ArrayList<String>(aliases);
    }

    private static List<String> getNoPrefixedAliases(Iterable<String> names) {
        ArrayList<String> noPrefixedAliases = new ArrayList<String>();
        for (String name : names) {
            noPrefixedAliases.add("no" + name);
        }
        return noPrefixedAliases;
    }

    private static boolean whitelistAllowsAliasing(FlagDescription flag) {
        Collection<String> whitelistedPrefixes = FlagMapHolder.whitelistedPrefixes;
        if (whitelistedPrefixes == null) {
            return true;
        }
        for (String prefix : whitelistedPrefixes) {
            if (!prefix.equals(flag.getLongFlagName()) && (!flag.isField() || !prefix.equals(flag.getFullyQualifiedFieldName())) && (!prefix.endsWith(".") || !flag.getLongFlagName().startsWith(prefix))) continue;
            return true;
        }
        return false;
    }

    static Map<String, Set<FlagDescription>> expandFlagMap(Collection<FlagDescription> flags) {
        HashMap<String, HashSet<FlagDescription>> allNames = new HashMap<String, HashSet<FlagDescription>>();
        for (FlagDescription flagDescription : flags) {
            FlagDescription flagDescription2 = FlagDescription.checkStateNotNull(flagDescription);
            for (String alias : Flags.getAllNamesForFlag(flagDescription2)) {
                HashSet<FlagDescription> dups = (HashSet<FlagDescription>)allNames.get(alias);
                if (dups == null) {
                    dups = new HashSet<FlagDescription>();
                    allNames.put(alias, dups);
                }
                dups.add(flagDescription2);
            }
        }
        for (Map.Entry entry : allNames.entrySet()) {
            String key = (String)entry.getKey();
            Set dups = (Set)FlagDescription.checkStateNotNull(entry.getValue());
            if (dups.size() <= 1) continue;
            StringBuilder b = new StringBuilder();
            for (FlagDescription d : dups) {
                b.append(d.getLongFlagName());
                b.append(',');
            }
            logger.log(Level.FINE, "Flag {0} is not a unique short form because {1} flags use it: {2}", new Object[]{key, dups.size(), b});
        }
        return Collections.unmodifiableMap(allNames);
    }

    static Map<String, FlagDescription> createCanonicalFlagMap(Collection<FlagDescription> flags, Map<String, Set<FlagDescription>> expandedFlagMap) {
        HashMap<String, FlagDescription> canonicalMap = new HashMap<String, FlagDescription>();
        for (FlagDescription flag : flags) {
            flag = FlagDescription.checkStateNotNull(flag);
            canonicalMap.put(Flags.getBestFlagName(flag, expandedFlagMap), flag);
        }
        return canonicalMap;
    }

    private static String getBestFlagName(FlagDescription flag, Map<String, Set<FlagDescription>> expandedFlagMap) {
        for (String alias : Flags.getAllNamesForFlag(flag)) {
            Set<FlagDescription> descs = expandedFlagMap.get(alias = FlagDescription.checkStateNotNull(alias));
            if (descs == null || descs.size() != 1) continue;
            return alias;
        }
        throw new AssertionError((Object)"Must be one unique name for flag?!");
    }

    private static void maybeSyslogOnStart(String[] args) {
        try {
            String mainClassName = Flags.getMainClassName();
            if (mainClassName == null) {
                return;
            }
            InetAddress addr = InetAddress.getLocalHost();
            String hostname = addr.getHostName();
            if (!hostname.contains(".corp.google.com")) {
                return;
            }
            Class<?> cls = Class.forName("com.sun.security.auth.module.UnixSystem");
            Object clsObj = cls.newInstance();
            Method clsMeth = cls.getMethod("getUid", new Class[0]);
            Object result = clsMeth.invoke(clsObj, new Object[0]);
            Long uid = (Long)result;
            String toolLogProtoStr = " log_path:\"" + mainClassName + "\"" + " language:\"java\"" + " tool_type:\"cmdline\"" + " uid:" + uid + " host_name:\"" + hostname + "\"" + " log_timestamp:" + System.currentTimeMillis() / 1000L + " logger:\"logger_java\"";
            StringBuilder argvStr = new StringBuilder();
            for (String argv : args) {
                argvStr.append(" argv:\"" + argv + "\"");
            }
            String loggerPath = "/usr/lib/crudd/log_usage";
            ProcessBuilder pb = new File("/usr/lib/crudd/log_usage").exists() ? new ProcessBuilder("/usr/lib/crudd/log_usage", "--tool_log_proto", toolLogProtoStr + argvStr) : new ProcessBuilder("/usr/bin/logger", "ToolLogProto: logjam_tag=tattler_initgoogle " + toolLogProtoStr);
            Process p = pb.start();
            p.getInputStream().close();
            p.getOutputStream().close();
            p.getErrorStream().close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void parse(String[] args) {
        String[] result = Flags.parseAndReturnLeftovers(args);
        if (result.length > 0 && !FlagDescription.checkStateNotNull(forceIgnoreNonflagArguments.get()).booleanValue()) {
            if (FlagDescription.checkStateNotNull(showAllArgumentsForNonflagErrors.get()).booleanValue()) {
                throw new IllegalArgumentException("Received unexpected non-flag argument (see <http://go/non-flag-parameter>). Full argument list: " + Flags.asJavaSourceString(args));
            }
            throw new IllegalArgumentException("Received unexpected non-flag argument (see <http://go/non-flag-parameter>). Unexpected argument(s): " + Flags.asJavaSourceString(result));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckReturnValue
    public static String[] parseAndReturnLeftovers(String[] args) {
        Runnable[] completionHooks;
        FlagDescription.checkNotNull(args, "args array cannot be null");
        String[] result = null;
        Flags.maybeSyslogOnStart(args);
        try {
            Flags.setParseState(ParseState.IN_PROGRESS);
            result = Flags.parseInternal(args);
            Class<Flags> clazz = Flags.class;
            synchronized (Flags.class) {
                Flags.setParseState(ParseState.DONE);
                completionHooks = Flags.completionHooks.toArray(new Runnable[0]);
                // ** MonitorExit[var2_2] (shouldn't be in output)
            }
        }
        catch (FlagException ex) {
            throw new InvalidFlagsException(ex.getMessage(), ex);
        }
        {
            for (Runnable r : completionHooks) {
                r.run();
            }
            logger.fine("The current default charset is " + Charset.defaultCharset().name());
            return result;
        }
    }

    @Deprecated
    public static void parseStrict(String[] args) {
        Flags.parse(args);
    }

    private static String asJavaSourceString(String[] in) {
        Object[] out = new String[in.length];
        for (int i = 0; i < in.length; ++i) {
            out[i] = Flags.asJavaSourceString(in[i]);
        }
        return Arrays.toString(out);
    }

    private static String asJavaSourceString(String s) {
        String content = s.replaceAll("\\\\", "\\\\\\\\").replaceAll("\\\b", "\\\\b").replaceAll("\\\t", "\\\\t").replaceAll("\\\n", "\\\\n").replaceAll("\\\f", "\\\\f").replaceAll("\\\r", "\\\\r").replaceAll("\\\"", "\\\\\"");
        return '\"' + content + '\"';
    }

    private static boolean printRequestedHelp(String arg) {
        if (HELP_PATTERN.matcher(arg).matches()) {
            Flags.usage(outputStream, false, usagePrefix);
            return true;
        }
        if (HELPSHORT_PATTERN.matcher(arg).matches()) {
            Flags.usage(outputStream, true, usagePrefix);
            return true;
        }
        if (XML_HELP_PATTERN.matcher(arg).matches()) {
            Flags.xmlUsage(new PrintWriter(outputStream));
            return true;
        }
        return false;
    }

    private static void exitUnlessDisabled(int status) {
        if (!Boolean.getBoolean(DISABLE_EXIT)) {
            System.exit(status);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String[] parseInternal(String[] commandLineArgs) throws AmbiguousFlagException, ExternalFlagsLoadException, InvalidFlagSyntaxException, InvalidFlagValueException, UnrecognizedFlagException {
        List<String> unknownFlags;
        Flags.initMaps();
        String[] args = Flags.loadExternalFlags(commandLineArgs);
        ArrayList<String> nonFlagArgs = new ArrayList<String>();
        ArrayList<String> unrecognizedFlags = new ArrayList<String>();
        TreeSet<String> acceptableUnrecognizedFlags = new TreeSet<String>();
        for (int i = 0; i < args.length; ++i) {
            boolean guessingNextArgIsValue;
            String valueString;
            String flagName;
            block19: {
                FlagDescription description;
                String arg;
                block20: {
                    arg = args[i];
                    if (!arg.startsWith("-")) {
                        nonFlagArgs.add(arg);
                        continue;
                    }
                    if (arg.equals("--")) {
                        while (++i < args.length) {
                            nonFlagArgs.add(args[i]);
                        }
                        break;
                    }
                    if (Flags.printRequestedHelp(arg)) {
                        List<String> unknownFlags2 = Flags.getUnknownFlags(unrecognizedFlags, acceptableUnrecognizedFlags);
                        if (!unknownFlags2.isEmpty()) {
                            outputStream.println("Unrecognized flags: " + unknownFlags2);
                        }
                        Flags.exitUnlessDisabled(unknownFlags2.isEmpty() ? 0 : 1);
                        return EMPTY_STRING_ARRAY;
                    }
                    Matcher m = FLAG_PATTERN.matcher(arg);
                    if (!m.matches()) {
                        throw new InvalidFlagSyntaxException(arg);
                    }
                    flagName = m.group(1);
                    if (flagName.trim().equals("")) {
                        throw new InvalidFlagSyntaxException(arg);
                    }
                    valueString = m.group(2);
                    description = Flags.getBestFlag(flagName);
                    guessingNextArgIsValue = false;
                    if (valueString != null) break block20;
                    if (description != null && Flags.isBooleanFlag(description)) {
                        valueString = String.valueOf(description.isPositiveFormOfName(flagName));
                        flagName = description.getLongFlagName();
                        break block19;
                    } else if (Flags.isLegitimateFlag(description) || UNDEF_OK_FLAG_NAME.equals(flagName)) {
                        if (i == args.length - 1) {
                            throw new InvalidFlagSyntaxException(arg + " is missing a value");
                        }
                        valueString = FlagDescription.checkStateNotNull(args[++i]);
                        guessingNextArgIsValue = true;
                        break block19;
                    } else {
                        unrecognizedFlags.add(flagName);
                        continue;
                    }
                }
                if (description != null && Flags.isBooleanFlag(description) && !description.isPositiveFormOfName(flagName)) {
                    throw new InvalidFlagSyntaxException(arg);
                }
            }
            if (UNDEF_OK_FLAG_NAME.equals(flagName)) {
                for (String fn : valueString.split(",")) {
                    acceptableUnrecognizedFlags.add(fn);
                }
                continue;
            }
            try {
                Flags.processFlag(flagName, valueString);
                continue;
            }
            catch (UnrecognizedFlagException e) {
                unrecognizedFlags.add(flagName);
                if (!guessingNextArgIsValue) continue;
                --i;
            }
        }
        if ((unknownFlags = Flags.getUnknownFlags(unrecognizedFlags, acceptableUnrecognizedFlags)).size() > 0) {
            throw new UnrecognizedFlagException(unknownFlags);
        }
        return nonFlagArgs.toArray(EMPTY_STRING_ARRAY);
    }

    private static List<String> getUnknownFlags(List<String> unrecognizedFlags, Set<String> acceptableUnrecognizedFlags) {
        ArrayList<String> unknownFlags = new ArrayList<String>();
        for (String flagName : unrecognizedFlags) {
            if (acceptableUnrecognizedFlags.contains(flagName) || flagName.startsWith("no") && acceptableUnrecognizedFlags.contains(flagName.substring(2))) continue;
            unknownFlags.add(flagName);
        }
        return unknownFlags;
    }

    private static String[] loadExternalFlags(String[] args) throws InvalidFlagSyntaxException, ExternalFlagsLoadException {
        ArrayList<String> collatedArgs = new ArrayList<String>();
        for (String arg : args) {
            arg = FlagDescription.checkStateNotNull(arg);
            try {
                Matcher fileMatcher = FLAG_FILE_PATTERN.matcher(arg);
                Matcher resourceMatcher = FLAG_RESOURCE_PATTERN.matcher(arg);
                if (fileMatcher.matches()) {
                    String file = FlagDescription.checkStateNotNull(fileMatcher.group(1));
                    Flags.appendExternalFlagsFromFile(collatedArgs, file, arg);
                    continue;
                }
                if (resourceMatcher.matches()) {
                    String resource = FlagDescription.checkStateNotNull(resourceMatcher.group(1));
                    Flags.appendExternalFlagsFromResource(collatedArgs, resource, arg);
                    continue;
                }
                collatedArgs.add(arg);
            }
            catch (IOException exc) {
                throw new ExternalFlagsLoadException(arg);
            }
        }
        return collatedArgs.toArray(EMPTY_STRING_ARRAY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void appendExternalFlagsFromResource(List<String> collatedArgs, String resource, String arg) throws ExternalFlagsLoadException, InvalidFlagSyntaxException, IOException {
        ClassLoader contextClassLoader;
        InputStream resourceStream = Flags.class.getResourceAsStream(resource);
        if (resourceStream == null && (contextClassLoader = Thread.currentThread().getContextClassLoader()) != null) {
            resourceStream = contextClassLoader.getResourceAsStream(resource);
        }
        if (resourceStream == null) {
            throw new ExternalFlagsLoadException(arg);
        }
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(resourceStream));
            Flags.appendExternalFlags(reader, collatedArgs);
        }
        finally {
            resourceStream.close();
        }
    }

    private static void appendExternalFlagsFromFile(List<String> collatedArgs, String file, String arg) throws InvalidFlagSyntaxException, IOException, ExternalFlagsLoadException {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(file));
            Flags.appendExternalFlags(reader, collatedArgs);
        }
        catch (FileNotFoundException exc) {
            throw new ExternalFlagsLoadException(arg);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    private static void appendExternalFlags(BufferedReader reader, List<String> collatedArgs) throws InvalidFlagSyntaxException, ExternalFlagsLoadException, IOException {
        String line = reader.readLine();
        while (line != null) {
            if (FLAG_PATTERN.matcher(line).matches()) {
                if (FLAG_FILE_PATTERN.matcher(line).matches() || FLAG_RESOURCE_PATTERN.matcher(line).matches()) {
                    String[] fileFlag = new String[]{line};
                    collatedArgs.addAll(Arrays.asList(Flags.loadExternalFlags(fileFlag)));
                } else {
                    collatedArgs.add(line);
                }
            } else if (!BLANK_LINE_PATTERN.matcher(line).matches() && !COMMENT_LINE_PATTERN.matcher(line).matches()) {
                throw new InvalidFlagSyntaxException(line);
            }
            line = reader.readLine();
        }
    }

    public static void processFlag(String flagName, @Nullable String flagValue) throws UnrecognizedFlagException, InvalidFlagValueException, AmbiguousFlagException {
        FlagDescription.checkNotNull(flagName);
        FlagDescription desc = Flags.getBestFlag(flagName);
        if (desc == null) {
            Set<FlagDescription> allDesc = Flags.expandedFlagMap().get(flagName);
            if (allDesc == null || allDesc.size() == 0) {
                throw new UnrecognizedFlagException(flagName);
            }
            throw new AmbiguousFlagException(flagName, allDesc);
        }
        try {
            Flags.flag(desc).setFromString(flagValue);
        }
        catch (NullPointerException e) {
            InvalidFlagValueException newException = new InvalidFlagValueException("NullPointerException");
            newException.flagName = desc.getLongFlagName();
            newException.flagValue = "null";
            throw newException;
        }
        catch (InvalidFlagValueException e) {
            e.flagName = desc.getLongFlagName();
            e.flagValue = flagValue;
            throw e;
        }
        catch (IllegalFlagStateException e) {
            e.flagName = desc.getLongFlagName();
            throw e;
        }
    }

    private static boolean isBooleanFlag(FlagDescription desc) {
        return desc.getType().equals("java.lang.Boolean");
    }

    private static boolean isLegitimateFlag(@Nullable FlagDescription description) {
        return description != null;
    }

    @Nullable
    private static Object getFlagContainerObject(Class<?> containerClass) throws NoSuchFieldException, IllegalAccessException {
        return Boolean.getBoolean(ENABLE_FLAG_EXTENSION) ? FlagsExtension.getFlagContainerObject(containerClass) : null;
    }

    static Flag<?> flag(FlagDescription desc) {
        Flag<?> flag = Flags.manuallyRegisteredFlags().get(desc.getLongFlagName());
        if (flag != null) {
            return flag;
        }
        try {
            Class<?> containerClass = Flags.loadClass(desc.getContainerClassName());
            Field field = containerClass.getDeclaredField(desc.getSimpleFieldName());
            field.setAccessible(true);
            Object container = Flags.getFlagContainerObject(containerClass);
            return (Flag)field.get(container);
        }
        catch (ClassNotFoundException ex) {
            throw new LinkageError("Class for flag field " + desc.getFullyQualifiedFieldName() + " present in manifest, absent at runtime: " + ex.toString());
        }
        catch (NoSuchFieldException ex) {
            throw new LinkageError("Flag field " + desc.getFullyQualifiedFieldName() + " present in manifest, absent at runtime: " + ex.toString());
        }
        catch (IllegalAccessException ex) {
            throw new LinkageError("Unable to get flag field " + desc.getFullyQualifiedFieldName() + ": " + ex.toString());
        }
        catch (NullPointerException ex) {
            throw new LinkageError("Forgot to make the flag static? " + desc.getFullyQualifiedFieldName() + ": " + ex.toString());
        }
        catch (ClassCastException ex) {
            throw new LinkageError("Cannot convert field " + desc.getSimpleFieldName() + " to a Flag in order to resolve " + desc.getFullyQualifiedFieldName() + ": " + ex.toString());
        }
    }

    private static Class<?> loadClass(String name) throws ClassNotFoundException {
        while (true) {
            try {
                if (flagClassLoader != null) {
                    return Class.forName(name, true, flagClassLoader);
                }
                return Class.forName(name);
            }
            catch (ClassNotFoundException e) {
                int idx = name.lastIndexOf(46);
                if (idx < 0) {
                    throw e;
                }
                name = name.substring(0, idx) + "$" + name.substring(idx + 1, name.length());
                continue;
            }
            break;
        }
    }

    private static void formatFlag(PrintStream printStream, String flagName, String flagDescription, @Nullable String defaultString) {
        StringBuilder b = new StringBuilder();
        b.append("   --").append(flagName).append(" ").append(flagDescription);
        if (defaultString != null) {
            b.append("; default: ").append(defaultString);
        }
        int LINE_LIMIT = 70;
        while (b.length() > 70) {
            int space = b.lastIndexOf(" ", 70);
            if (space == -1) {
                space = b.indexOf(" ", 70);
            }
            if (space < 10) break;
            printStream.println(b.substring(0, space));
            b.replace(0, space + 1, "      ");
        }
        if (b.length() != 0) {
            printStream.println(b);
        }
    }

    static Set<Map.Entry<String, FlagDescription>> sortFlags(boolean shortForm) {
        String mainClassName = Flags.getMainClassName();
        TreeSet<Map.Entry<String, FlagDescription>> entries = new TreeSet<Map.Entry<String, FlagDescription>>(new Comparator<Map.Entry<String, FlagDescription>>(){

            @Override
            public int compare(Map.Entry<String, FlagDescription> o1, Map.Entry<String, FlagDescription> o2) {
                FlagDescription d1 = FlagDescription.checkStateNotNull(o1.getValue());
                FlagDescription d2 = FlagDescription.checkStateNotNull(o2.getValue());
                int cls = d1.getContainerClassName().compareTo(d2.getContainerClassName());
                return cls == 0 ? d1.getShortFlagName().compareTo(d2.getShortFlagName()) : cls;
            }
        });
        for (Map.Entry<String, FlagDescription> e : Flags.canonicalFlagMap().entrySet()) {
            FlagDescription descr = FlagDescription.checkStateNotNull(e.getValue());
            if (!Flags.whitelistAllowsAliasing(descr) || shortForm && mainClassName != null && !descr.getContainerClassName().equals(mainClassName)) continue;
            entries.add(e);
        }
        return entries;
    }

    public static void setUsagePrefix(@Nullable String usgPrefix) {
        usagePrefix = usgPrefix;
    }

    @Nullable
    public static String getUsagePrefix() {
        return usagePrefix;
    }

    public static void usage(PrintStream printStream) {
        Flags.usage(printStream, false, usagePrefix);
    }

    public static void usage(PrintStream printStream, @Nullable String usgPrefix) {
        Flags.usage(printStream, false, usgPrefix);
    }

    public static void usage(PrintStream printStream, boolean shortForm, @Nullable String usgPrefix) {
        FlagDescription.checkNotNull(printStream);
        if (usgPrefix == null) {
            usgPrefix = String.format("Usage: java [jvm-flags...] %s [flags...] [args...]", Flags.getProgramName());
        }
        Flags.initMaps();
        printStream.println(usgPrefix);
        printStream.println("where flags are");
        printStream.println(" Standard flags:");
        Flags.formatFlag(printStream, "help", "describes all flags", null);
        Flags.formatFlag(printStream, "helpshort", "describes the main class' flags", null);
        Flags.formatFlag(printStream, "helpxml", "emits XML description of all flags", null);
        String previousClass = "";
        for (Map.Entry<String, FlagDescription> e : Flags.sortFlags(shortForm)) {
            String flagName = FlagDescription.checkStateNotNull(e.getKey());
            FlagDescription descr = FlagDescription.checkStateNotNull(e.getValue());
            if (descr.getDocLevel() != DocLevel.PUBLIC) continue;
            if (!descr.getContainerClassName().equals(previousClass)) {
                printStream.println();
                printStream.println("  Flags for " + descr.getContainerClassName() + ":");
                previousClass = descr.getContainerClassName();
            }
            Flags.formatFlag(printStream, flagName, descr.getDoc(), Flags.getDefaultAsString(Flags.flag(descr)));
        }
    }

    @Nullable
    public static String getMainClassName() {
        return cachedMainClassName;
    }

    private static String valueToString(@Nullable Object defaultValue) {
        StringBuilder b = new StringBuilder();
        if (defaultValue instanceof List) {
            List v = (List)defaultValue;
            boolean first = true;
            for (Object o : v) {
                if (!first) {
                    b.append(",");
                }
                b.append(o);
                first = false;
            }
        } else if (defaultValue instanceof Class) {
            b.append(((Class)defaultValue).getName());
        } else {
            b.append(defaultValue);
        }
        return b.toString();
    }

    @Nullable
    private static <T> String getDefaultAsString(Flag<T> flag) {
        T defaultValue = flag.getDefault();
        if (defaultValue == null) {
            return null;
        }
        try {
            return flag.parsableStringValue(defaultValue);
        }
        catch (UnsupportedOperationException uoe) {
            return Flags.valueToString(defaultValue);
        }
    }

    @Nullable
    private static String getAsString(Flag<?> flag) {
        try {
            return flag.parsableStringValue();
        }
        catch (UnsupportedOperationException uoe) {
            return Flags.valueToString(flag.get());
        }
    }

    public static void xmlUsage(PrintWriter out) {
        FlagDescription.checkNotNull(out);
        out.print("<?xml version=\"1.0\" encoding=\"UTF-8\"?><AllFlags>");
        out.print(XmlSupport.toXmlElement("program", Flags.getProgramName()));
        out.print(XmlSupport.toXmlElement("usage", Flags.getProgramName()));
        TreeMap<String, FlagDescription> sortedMap = new TreeMap<String, FlagDescription>(Flags.canonicalFlagMap());
        for (Map.Entry e : sortedMap.entrySet()) {
            String name = (String)e.getKey();
            FlagDescription description = (FlagDescription)FlagDescription.checkStateNotNull(e.getValue());
            if (!Flags.whitelistAllowsAliasing(description) || description.getDocLevel() != DocLevel.PUBLIC) continue;
            Flag<?> flag = Flags.flag(description);
            out.print("<flag>");
            out.print(XmlSupport.toXmlElement("file", description.getContainerClassName()));
            out.print(XmlSupport.toXmlElement("name", "--" + name));
            if (description.getAltName() != null) {
                out.print(XmlSupport.toXmlElement("shortname", "--" + description.getShortFlagName()));
            }
            out.print(XmlSupport.toXmlElement("meaning", description.getDoc()));
            out.print(XmlSupport.toXmlElement("default", String.valueOf(Flags.getDefaultAsString(flag))));
            out.print(XmlSupport.toXmlElement("current", String.valueOf(Flags.getAsString(flag))));
            out.print(XmlSupport.toXmlElement("type", Flags.simpleType(description.getType())));
            out.print("</flag>");
        }
        out.print("</AllFlags>");
        out.flush();
    }

    private static String getProgramName() {
        String progname = "unknown";
        StackTraceElement[] frames = new Throwable().getStackTrace();
        if (frames != null && frames.length > 0) {
            progname = frames[frames.length - 1].getClassName();
        }
        return progname;
    }

    private static String simpleType(String typeClassName) {
        if ("java.lang.Integer".equals(typeClassName)) {
            return "int";
        }
        if ("java.lang.Long".equals(typeClassName)) {
            return "long";
        }
        if ("java.lang.Float".equals(typeClassName)) {
            return "float";
        }
        if ("java.lang.Double".equals(typeClassName)) {
            return "double";
        }
        if ("java.lang.String".equals(typeClassName)) {
            return "string";
        }
        if ("java.lang.Boolean".equals(typeClassName)) {
            return "boolean";
        }
        return typeClassName;
    }

    public static synchronized void registerFlag(String containerClassName, String simpleName, String doc, @Nullable String altName, DocLevel doclevel, String type, Flag<?> flag) {
        FlagDescription.checkNotNull(new Object[]{containerClassName, simpleName, doc, doclevel, type, flag});
        FlagDescription description = FlagDescription.createManuallyRegisteredFlag(simpleName, containerClassName).doc(doc).altName(altName).docLevel(doclevel).type(type).build();
        if (altName != null && !FLAG_NAME_PATTERN.matcher(altName).matches()) {
            throw new IllegalArgumentException("Alternate flag name must contain only alphanumeric characters, hyphens, and underscores.");
        }
        Map<String, FlagDescription> longNameMap = Flags.longNameMap();
        if (longNameMap.containsKey(description.getLongFlagName()) && !Flags.stateCheckingDisabled()) {
            throw new IllegalStateException("Duplicate flag " + description.getLongFlagName());
        }
        longNameMap.put(description.getLongFlagName(), description);
        Flags.manuallyRegisteredFlags().put(description.getLongFlagName(), flag);
        FlagMapHolder.canonicalFlagMap = null;
        FlagMapHolder.expandedFlagMap = null;
    }

    public static void setAllowedFlags(@Nullable Collection<String> allowedPrefixes) {
        FlagMapHolder.whitelistedPrefixes = allowedPrefixes == null ? null : new LinkedHashSet<String>(allowedPrefixes);
        FlagMapHolder.expandedFlagMap = null;
        FlagMapHolder.canonicalFlagMap = null;
    }

    @Nullable
    public static Collection<String> getAllowedFlags() {
        if (FlagMapHolder.whitelistedPrefixes == null) {
            return null;
        }
        return new LinkedHashSet<String>(FlagMapHolder.whitelistedPrefixes);
    }

    public static void addPreferredClass(String className) {
        FlagDescription.checkNotNull(className);
        preferredClasses.add(className);
    }

    public static void addPreferredClass(Class<?> clazz) {
        FlagDescription.checkNotNull(clazz);
        Flags.addPreferredClass(clazz.getName());
    }

    public static void resetPreferredClasses() {
        preferredClasses.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerCompletionHook(Runnable callback) {
        FlagDescription.checkNotNull(callback);
        Class<Flags> clazz = Flags.class;
        synchronized (Flags.class) {
            boolean parseDone = parseState == ParseState.DONE;
            completionHooks.add(callback);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            if (parseDone) {
                callback.run();
            }
            return;
        }
    }

    private static synchronized void setParseState(ParseState newState) {
        if (newState == ParseState.IN_PROGRESS && parseState != ParseState.NOT_STARTED && !Flags.stateCheckingDisabled()) {
            throw new IllegalStateException("Cannot call parse more than once.  Here is the stacktrace of the previous call:\n" + Flags.getStackTraceAsString(parseStackTrace));
        }
        parseState = newState;
        parseStackTrace = newState == ParseState.DONE ? new Throwable("The stack trace associated with the PREVIOUS call to parse") : null;
    }

    public static boolean stateCheckingDisabled() {
        return Boolean.getBoolean(DISABLE_CHECKING);
    }

    public static void disableStateCheckingForTest() {
        Properties props = System.getProperties();
        props.setProperty(DISABLE_CHECKING, "true");
    }

    public static void enableStateCheckingForTest() {
        Properties props = System.getProperties();
        props.setProperty(DISABLE_CHECKING, "false");
    }

    public static void resetAllFlagsForTest() {
        for (FlagDescription desc : Flags.longNameMap().values()) {
            try {
                Flags.flag(FlagDescription.checkStateNotNull(desc)).resetForTest();
            }
            catch (LinkageError linkageError) {}
        }
        Flags.setParseState(ParseState.NOT_STARTED);
    }

    public static void resetSomeFlagsForTest(String ... flagNames) {
        for (String flagName : flagNames) {
            Flags.verifyAndResetFlag(FlagDescription.checkNotNull(flagName));
        }
        Flags.setParseState(ParseState.NOT_STARTED);
    }

    public static void resetFlagForTest(Class<?> cls, String member) {
        FlagDescription.checkNotNull(cls);
        Flags.verifyAndResetFlag(cls.getName() + "." + member.replaceFirst("^FLAG_", ""));
        Flags.setParseState(ParseState.NOT_STARTED);
    }

    private static void verifyAndResetFlag(String flagName) {
        FlagDescription desc = Flags.longNameMap().get(flagName);
        if (desc == null) {
            throw new IllegalArgumentException("Invalid flag name: " + flagName);
        }
        try {
            Flags.flag(desc).resetForTest();
        }
        catch (LinkageError linkageError) {
            // empty catch block
        }
    }

    @Deprecated
    public static Map<String, Object> getAllFlags() {
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        for (Map.Entry<String, FlagDescription> e : Flags.canonicalFlagMap().entrySet()) {
            String key = FlagDescription.checkStateNotNull(e.getKey());
            FlagDescription desc = FlagDescription.checkStateNotNull(e.getValue());
            if (key.indexOf(46) >= 0) continue;
            map.put(key, Flags.flag((FlagDescription)desc).value);
        }
        return map;
    }

    private static Collection<FlagInfoImpl> allFlagsInternal() {
        HashMap<FlagDescription, TreeSet<String>> allNames = new HashMap<FlagDescription, TreeSet<String>>();
        for (Map.Entry<String, Set<FlagDescription>> entry : Flags.expandedFlagMap().entrySet()) {
            String key = entry.getKey();
            Set<FlagDescription> flags = FlagDescription.checkStateNotNull(entry.getValue());
            if (flags.size() != 1) continue;
            FlagDescription desc = flags.iterator().next();
            TreeSet<String> flagNames = (TreeSet<String>)allNames.get(desc);
            if (flagNames == null) {
                flagNames = new TreeSet<String>();
                allNames.put(desc, flagNames);
            }
            flagNames.add(key);
        }
        TreeSet<FlagInfoImpl> result = new TreeSet<FlagInfoImpl>();
        for (Map.Entry entry : allNames.entrySet()) {
            FlagDescription desc = (FlagDescription)FlagDescription.checkStateNotNull(entry.getKey());
            ArrayList<String> names = new ArrayList<String>((Collection)entry.getValue());
            FlagInfoImpl info = new FlagInfoImpl(names, desc);
            result.add(info);
        }
        return result;
    }

    public static Collection<FlagInfo> allFlags() {
        return Collections.unmodifiableCollection(Flags.allFlagsInternal());
    }

    public static Collection<FlagInfo> exposedFlags() {
        Collection<FlagInfoImpl> allFlags = Flags.allFlagsInternal();
        Iterator<FlagInfoImpl> it = allFlags.iterator();
        while (it.hasNext()) {
            FlagInfoImpl flag = FlagDescription.checkStateNotNull(it.next());
            if (flag.desc.getDocLevel() == DocLevel.PUBLIC && Flags.whitelistAllowsAliasing(flag.desc)) continue;
            it.remove();
        }
        return Collections.unmodifiableCollection(allFlags);
    }

    private static String getStackTraceAsString(@Nullable Throwable t) {
        if (t == null) {
            return "null";
        }
        StringWriter stringWriter = new StringWriter();
        t.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    static /* synthetic */ Map access$000() {
        return Flags.loadFlagManifests();
    }

    static {
        usagePrefix = null;
        preferredClasses = new HashSet<String>();
        flagClassLoader = null;
        String mainClassName = Flags.getMainClassNameFromStackTrace(Thread.currentThread().getStackTrace());
        if (mainClassName == null) {
            try {
                StackTraceElement[] stack;
                Iterator<StackTraceElement[]> i$ = Thread.getAllStackTraces().values().iterator();
                while (i$.hasNext() && (mainClassName = Flags.getMainClassNameFromStackTrace(FlagDescription.checkStateNotNull(stack = i$.next()))) == null) {
                }
            }
            catch (AccessControlException e) {
                logger.log(Level.FINE, "Unable to calculate main class name", e);
            }
        }
        cachedMainClassName = mainClassName;
        forceIgnoreNonflagArguments = Flag.value(false);
        showAllArgumentsForNonflagErrors = Flag.value(false);
        HELP_PATTERN = Pattern.compile("-+help(=true)?");
        HELPSHORT_PATTERN = Pattern.compile("-+helpshort(=true)?");
        XML_HELP_PATTERN = Pattern.compile("-+helpxml(=true)?");
        FLAG_PATTERN = Pattern.compile("-+([^=]*)(?:=(.*))?", 40);
        FLAG_FILE_PATTERN = Pattern.compile("-+flagfile=(.+)");
        FLAG_RESOURCE_PATTERN = Pattern.compile("-+flagresource=(.+)");
        BLANK_LINE_PATTERN = Pattern.compile("\\s*");
        COMMENT_LINE_PATTERN = Pattern.compile("\\s*#.*");
        FLAG_NAME_PATTERN = Pattern.compile("\\w[_\\w]*");
    }

    static class FlagInfoImpl
    implements FlagInfo,
    Comparable<FlagInfoImpl> {
        final List<String> names;
        final FlagDescription desc;

        FlagInfoImpl(List<String> names, FlagDescription desc) {
            this.names = names;
            this.desc = desc;
        }

        @Override
        public List<String> names() {
            return Collections.unmodifiableList(this.names);
        }

        @Override
        public String containerClass() {
            return this.desc.getContainerClassName();
        }

        @Override
        public String type() {
            return this.desc.getType();
        }

        @Override
        @Nullable
        public Object value() {
            return Flags.flag((FlagDescription)this.desc).value;
        }

        @Override
        public boolean accessed() {
            return Flags.flag((FlagDescription)this.desc).accessed;
        }

        @Override
        public boolean hasAltName() {
            return this.desc.getAltName() != null;
        }

        @Override
        @Nullable
        public String parsableStringValue() {
            return Flags.flag(this.desc).parsableStringValue();
        }

        @Override
        @Nullable
        public Object defaultValue() {
            return Flags.flag((FlagDescription)this.desc).defaultValue;
        }

        @Override
        public int compareTo(FlagInfoImpl other) {
            return this.desc.compareTo(other.desc);
        }

        public boolean equals(@Nullable Object that) {
            if (this == that) {
                return true;
            }
            if (!(that instanceof FlagInfoImpl)) {
                return false;
            }
            FlagInfoImpl otherFlag = (FlagInfoImpl)that;
            return this.desc.equals(otherFlag.desc);
        }

        public int hashCode() {
            return this.desc.hashCode();
        }

        public String toString() {
            return "[FlagInfo names=" + this.names + " desc=" + this.desc + "]";
        }

        @Override
        public String doc() {
            return this.desc.getDoc();
        }
    }

    private static class FlagMapHolder {
        static Map<String, FlagDescription> longNameMap = Flags.access$000();
        @Nullable
        static volatile Map<String, FlagDescription> canonicalFlagMap;
        @Nullable
        static volatile Map<String, Set<FlagDescription>> expandedFlagMap;
        static final Map<String, Flag<?>> manuallyRegisteredFlags;
        @Nullable
        static Collection<String> whitelistedPrefixes;

        private FlagMapHolder() {
        }

        static {
            manuallyRegisteredFlags = new HashMap();
            whitelistedPrefixes = null;
        }
    }

    private static enum ParseState {
        NOT_STARTED,
        IN_PROGRESS,
        DONE;

    }
}

