/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.flags;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import javax.annotation.Nullable;

public final class FlagsExtension {
    private static final String EXT_SUB_PATHS = "experimental/scala:experimental/scalatests";
    private static final String SUB_PATHS_PROPERTY = "com.google.appengine.repackaged.com.google.common.flags.ext.searchSubPaths";

    private FlagsExtension() {
    }

    public static void init() {
        FlagsExtension.updateExtSubPaths();
        System.setProperty("com.google.appengine.repackaged.com.google.common.flags.useFlagsExtension", "true");
    }

    @Nullable
    static Object getFlagContainerObject(Class<?> containerClass) throws NoSuchFieldException, IllegalAccessException {
        if (FlagsExtension.isScalaSingleton(containerClass)) {
            return containerClass.getField("MODULE$").get(null);
        }
        return null;
    }

    private static void updateExtSubPaths() {
        String subPaths = System.getProperty(SUB_PATHS_PROPERTY);
        subPaths = subPaths != null ? subPaths + ":experimental/scala:experimental/scalatests" : EXT_SUB_PATHS;
        System.setProperty(SUB_PATHS_PROPERTY, subPaths);
    }

    private static boolean isScalaSingleton(Class<?> containerClass) {
        try {
            Field scalaObject = containerClass.getField("MODULE$");
            if (Modifier.isStatic(scalaObject.getModifiers()) && scalaObject.getType().getName().equals(containerClass.getName())) {
                return true;
            }
        }
        catch (NoSuchFieldException e) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return false;
    }
}

