/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.client.datastoreservice.app;

import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.repackaged.com.google.common.collect.Lists;
import com.google.appengine.repackaged.com.google.net.util.error.Codes;
import com.google.appengine.repackaged.com.google.protobuf.Parser;
import com.google.apphosting.client.datastoreservice.app.DatastoreRpcHandler;
import com.google.apphosting.client.datastoreservice.app.EntityV4Normalizer;
import com.google.apphosting.client.datastoreservice.app.InternDatastoreRpcService;
import com.google.apphosting.client.datastoreservice.proto.DatastoreService;
import com.google.apphosting.client.serviceapp.RpcException;
import com.google.apphosting.client.serviceapp.RpcHandler;
import com.google.apphosting.datastore.DatastoreV4;
import com.google.apphosting.datastore.EntityV4;
import java.util.ArrayList;
import java.util.List;

class AllocateIdsHandler
extends DatastoreRpcHandler<DatastoreService.AllocateIdsRequest, DatastoreService.AllocateIdsResponse> {
    @VisibleForTesting
    static final InternDatastoreRpcService.RpcSpec<DatastoreV4.AllocateIdsResponse> INTERN_RPC_SPEC = InternDatastoreRpcService.createRpcSpec("datastore_v4", "AllocateIds", DatastoreV4.AllocateIdsResponse.PARSER);
    private final EntityV4Normalizer entityNormalizer;
    private final int maxKeysPerBatch;

    public AllocateIdsHandler(InternDatastoreRpcService internService, EntityV4Normalizer entityNormalizer, int maxKeysPerBatch) {
        super(internService);
        this.entityNormalizer = entityNormalizer;
        this.maxKeysPerBatch = maxKeysPerBatch;
    }

    @Override
    public Parser<DatastoreService.AllocateIdsRequest> getParser() {
        return DatastoreService.AllocateIdsRequest.PARSER;
    }

    @Override
    public Class<DatastoreService.AllocateIdsRequest> getRequestClass() {
        return DatastoreService.AllocateIdsRequest.class;
    }

    @Override
    public DatastoreService.AllocateIdsResponse call(RpcHandler.CallOptions options, DatastoreService.AllocateIdsRequest req) throws RpcException {
        ArrayList<InternDatastoreRpcService.ResponseFutureWrapper<DatastoreV4.AllocateIdsResponse>> futures = Lists.newArrayListWithExpectedSize(req.getKeyCount() / this.maxKeysPerBatch + 1);
        for (int fromIndex = 0; fromIndex < req.getKeyCount(); fromIndex += this.maxKeysPerBatch) {
            int toIndex = Math.min(req.getKeyCount(), fromIndex + this.maxKeysPerBatch);
            List<EntityV4.Key> list = Lists.transform(req.getKeyList().subList(fromIndex, toIndex), this.entityNormalizer.getKeyTransform());
            DatastoreV4.AllocateIdsRequest internReq = DatastoreV4.AllocateIdsRequest.newBuilder().addAllAllocate(list).build();
            futures.add(this.internService.call(INTERN_RPC_SPEC, internReq));
        }
        DatastoreService.AllocateIdsResponse.Builder res = DatastoreService.AllocateIdsResponse.newBuilder();
        for (InternDatastoreRpcService.ResponseFutureWrapper responseFutureWrapper : futures) {
            res.addAllKey(((DatastoreV4.AllocateIdsResponse)responseFutureWrapper.getResponse()).getAllocatedList());
        }
        return res.build();
    }

    @Override
    public DatastoreService.AllocateIdsResponse makeError(Codes.Code errorCode, String message) {
        return DatastoreService.AllocateIdsResponse.newBuilder().setHeader(AllocateIdsHandler.makeErrorHeader(errorCode, message)).build();
    }
}

