/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.client.datastoreservice.app;

import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.repackaged.com.google.common.base.Function;
import com.google.appengine.repackaged.com.google.common.collect.Lists;
import com.google.appengine.repackaged.com.google.net.util.error.Codes;
import com.google.appengine.repackaged.com.google.protobuf.Parser;
import com.google.apphosting.client.datastoreservice.app.DatastoreRpcHandler;
import com.google.apphosting.client.datastoreservice.app.EntityV4Normalizer;
import com.google.apphosting.client.datastoreservice.app.InternDatastoreRpcService;
import com.google.apphosting.client.datastoreservice.proto.DatastoreService;
import com.google.apphosting.client.serviceapp.RpcException;
import com.google.apphosting.client.serviceapp.RpcHandler;
import com.google.apphosting.datastore.DatastoreV4;
import com.google.apphosting.datastore.EntityV4;

class CommitHandler
extends DatastoreRpcHandler<DatastoreService.CommitRequest, DatastoreService.CommitResponse> {
    @VisibleForTesting
    static final InternDatastoreRpcService.RpcSpec<DatastoreV4.CommitResponse> INTERN_RPC_SPEC = InternDatastoreRpcService.createRpcSpec("datastore_v4", "Commit", DatastoreV4.CommitResponse.PARSER);
    private final EntityV4Normalizer entityNormalizer;

    public CommitHandler(InternDatastoreRpcService internService, EntityV4Normalizer entityNormalizer) {
        super(internService);
        this.entityNormalizer = entityNormalizer;
    }

    @Override
    public Parser<DatastoreService.CommitRequest> getParser() {
        return DatastoreService.CommitRequest.PARSER;
    }

    @Override
    public Class<DatastoreService.CommitRequest> getRequestClass() {
        return DatastoreService.CommitRequest.class;
    }

    @Override
    public DatastoreService.CommitResponse call(RpcHandler.CallOptions options, DatastoreService.CommitRequest req) throws RpcException {
        DatastoreV4.CommitRequest.Builder internReq = DatastoreV4.CommitRequest.newBuilder();
        if (req.hasTransaction()) {
            internReq.setTransaction(req.getTransaction());
        }
        if (req.hasMode()) {
            internReq.setMode(DatastoreV4.CommitRequest.Mode.valueOf(req.getMode().getNumber()));
        }
        if (req.hasMutation()) {
            internReq.setMutation(this.normalizeMutation(req.getMutation()));
        }
        DatastoreV4.CommitResponse internRes = this.internService.call(INTERN_RPC_SPEC, internReq.build()).getResponse();
        DatastoreService.CommitResponse.Builder res = DatastoreService.CommitResponse.newBuilder();
        if (internRes.hasMutationResult()) {
            res.getMutationResultBuilder().setIndexUpdates(internRes.getMutationResult().getIndexUpdates()).addAllInsertAutoIdKey(internRes.getMutationResult().getInsertAutoIdKeyList());
        }
        return res.build();
    }

    private DatastoreV4.Mutation normalizeMutation(DatastoreV4.Mutation mutation) {
        DatastoreV4.Mutation.Builder internMutation = DatastoreV4.Mutation.newBuilder();
        Function<EntityV4.Entity, EntityV4.Entity> entityTransform = this.entityNormalizer.getEntityTransform();
        Function<EntityV4.Key, EntityV4.Key> keyTransform = this.entityNormalizer.getKeyTransform();
        internMutation.addAllUpsert(Lists.transform(mutation.getUpsertList(), entityTransform));
        internMutation.addAllUpdate(Lists.transform(mutation.getUpdateList(), entityTransform));
        internMutation.addAllInsert(Lists.transform(mutation.getInsertList(), entityTransform));
        internMutation.addAllInsertAutoId(Lists.transform(mutation.getInsertAutoIdList(), entityTransform));
        internMutation.addAllDelete(Lists.transform(mutation.getDeleteList(), keyTransform));
        if (mutation.hasForce()) {
            internMutation.setForce(mutation.getForce());
        }
        return internMutation.build();
    }

    @Override
    public DatastoreService.CommitResponse makeError(Codes.Code errorCode, String message) {
        return DatastoreService.CommitResponse.newBuilder().setHeader(CommitHandler.makeErrorHeader(errorCode, message)).build();
    }
}

