/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.client.datastoreservice.app;

import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.repackaged.com.google.common.base.Function;
import com.google.appengine.repackaged.com.google.common.collect.Lists;
import com.google.appengine.repackaged.com.google.net.util.error.Codes;
import com.google.appengine.repackaged.com.google.protobuf.CodedOutputStream;
import com.google.appengine.repackaged.com.google.protobuf.Parser;
import com.google.apphosting.client.datastoreservice.app.DatastoreRpcHandler;
import com.google.apphosting.client.datastoreservice.app.EntityV4Normalizer;
import com.google.apphosting.client.datastoreservice.app.InternDatastoreRpcService;
import com.google.apphosting.client.datastoreservice.proto.DatastoreService;
import com.google.apphosting.client.serviceapp.RpcException;
import com.google.apphosting.client.serviceapp.RpcHandler;
import com.google.apphosting.datastore.DatastoreV4;
import com.google.apphosting.datastore.EntityV4;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

class LookupHandler
extends DatastoreRpcHandler<DatastoreService.LookupRequest, DatastoreService.LookupResponse> {
    @VisibleForTesting
    static final int INTERN_MAX_KEYS_PER_REQUEST = 300;
    @VisibleForTesting
    static final InternDatastoreRpcService.RpcSpec<DatastoreV4.LookupResponse> INTERN_RPC_SPEC = InternDatastoreRpcService.createRpcSpec("datastore_v4", "Lookup", DatastoreV4.LookupResponse.PARSER);
    private final EntityV4Normalizer entityNormalizer;
    private final Function<DatastoreV4.EntityResult, DatastoreV4.EntityResult> resultTransform;

    LookupHandler(InternDatastoreRpcService internService, EntityV4Normalizer entityNormalizer, Function<DatastoreV4.EntityResult, DatastoreV4.EntityResult> resultTransform) {
        super(internService);
        this.entityNormalizer = entityNormalizer;
        this.resultTransform = resultTransform;
    }

    @Override
    public Parser<DatastoreService.LookupRequest> getParser() {
        return DatastoreService.LookupRequest.PARSER;
    }

    @Override
    public Class<DatastoreService.LookupRequest> getRequestClass() {
        return DatastoreService.LookupRequest.class;
    }

    @Override
    public DatastoreService.LookupResponse call(RpcHandler.CallOptions callOptions, DatastoreService.LookupRequest req) throws RpcException {
        ArrayList<EntityV4.Key> keyList = Lists.newArrayListWithCapacity(req.getKeyCount());
        for (EntityV4.Key key : req.getKeyList()) {
            keyList.add(this.entityNormalizer.normalizeKey(key));
        }
        int remainingApiResponseBytes = callOptions.getMaxResponseBytes();
        for (EntityV4.Key key : keyList) {
            remainingApiResponseBytes -= this.getMaxResponseBytes(key);
        }
        if (remainingApiResponseBytes < 0) {
            throw new RpcException(Codes.Code.INVALID_ARGUMENT, "Too many keys for the response size limit.");
        }
        DatastoreV4.LookupRequest internReq = this.createInternRequest(req.getReadOptions(), keyList);
        InternDatastoreRpcService.ResponseFutureWrapper<DatastoreV4.LookupResponse> internRpc = this.internService.call(INTERN_RPC_SPEC, internReq);
        DatastoreService.LookupResponse.Builder res = DatastoreService.LookupResponse.newBuilder();
        do {
            DatastoreV4.LookupResponse internRes = internRpc.getResponse();
            keyList.addAll(internRes.getDeferredList());
            if (keyList.isEmpty()) {
                internRpc = null;
            } else {
                internReq = this.createInternRequest(req.getReadOptions(), keyList);
                internRpc = this.internService.call(INTERN_RPC_SPEC, internReq);
            }
            res.addAllMissing(Lists.transform(internRes.getMissingList(), this.resultTransform));
            for (DatastoreV4.EntityResult found : Lists.transform(internRes.getFoundList(), this.resultTransform)) {
                int nonKeyBytes = CodedOutputStream.computeMessageSize(1, found) - this.getMaxResponseBytes(found.getEntity().getKey());
                if (nonKeyBytes > remainingApiResponseBytes) {
                    internRpc = null;
                    res.addDeferred(found.getEntity().getKey());
                    continue;
                }
                res.addFound(found);
                remainingApiResponseBytes -= nonKeyBytes;
            }
        } while (internRpc != null);
        res.addAllDeferred(keyList);
        return res.build();
    }

    private int getMaxResponseBytes(EntityV4.Key key) {
        return CodedOutputStream.computeMessageSize(3, key);
    }

    private DatastoreV4.LookupRequest createInternRequest(@Nullable DatastoreV4.ReadOptions readOptions, List<EntityV4.Key> keyList) {
        DatastoreV4.LookupRequest.Builder req = DatastoreV4.LookupRequest.newBuilder();
        if (readOptions != null) {
            req.setReadOptions(readOptions);
        }
        List<EntityV4.Key> limitedKeyList = keyList.size() <= 300 ? keyList : keyList.subList(0, 300);
        req.addAllKey(limitedKeyList);
        limitedKeyList.clear();
        return req.build();
    }

    @Override
    public DatastoreService.LookupResponse makeError(Codes.Code errorCode, String message) {
        return DatastoreService.LookupResponse.newBuilder().setHeader(LookupHandler.makeErrorHeader(errorCode, message)).build();
    }
}

