/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.client.datastoreservice.app;

import com.google.appengine.repackaged.com.google.common.base.Function;
import com.google.appengine.repackaged.com.google.common.collect.Lists;
import com.google.appengine.repackaged.com.google.net.util.error.Codes;
import com.google.appengine.repackaged.com.google.protobuf.CodedOutputStream;
import com.google.appengine.repackaged.com.google.protobuf.Parser;
import com.google.apphosting.client.datastoreservice.app.DatastoreRpcHandler;
import com.google.apphosting.client.datastoreservice.app.EntityV4Normalizer;
import com.google.apphosting.client.datastoreservice.app.InternDatastoreRpcService;
import com.google.apphosting.client.datastoreservice.proto.DatastoreService;
import com.google.apphosting.client.serviceapp.RpcException;
import com.google.apphosting.client.serviceapp.RpcHandler;
import com.google.apphosting.datastore.DatastoreV4;
import java.util.ArrayList;

class RunQueryHandler
extends DatastoreRpcHandler<DatastoreService.RunQueryRequest, DatastoreService.RunQueryResponse> {
    static final InternDatastoreRpcService.RpcSpec<DatastoreV4.RunQueryResponse> INTERN_RPC_SPEC = InternDatastoreRpcService.createRpcSpec("datastore_v4", "RunQuery", DatastoreV4.RunQueryResponse.PARSER);
    static final InternDatastoreRpcService.RpcSpec<DatastoreV4.ContinueQueryResponse> INTERN_CONTINUE_RPC_SPEC = InternDatastoreRpcService.createRpcSpec("datastore_v4", "ContinueQuery", DatastoreV4.ContinueQueryResponse.PARSER);
    private final EntityV4Normalizer defaultEntityNormalizer;
    private final Function<DatastoreV4.EntityResult, DatastoreV4.EntityResult> resultTransform;

    public RunQueryHandler(InternDatastoreRpcService internService, EntityV4Normalizer defaultEntityNormalizer, Function<DatastoreV4.EntityResult, DatastoreV4.EntityResult> resultTransform) {
        super(internService);
        this.defaultEntityNormalizer = defaultEntityNormalizer;
        this.resultTransform = resultTransform;
    }

    @Override
    public Parser<DatastoreService.RunQueryRequest> getParser() {
        return DatastoreService.RunQueryRequest.PARSER;
    }

    @Override
    public Class<DatastoreService.RunQueryRequest> getRequestClass() {
        return DatastoreService.RunQueryRequest.class;
    }

    @Override
    public DatastoreService.RunQueryResponse call(RpcHandler.CallOptions options, DatastoreService.RunQueryRequest req) throws RpcException {
        DatastoreService.RunQueryResponse.Builder res = DatastoreService.RunQueryResponse.newBuilder();
        DatastoreV4.QueryResultBatch.Builder batch = res.getBatchBuilder();
        DatastoreV4.RunQueryResponse initialInternResp = this.internService.call(INTERN_RPC_SPEC, this.toV4RunQueryRequest(req)).getResponse();
        DatastoreV4.QueryResultBatch internBatch = initialInternResp.getBatch();
        batch.setEntityResultType(internBatch.getEntityResultType());
        DatastoreV4.ContinueQueryRequest continueReq = DatastoreV4.ContinueQueryRequest.newBuilder().setQueryHandle(initialInternResp.getQueryHandle()).build();
        int totalResultBytes = 0;
        while (true) {
            InternDatastoreRpcService.ResponseFutureWrapper<DatastoreV4.ContinueQueryResponse> nextRpc = internBatch.getMoreResults() == DatastoreV4.QueryResultBatch.MoreResultsType.NOT_FINISHED ? this.internService.call(INTERN_CONTINUE_RPC_SPEC, continueReq) : null;
            ArrayList<DatastoreV4.EntityResult> results = Lists.newArrayListWithCapacity(internBatch.getEntityResultCount());
            for (DatastoreV4.EntityResult result : Lists.transform(internBatch.getEntityResultList(), this.resultTransform)) {
                int resultBytes = CodedOutputStream.computeMessageSize(2, result);
                if (totalResultBytes + resultBytes > options.getMaxResponseBytes()) {
                    batch.setMoreResults(DatastoreV4.QueryResultBatch.MoreResultsType.NOT_FINISHED);
                    return res.build();
                }
                totalResultBytes += resultBytes;
                results.add(result);
            }
            batch.addAllEntityResult(results);
            batch.setEndCursor(internBatch.getEndCursor());
            if (internBatch.hasSkippedResults()) {
                batch.setSkippedResults(batch.getSkippedResults() + internBatch.getSkippedResults());
            }
            if (nextRpc == null) {
                batch.setMoreResults(internBatch.getMoreResults());
                return res.build();
            }
            internBatch = nextRpc.getResponse().getBatch();
        }
    }

    @Override
    public DatastoreService.RunQueryResponse makeError(Codes.Code errorCode, String message) {
        return DatastoreService.RunQueryResponse.newBuilder().setHeader(RunQueryHandler.makeErrorHeader(errorCode, message)).build();
    }

    private void normalizeQueryFilter(EntityV4Normalizer entityNormalizer, DatastoreV4.Filter.Builder filter) {
        if (filter.hasCompositeFilter()) {
            for (DatastoreV4.Filter.Builder subFilter : filter.getCompositeFilterBuilder().getFilterBuilderList()) {
                this.normalizeQueryFilter(entityNormalizer, subFilter);
            }
        }
        if (filter.hasPropertyFilter()) {
            DatastoreV4.PropertyFilter.Builder propertyFilter = filter.getPropertyFilterBuilder();
            propertyFilter.setValue(entityNormalizer.normalizeValue(propertyFilter.getValue()));
        }
    }

    private DatastoreV4.Query normalizeQuery(EntityV4Normalizer entityNormalizer, DatastoreV4.Query query) {
        if (!query.hasFilter()) {
            return query;
        }
        DatastoreV4.Query.Builder normQuery = query.toBuilder();
        this.normalizeQueryFilter(entityNormalizer, normQuery.getFilterBuilder());
        return normQuery.build();
    }

    private void normalizeGqlQueryArg(EntityV4Normalizer entityNormalizer, DatastoreV4.GqlQueryArg.Builder gqlQueryArg) {
        if (gqlQueryArg.hasValue()) {
            gqlQueryArg.setValue(entityNormalizer.normalizeValue(gqlQueryArg.getValue()));
        }
    }

    private DatastoreV4.GqlQuery normalizeGqlQuery(EntityV4Normalizer entityNormalizer, DatastoreV4.GqlQuery gqlQuery) {
        if (gqlQuery.getNameArgCount() == 0 && gqlQuery.getNumberArgCount() == 0) {
            return gqlQuery;
        }
        DatastoreV4.GqlQuery.Builder normGqlQuery = gqlQuery.toBuilder();
        for (DatastoreV4.GqlQueryArg.Builder nameArg : normGqlQuery.getNameArgBuilderList()) {
            this.normalizeGqlQueryArg(entityNormalizer, nameArg);
        }
        for (DatastoreV4.GqlQueryArg.Builder numberArg : normGqlQuery.getNumberArgBuilderList()) {
            this.normalizeGqlQueryArg(entityNormalizer, numberArg);
        }
        return normGqlQuery.build();
    }

    DatastoreV4.RunQueryRequest toV4RunQueryRequest(DatastoreService.RunQueryRequest req) {
        DatastoreV4.RunQueryRequest.Builder reqV4 = DatastoreV4.RunQueryRequest.newBuilder();
        reqV4.setPartitionId(this.defaultEntityNormalizer.normalizePartitionId(req.getPartitionId()));
        EntityV4Normalizer contextNormalizer = this.defaultEntityNormalizer.overrideDefaultPartitionId(reqV4.getPartitionId());
        if (req.hasQuery()) {
            reqV4.setQuery(this.normalizeQuery(contextNormalizer, req.getQuery()));
        }
        if (req.hasGqlQuery()) {
            reqV4.setGqlQuery(this.normalizeGqlQuery(contextNormalizer, req.getGqlQuery()));
        }
        reqV4.setSuggestedBatchSize(Integer.MAX_VALUE);
        if (req.hasReadOptions()) {
            reqV4.setReadOptions(req.getReadOptions());
        }
        return reqV4.build();
    }
}

