/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.channel;

import com.google.appengine.api.channel.ChannelPresence;
import com.google.appengine.api.utils.HttpRequestParser;
import java.io.IOException;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMultipart;
import javax.servlet.http.HttpServletRequest;

class ChannelPresenceParser
extends HttpRequestParser {
    ChannelPresenceParser() {
    }

    static ChannelPresence parsePresence(HttpServletRequest request) throws IOException {
        try {
            boolean isConnected;
            MimeMultipart multipart = ChannelPresenceParser.parseMultipartRequest(request);
            if (multipart == null) {
                throw new IllegalArgumentException("No arguments provided in request.");
            }
            if (request.getRequestURI().endsWith("/channel/connected/")) {
                isConnected = true;
            } else if (request.getRequestURI().endsWith("/channel/disconnected/")) {
                isConnected = false;
            } else {
                throw new IllegalArgumentException("Can't determine the type of channel presence from the path: " + request.getRequestURI());
            }
            int parts = multipart.getCount();
            for (int i = 0; i < parts; ++i) {
                BodyPart part = multipart.getBodyPart(i);
                if (!"from".equals(ChannelPresenceParser.getFieldName(part))) continue;
                return new ChannelPresence(isConnected, ChannelPresenceParser.getTextContent(part));
            }
            throw new IllegalArgumentException("Can't determine clientId from request body: " + multipart);
        }
        catch (MessagingException ex) {
            IOException ex2 = new IOException("Could not parse incoming request.");
            ex2.initCause(ex);
            throw ex2;
        }
    }
}

