/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.client.datastoreservice.app;

import com.google.appengine.repackaged.com.google.common.collect.Lists;
import com.google.appengine.repackaged.com.google.net.util.error.Codes;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.appengine.repackaged.com.google.protobuf.Parser;
import com.google.apphosting.client.datastoreservice.app.DatastoreClient;
import com.google.apphosting.client.datastoreservice.app.DatastoreRpcHandler;
import com.google.apphosting.client.datastoreservice.app.EntityV4Normalizer;
import com.google.apphosting.client.datastoreservice.proto.DatastoreService;
import com.google.apphosting.client.serviceapp.RpcException;
import com.google.apphosting.client.serviceapp.RpcHandler;
import com.google.apphosting.datastore.DatastoreV4;
import com.google.apphosting.datastore.EntityV4;
import java.util.ArrayList;
import java.util.List;

class CommitHandler
extends DatastoreRpcHandler<DatastoreService.CommitRequest, DatastoreService.CommitResponse, DatastoreClient> {
    private final EntityV4Normalizer entityNormalizer;

    public CommitHandler(DatastoreClient datastoreClient, EntityV4Normalizer entityNormalizer) {
        super(datastoreClient);
        this.entityNormalizer = entityNormalizer;
    }

    @Override
    public Parser<DatastoreService.CommitRequest> getParser() {
        return DatastoreService.CommitRequest.PARSER;
    }

    @Override
    public Class<DatastoreService.CommitRequest> getRequestClass() {
        return DatastoreService.CommitRequest.class;
    }

    @Override
    public DatastoreService.CommitResponse call(RpcHandler.CallOptions options, DatastoreService.CommitRequest req) throws RpcException {
        boolean useDeprecatedMutation = req.hasDeprecatedMutation();
        if (useDeprecatedMutation) {
            if (!req.getMutationList().isEmpty()) {
                throw new RpcException(Codes.Code.INVALID_ARGUMENT, "A commit request cannot contain both a mutation list and a deprecated mutation");
            }
            req = this.transformCommitRequestWithDeprecatedMutationToWithout(req);
        }
        List<DatastoreV4.Mutation> mutationList = this.normalizeMutationList(req.getMutationList());
        ByteString transaction = req.hasTransaction() ? req.getTransaction() : null;
        DatastoreV4.CommitResponse internRes = ((DatastoreClient)this.datastoreClient).commit(transaction, req.getMode(), mutationList);
        DatastoreService.CommitResponse.Builder res = DatastoreService.CommitResponse.newBuilder();
        res.setIndexUpdates(internRes.getIndexUpdates());
        if (useDeprecatedMutation) {
            DatastoreV4.DeprecatedMutationResult.Builder deprecatedMutationResultBuilder = res.getDeprecatedMutationResultBuilder();
            deprecatedMutationResultBuilder.setIndexUpdates(internRes.getIndexUpdates());
            for (DatastoreV4.MutationResult mutationResult : internRes.getMutationResultList()) {
                if (!mutationResult.hasKey()) continue;
                deprecatedMutationResultBuilder.addInsertAutoIdKey(mutationResult.getKey());
            }
        } else {
            res.addAllMutationResult(internRes.getMutationResultList());
        }
        return res.build();
    }

    private List<DatastoreV4.Mutation> normalizeMutationList(List<DatastoreV4.Mutation> mutationList) {
        ArrayList<DatastoreV4.Mutation> normalMutationList = Lists.newArrayList();
        for (DatastoreV4.Mutation mutation : mutationList) {
            normalMutationList.add(this.normalizeMutation(mutation));
        }
        return normalMutationList;
    }

    private DatastoreV4.Mutation normalizeMutation(DatastoreV4.Mutation mutation) {
        DatastoreV4.Mutation.Builder normalMutationBuilder = DatastoreV4.Mutation.newBuilder();
        normalMutationBuilder.setOp(mutation.getOp());
        if (mutation.hasKey()) {
            normalMutationBuilder.setKey(this.entityNormalizer.normalizeKey(mutation.getKey()));
        }
        if (mutation.hasEntity()) {
            normalMutationBuilder.setEntity(this.entityNormalizer.normalizeEntity(mutation.getEntity()));
        }
        return normalMutationBuilder.build();
    }

    private DatastoreService.CommitRequest transformCommitRequestWithDeprecatedMutationToWithout(DatastoreService.CommitRequest req) {
        ArrayList<DatastoreV4.Mutation> mutationList = Lists.newArrayList();
        DatastoreV4.DeprecatedMutation deprecatedMutation = req.getDeprecatedMutation();
        this.addEntityListToMutationList(DatastoreV4.Mutation.Operation.INSERT, deprecatedMutation.getInsertList(), mutationList);
        this.addEntityListToMutationList(DatastoreV4.Mutation.Operation.UPDATE, deprecatedMutation.getUpdateList(), mutationList);
        this.addEntityListToMutationList(DatastoreV4.Mutation.Operation.UPSERT, deprecatedMutation.getUpsertList(), mutationList);
        this.addEntityListToMutationList(DatastoreV4.Mutation.Operation.INSERT_WITH_AUTO_ID, deprecatedMutation.getInsertAutoIdList(), mutationList);
        this.addDeleteKeyListToMutationList(deprecatedMutation.getDeleteList(), mutationList);
        DatastoreService.CommitRequest transformedRequest = DatastoreService.CommitRequest.newBuilder(req).clearDeprecatedMutation().addAllMutation(mutationList).build();
        return transformedRequest;
    }

    private void addEntityListToMutationList(DatastoreV4.Mutation.Operation op, List<EntityV4.Entity> entityList, List<DatastoreV4.Mutation> mutationList) {
        for (EntityV4.Entity entity : entityList) {
            mutationList.add(DatastoreV4.Mutation.newBuilder().setOp(op).setEntity(entity).build());
        }
    }

    private void addDeleteKeyListToMutationList(List<EntityV4.Key> keyList, List<DatastoreV4.Mutation> mutationList) {
        for (EntityV4.Key key : keyList) {
            mutationList.add(DatastoreV4.Mutation.newBuilder().setOp(DatastoreV4.Mutation.Operation.DELETE).setKey(key).build());
        }
    }

    @Override
    public DatastoreService.CommitResponse makeError(Codes.Code errorCode, String message) {
        return DatastoreService.CommitResponse.newBuilder().setHeader(CommitHandler.makeErrorHeader(errorCode, message)).build();
    }
}

