/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.search;

import javax.mail.search.SearchTerm;

public abstract class StringTerm
extends SearchTerm {
    protected boolean ignoreCase;
    protected String pattern;

    protected StringTerm(String pattern) {
        this(pattern, true);
    }

    protected StringTerm(String pattern, boolean ignoreCase) {
        this.pattern = pattern;
        this.ignoreCase = ignoreCase;
    }

    public String getPattern() {
        return this.pattern;
    }

    public boolean getIgnoreCase() {
        return this.ignoreCase;
    }

    protected boolean match(String match) {
        int matchLength = this.pattern.length();
        int length = match.length() - matchLength;
        for (int i = 0; i <= length; ++i) {
            if (!match.regionMatches(this.ignoreCase, i, this.pattern, 0, matchLength)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof StringTerm)) {
            return false;
        }
        StringTerm term = (StringTerm)other;
        if (this.ignoreCase) {
            return term.pattern.equalsIgnoreCase(this.pattern) && term.ignoreCase == this.ignoreCase;
        }
        return term.pattern.equals(this.pattern) && term.ignoreCase == this.ignoreCase;
    }

    public int hashCode() {
        return this.pattern.hashCode() + (this.ignoreCase ? 32 : 79);
    }
}

