/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.client.datastoreservice.app;

import com.google.appengine.repackaged.com.google.common.base.Function;
import com.google.appengine.repackaged.com.google.common.collect.Lists;
import com.google.appengine.repackaged.com.google.net.util.error.Codes;
import com.google.appengine.repackaged.com.google.protobuf.Parser;
import com.google.apphosting.client.datastoreservice.app.DatastoreClient;
import com.google.apphosting.client.datastoreservice.app.DatastoreRpcHandler;
import com.google.apphosting.client.datastoreservice.app.EntityV4Normalizer;
import com.google.apphosting.client.datastoreservice.proto.DatastoreService;
import com.google.apphosting.client.serviceapp.RpcException;
import com.google.apphosting.client.serviceapp.RpcHandler;
import com.google.apphosting.datastore.DatastoreV4;

class LookupHandler
extends DatastoreRpcHandler<DatastoreService.LookupRequest, DatastoreService.LookupResponse, DatastoreClient> {
    private final Function<DatastoreV4.EntityResult, DatastoreV4.EntityResult> resultTransform;
    private EntityV4Normalizer entityNormalizer;

    public LookupHandler(DatastoreClient datastoreClient, EntityV4Normalizer entityNormalizer, Function<DatastoreV4.EntityResult, DatastoreV4.EntityResult> resultTransform) {
        super(datastoreClient);
        this.entityNormalizer = entityNormalizer;
        this.resultTransform = resultTransform;
    }

    @Override
    public Parser<DatastoreService.LookupRequest> getParser() {
        return DatastoreService.LookupRequest.PARSER;
    }

    @Override
    public Class<DatastoreService.LookupRequest> getRequestClass() {
        return DatastoreService.LookupRequest.class;
    }

    @Override
    public DatastoreService.LookupResponse call(RpcHandler.CallOptions callOptions, DatastoreService.LookupRequest req) throws RpcException {
        return ((DatastoreClient)this.datastoreClient).lookup(callOptions, this.resultTransform, req.getReadOptions(), Lists.transform(req.getKeyList(), this.entityNormalizer.getKeyTransform()));
    }

    @Override
    public DatastoreService.LookupResponse makeError(Codes.Code errorCode, String message) {
        return DatastoreService.LookupResponse.newBuilder().setHeader(LookupHandler.makeErrorHeader(errorCode, message)).build();
    }
}

