/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.BaseInternalTransactionV4;
import com.google.appengine.api.datastore.DatastoreV4Proxy;
import com.google.appengine.api.datastore.TransactionImpl;
import com.google.appengine.repackaged.com.google.common.primitives.Bytes;
import com.google.appengine.repackaged.com.google.protobuf.InvalidProtocolBufferException;
import com.google.apphosting.datastore.DatastoreV4;
import java.util.Collection;
import java.util.concurrent.Future;

class InternalTransactionV4
extends BaseInternalTransactionV4<byte[]> {
    private final DatastoreV4.CommitRequest.Builder commitReqBuilder = DatastoreV4.CommitRequest.newBuilder();

    private InternalTransactionV4(DatastoreV4Proxy dsApiProxy, Future<DatastoreV4.BeginTransactionResponse> beginTxnFuture) {
        super(dsApiProxy, beginTxnFuture);
    }

    static TransactionImpl.InternalTransaction create(DatastoreV4Proxy dsApiProxy, Future<DatastoreV4.BeginTransactionResponse> future) {
        return InternalTransactionV4.registerTxn(new InternalTransactionV4(dsApiProxy, future));
    }

    @Override
    byte[] serializeMutation(DatastoreV4.Mutation mutation) {
        byte[] bytes = this.commitReqBuilder.addMutation(mutation).buildPartial().toByteArray();
        this.commitReqBuilder.clearMutation();
        return bytes;
    }

    @Override
    Future<?> sendCommit(Collection<byte[]> mutations) {
        byte[][] protoSegmentsArray = new byte[mutations.size() + 1][];
        protoSegmentsArray[0] = DatastoreV4.CommitRequest.newBuilder().setTransaction(this.getHandle()).build().toByteArray();
        int arrayIndex = 1;
        for (byte[] mutData : mutations) {
            protoSegmentsArray[arrayIndex++] = mutData;
        }
        try {
            return this.dsApiProxy.rawCommit(Bytes.concat(protoSegmentsArray));
        }
        catch (InvalidProtocolBufferException e) {
            throw new RuntimeException("Unexpected error.", e);
        }
    }
}

