/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.protobuf;

import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.appengine.repackaged.com.google.protobuf.CodedInputStream;
import com.google.appengine.repackaged.com.google.protobuf.CodedOutputStream;
import com.google.appengine.repackaged.com.google.protobuf.InvalidProtocolBufferException;
import com.google.appengine.repackaged.com.google.protobuf.WireFormat;
import java.io.IOException;

public final class UnknownFieldSetLite {
    private static final UnknownFieldSetLite DEFAULT_INSTANCE = new UnknownFieldSetLite(ByteString.EMPTY);
    private final ByteString byteString;

    public static UnknownFieldSetLite getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    static UnknownFieldSetLite concat(UnknownFieldSetLite first, UnknownFieldSetLite second) {
        return new UnknownFieldSetLite(first.byteString.concat(second.byteString));
    }

    private UnknownFieldSetLite(ByteString byteString) {
        this.byteString = byteString;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        output.writeRawBytes(this.byteString);
    }

    public int getSerializedSize() {
        return this.byteString.size();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof UnknownFieldSetLite) {
            return this.byteString.equals(((UnknownFieldSetLite)obj).byteString);
        }
        return false;
    }

    public int hashCode() {
        return this.byteString.hashCode();
    }

    public static final class Builder {
        private ByteString.Output byteStringOutput;
        private CodedOutputStream output;

        private Builder() {
        }

        private void ensureInitializedButNotReused() {
            if (this.output == null) {
                if (this.byteStringOutput == null) {
                    this.byteStringOutput = ByteString.newOutput(100);
                    this.output = CodedOutputStream.newInstance(this.byteStringOutput);
                } else {
                    throw new IllegalStateException("Do not reuse UnknownFieldSetLite Builders.");
                }
            }
        }

        public boolean mergeFieldFrom(int tag, CodedInputStream input) throws IOException {
            this.ensureInitializedButNotReused();
            int fieldNumber = WireFormat.getTagFieldNumber(tag);
            switch (WireFormat.getTagWireType(tag)) {
                case 0: {
                    this.output.writeUInt64(fieldNumber, input.readInt64());
                    return true;
                }
                case 5: {
                    this.output.writeFixed32(fieldNumber, input.readFixed32());
                    return true;
                }
                case 1: {
                    this.output.writeFixed64(fieldNumber, input.readFixed64());
                    return true;
                }
                case 2: {
                    this.output.writeBytes(fieldNumber, input.readBytes());
                    return true;
                }
                case 3: {
                    Builder subBuilder = UnknownFieldSetLite.newBuilder();
                    subBuilder.mergeFrom(input);
                    input.checkLastTagWas(WireFormat.makeTag(fieldNumber, 4));
                    this.output.writeTag(fieldNumber, 3);
                    subBuilder.build().writeTo(this.output);
                    this.output.writeTag(fieldNumber, 4);
                    return true;
                }
                case 4: {
                    return false;
                }
            }
            throw InvalidProtocolBufferException.invalidWireType();
        }

        public Builder mergeVarintField(int fieldNumber, int value) {
            if (fieldNumber == 0) {
                throw new IllegalArgumentException("Zero is not a valid field number.");
            }
            this.ensureInitializedButNotReused();
            try {
                this.output.writeUInt64(fieldNumber, value);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return this;
        }

        public UnknownFieldSetLite build() {
            UnknownFieldSetLite result;
            if (this.output == null) {
                if (this.byteStringOutput != null) {
                    throw new IllegalStateException("Do not reuse UnknownFieldSetLite Builders.");
                }
                result = UnknownFieldSetLite.getDefaultInstance();
            } else {
                try {
                    this.output.flush();
                }
                catch (IOException e) {
                    // empty catch block
                }
                ByteString byteString = this.byteStringOutput.toByteString();
                result = byteString.isEmpty() ? UnknownFieldSetLite.getDefaultInstance() : new UnknownFieldSetLite(byteString);
            }
            this.output = null;
            return result;
        }

        private Builder mergeFrom(CodedInputStream input) throws IOException {
            int tag;
            while ((tag = input.readTag()) != 0 && this.mergeFieldFrom(tag, input)) {
            }
            return this;
        }
    }
}

