/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.base;

import com.google.appengine.repackaged.com.google.common.annotations.GoogleInternal;
import com.google.appengine.repackaged.com.google.common.annotations.GwtCompatible;
import com.google.appengine.repackaged.com.google.common.base.Function;
import com.google.appengine.repackaged.com.google.common.base.Objects;
import java.io.Serializable;
import java.util.Comparator;
import javax.annotation.Nullable;

@GoogleInternal
@GwtCompatible(serializable=true)
public class Pair<A, B>
implements Serializable {
    public final A first;
    public final B second;
    private static final long serialVersionUID = 747826592375603043L;

    public static <A, B> Pair<A, B> of(@Nullable A first, @Nullable B second) {
        return new Pair<A, B>(first, second);
    }

    public Pair(@Nullable A first, @Nullable B second) {
        this.first = first;
        this.second = second;
    }

    public A getFirst() {
        return this.first;
    }

    public B getSecond() {
        return this.second;
    }

    public static <A, B> Function<Pair<A, B>, A> firstFunction() {
        return PairFirstFunction.INSTANCE;
    }

    public static <A, B> Function<Pair<A, B>, B> secondFunction() {
        return PairSecondFunction.INSTANCE;
    }

    public static <A extends Comparable, B> Comparator<Pair<A, B>> compareByFirst() {
        return FirstComparator.FIRST_COMPARATOR;
    }

    public static <A, B extends Comparable> Comparator<Pair<A, B>> compareBySecond() {
        return SecondComparator.SECOND_COMPARATOR;
    }

    public boolean equals(@Nullable Object object) {
        if (object instanceof Pair) {
            Pair that = (Pair)object;
            return Objects.equal(this.first, that.first) && Objects.equal(this.second, that.second);
        }
        return false;
    }

    public int hashCode() {
        int hash1 = this.first == null ? 0 : this.first.hashCode();
        int hash2 = this.second == null ? 0 : this.second.hashCode();
        return 31 * hash1 + hash2;
    }

    public String toString() {
        String string = String.valueOf(String.valueOf(this.first));
        String string2 = String.valueOf(String.valueOf(this.second));
        return new StringBuilder(4 + string.length() + string2.length()).append("(").append(string).append(", ").append(string2).append(")").toString();
    }

    private static enum SecondComparator implements Comparator<Pair<Object, Comparable>>
    {
        SECOND_COMPARATOR;


        @Override
        public int compare(Pair<Object, Comparable> pair1, Pair<Object, Comparable> pair2) {
            Comparable left = pair1.getSecond();
            Comparable right = pair2.getSecond();
            int result = left.compareTo(right);
            return result;
        }
    }

    private static enum FirstComparator implements Comparator<Pair<Comparable, Object>>
    {
        FIRST_COMPARATOR;


        @Override
        public int compare(Pair<Comparable, Object> pair1, Pair<Comparable, Object> pair2) {
            Comparable left = pair1.getFirst();
            Comparable right = pair2.getFirst();
            int result = left.compareTo(right);
            return result;
        }
    }

    private static final class PairSecondFunction<A, B>
    implements Function<Pair<A, B>, B>,
    Serializable {
        static final PairSecondFunction<Object, Object> INSTANCE = new PairSecondFunction();

        private PairSecondFunction() {
        }

        @Override
        public B apply(Pair<A, B> from) {
            return from.getSecond();
        }

        private Object readResolve() {
            return INSTANCE;
        }
    }

    private static final class PairFirstFunction<A, B>
    implements Function<Pair<A, B>, A>,
    Serializable {
        static final PairFirstFunction<Object, Object> INSTANCE = new PairFirstFunction();

        private PairFirstFunction() {
        }

        @Override
        public A apply(Pair<A, B> from) {
            return from.getFirst();
        }

        private Object readResolve() {
            return INSTANCE;
        }
    }
}

