/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.io.protocol;

import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.EmptyStackException;

public final class ProtocolSource {
    private final byte[] buf;
    private int pos;
    private int limit;
    private IntStack lengthStack;

    public ProtocolSource(byte[] array, int offset, int length) {
        this.buf = array;
        this.pos = offset;
        this.limit = offset + length;
    }

    public ProtocolSource(byte[] array) {
        this(array, 0, array.length);
    }

    public ProtocolSource(ByteBuffer buffer, int offset, int length) {
        if (buffer.hasArray()) {
            if (offset + length > buffer.limit()) {
                throw new BufferUnderflowException();
            }
            this.buf = buffer.array();
            this.pos = buffer.arrayOffset() + offset;
            this.limit = this.pos + length;
        } else {
            this.limit = length;
            this.pos = 0;
            this.buf = new byte[this.limit];
            int oldPosition = buffer.position();
            buffer.position(offset);
            buffer.get(this.buf);
            buffer.position(oldPosition);
        }
    }

    public ProtocolSource(ByteBuffer buffer) {
        this(buffer, buffer.position(), buffer.remaining());
    }

    private void checkLength(long length) {
        if ((long)this.pos + length > (long)this.limit) {
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    public final ProtocolSource push(int length) {
        this.checkLength(length);
        this.getLengthStack().push(this.limit);
        this.limit = this.pos + length;
        return this;
    }

    public final ProtocolSource pop() {
        this.checkLength(0L);
        this.pos = this.limit;
        this.limit = this.getLengthStack().pop();
        return this;
    }

    private IntStack getLengthStack() {
        if (this.lengthStack == null) {
            this.lengthStack = new IntStack();
            return this.lengthStack;
        }
        return this.lengthStack;
    }

    final void reset() {
        this.pos = 0;
    }

    public final int position() {
        return this.pos;
    }

    public final byte[] array() {
        return this.buf;
    }

    public final void getBytes(byte[] dst, int offset, int length) {
        this.checkLength(length);
        System.arraycopy(this.buf, this.pos, dst, offset, length);
        this.pos += length;
    }

    public final byte getByteUnmasked() {
        return this.buf[this.pos++];
    }

    public final int getByte() {
        return this.getByteUnmasked() & 0xFF;
    }

    public final int getShort() {
        this.checkLength(2L);
        return this.buf[this.pos++] & 0xFF | this.buf[this.pos++] << 8;
    }

    public final int getInt() {
        this.checkLength(4L);
        return this.buf[this.pos++] & 0xFF | (this.buf[this.pos++] & 0xFF) << 8 | (this.buf[this.pos++] & 0xFF) << 16 | this.buf[this.pos++] << 24;
    }

    public final long getLong() {
        this.checkLength(8L);
        long b1 = this.buf[this.pos++] & 0xFF;
        long b2 = this.buf[this.pos++] & 0xFF;
        long b3 = this.buf[this.pos++] & 0xFF;
        long b4 = this.buf[this.pos++] & 0xFF;
        long b5 = this.buf[this.pos++] & 0xFF;
        long b6 = this.buf[this.pos++] & 0xFF;
        long b7 = this.buf[this.pos++] & 0xFF;
        long b8 = this.buf[this.pos++];
        return b8 << 56 | b7 << 48 | b6 << 40 | b5 << 32 | b4 << 24 | b3 << 16 | b2 << 8 | b1;
    }

    public final int remaining() {
        return this.limit - this.pos;
    }

    public final boolean hasRemaining() {
        return this.pos != this.limit;
    }

    public final void skip(int n) {
        this.checkLength(n);
        this.pos += n;
    }

    public final int getVarInt() {
        byte tmp = this.getByteUnmasked();
        if (tmp >= 0) {
            return tmp;
        }
        int result = tmp & 0x7F;
        tmp = this.getByteUnmasked();
        if (tmp >= 0) {
            result |= tmp << 7;
        } else {
            result |= (tmp & 0x7F) << 7;
            tmp = this.getByteUnmasked();
            if (tmp >= 0) {
                result |= tmp << 14;
            } else {
                result |= (tmp & 0x7F) << 14;
                tmp = this.getByteUnmasked();
                if (tmp >= 0) {
                    result |= tmp << 21;
                } else {
                    result |= (tmp & 0x7F) << 21;
                    tmp = this.getByteUnmasked();
                    result |= tmp << 28;
                    while (tmp < 0) {
                        tmp = this.getByteUnmasked();
                    }
                }
            }
        }
        this.checkLength(0L);
        return result;
    }

    public final long getVarLong() {
        long tmp = this.getByteUnmasked();
        if (tmp >= 0L) {
            return tmp;
        }
        long result = tmp & 0x7FL;
        tmp = this.getByteUnmasked();
        if (tmp >= 0L) {
            result |= tmp << 7;
        } else {
            result |= (tmp & 0x7FL) << 7;
            tmp = this.getByteUnmasked();
            if (tmp >= 0L) {
                result |= tmp << 14;
            } else {
                result |= (tmp & 0x7FL) << 14;
                tmp = this.getByteUnmasked();
                if (tmp >= 0L) {
                    result |= tmp << 21;
                } else {
                    result |= (tmp & 0x7FL) << 21;
                    tmp = this.getByteUnmasked();
                    if (tmp >= 0L) {
                        result |= tmp << 28;
                    } else {
                        result |= (tmp & 0x7FL) << 28;
                        tmp = this.getByteUnmasked();
                        if (tmp >= 0L) {
                            result |= tmp << 35;
                        } else {
                            result |= (tmp & 0x7FL) << 35;
                            tmp = this.getByteUnmasked();
                            if (tmp >= 0L) {
                                result |= tmp << 42;
                            } else {
                                result |= (tmp & 0x7FL) << 42;
                                tmp = this.getByteUnmasked();
                                if (tmp >= 0L) {
                                    result |= tmp << 49;
                                } else {
                                    result |= (tmp & 0x7FL) << 49;
                                    tmp = this.getByteUnmasked();
                                    if (tmp >= 0L) {
                                        result |= tmp << 56;
                                    } else {
                                        result |= (tmp & 0x7FL) << 56;
                                        result |= (long)this.getByteUnmasked() << 63;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        this.checkLength(0L);
        return result;
    }

    public final boolean getBoolean() {
        return this.getVarInt() != 0;
    }

    public final float getFloat() {
        return Float.intBitsToFloat(this.getInt());
    }

    public final double getDouble() {
        return Double.longBitsToDouble(this.getLong());
    }

    public final byte[] getPrefixedData() {
        int len = this.getVarInt();
        this.checkLength(len);
        byte[] b = ProtocolSource.newByteArray(len);
        this.getBytes(b, 0, len);
        return b;
    }

    private static int getTagFormat(int tagWord) {
        return tagWord & 7;
    }

    private static int getTag(int tagWord) {
        return tagWord >>> 3;
    }

    private static int makeTagWord(int tag, int tagFormat) {
        assert ((tagFormat & 7) == tagFormat);
        return tag << 3 | tagFormat;
    }

    private static int endTag(int tag) {
        return ProtocolSource.makeTagWord(tag, 4);
    }

    public final void skipData(int tagWord) {
        switch (ProtocolSource.getTagFormat(tagWord)) {
            case 0: {
                while (this.getByteUnmasked() < 0) {
                }
                break;
            }
            case 5: {
                this.skip(4);
                break;
            }
            case 1: {
                this.skip(8);
                break;
            }
            case 2: {
                this.skip(this.getVarInt());
                break;
            }
            case 3: {
                int nextTagWord;
                int endWord = ProtocolSource.endTag(ProtocolSource.getTag(tagWord));
                while ((nextTagWord = this.getVarInt()) != endWord) {
                    this.skipData(nextTagWord);
                }
                break;
            }
            case 4: {
                int n = tagWord;
                throw new IllegalArgumentException(new StringBuilder(31).append("unexpected ENDGROUP ").append(n).toString());
            }
            default: {
                int n = tagWord;
                throw new IllegalArgumentException(new StringBuilder(35).append("unexpected type code in ").append(n).toString());
            }
        }
    }

    public final byte[] getUninterpreted(int tagWord) {
        int startPosition = this.pos;
        this.skipData(tagWord);
        int length = this.pos - startPosition;
        byte[] b = ProtocolSource.newByteArray(length);
        System.arraycopy(this.buf, startPosition, b, 0, length);
        return b;
    }

    private static byte[] newByteArray(int length) {
        try {
            return new byte[length];
        }
        catch (NegativeArraySizeException e) {
            throw new IllegalArgumentException(e);
        }
        catch (OutOfMemoryError e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static class IntStack {
        int[] stack = new int[1];
        int topPos = 0;

        IntStack() {
        }

        void push(int i) {
            if (this.topPos == this.stack.length) {
                int newLength = this.stack.length * 2;
                int[] copy = new int[newLength];
                System.arraycopy(this.stack, 0, copy, 0, this.stack.length);
                this.stack = copy;
            }
            this.stack[this.topPos] = i;
            ++this.topPos;
        }

        int pop() {
            if (this.topPos == 0) {
                throw new EmptyStackException();
            }
            return this.stack[--this.topPos];
        }
    }
}

