/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.client.datastoreservice.app;

import com.google.appengine.api.oauth.OAuthServiceFactory;
import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.client.datastoreservice.app.DatastoreRpcService;
import com.google.apphosting.client.serviceapp.AuthService;
import com.google.apphosting.client.serviceapp.AuthServiceImpl;
import com.google.apphosting.client.serviceapp.BaseApiServlet;

public class DatastoreApiServlet
extends BaseApiServlet {
    @VisibleForTesting
    static final String API_HEADER = "X-AppEngine-Datastore-API";
    @VisibleForTesting
    static final String[] OAUTH2_SCOPE_STRINGS = new String[]{"https://www.googleapis.com/auth/datastore", "https://www.googleapis.com/auth/cloud-platform"};
    @VisibleForTesting
    public static final String[] OAUTH2_SCOPE_CODES = new String[]{"43600", "35600"};

    public DatastoreApiServlet() {
        this(new AuthServiceImpl(OAuthServiceFactory.getOAuthService()));
    }

    @VisibleForTesting
    public DatastoreApiServlet(AuthService authService) {
        super(new DatastoreRpcService(ApiProxy.getCurrentEnvironment().getAppId()), authService);
    }

    @VisibleForTesting
    DatastoreApiServlet(DatastoreRpcService service, AuthService authService) {
        super(service, authService);
    }

    @Override
    protected String getApiHeader() {
        return API_HEADER;
    }

    @Override
    protected String[] getOAuthScopeStrings() {
        return OAUTH2_SCOPE_STRINGS;
    }

    @Override
    protected String[] getOAuthScopeCodes() {
        return OAUTH2_SCOPE_CODES;
    }
}

