/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.client.datastoreservice.app;

import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.repackaged.com.google.common.base.Function;
import com.google.appengine.repackaged.com.google.common.base.Predicates;
import com.google.appengine.repackaged.com.google.net.util.error.Codes;
import com.google.appengine.repackaged.com.google.protobuf.Parser;
import com.google.apphosting.client.datastoreservice.app.DatastoreClient;
import com.google.apphosting.client.datastoreservice.app.DatastoreRpcHandler;
import com.google.apphosting.client.datastoreservice.app.EntityV4Normalizer;
import com.google.apphosting.client.datastoreservice.app.QueryV4Normalizer;
import com.google.apphosting.client.datastoreservice.proto.DatastoreService;
import com.google.apphosting.client.serviceapp.RpcException;
import com.google.apphosting.client.serviceapp.RpcHandler;
import com.google.apphosting.datastore.DatastoreV4;

class RunQueryHandler
extends DatastoreRpcHandler<DatastoreService.RunQueryRequest, DatastoreService.RunQueryResponse, DatastoreClient> {
    private final Function<DatastoreV4.EntityResult, DatastoreV4.EntityResult> resultTransform;
    private final QueryV4Normalizer queryNormalizer;

    public RunQueryHandler(DatastoreClient datastoreClient, EntityV4Normalizer entityNormalizer, Function<DatastoreV4.EntityResult, DatastoreV4.EntityResult> resultTransform) {
        super(datastoreClient);
        this.resultTransform = resultTransform;
        this.queryNormalizer = new QueryV4Normalizer(entityNormalizer);
    }

    @Override
    public DatastoreService.RunQueryResponse call(RpcHandler.CallOptions options, DatastoreService.RunQueryRequest req) throws RpcException {
        return ((DatastoreClient)this.datastoreClient).runQuery(options, this.resultTransform, this.queryNormalizer.toV4RunQueryRequest(req), Predicates.alwaysTrue()).getQueryResponse();
    }

    @Override
    public Parser<DatastoreService.RunQueryRequest> getParser() {
        return DatastoreService.RunQueryRequest.PARSER;
    }

    @Override
    public Class<DatastoreService.RunQueryRequest> getRequestClass() {
        return DatastoreService.RunQueryRequest.class;
    }

    @Override
    public DatastoreService.RunQueryResponse makeError(Codes.Code errorCode, String message) {
        return DatastoreService.RunQueryResponse.newBuilder().setHeader(RunQueryHandler.makeErrorHeader(errorCode, message)).build();
    }

    @Override
    public RpcHandler.RequestPermissions getRequiredPermissions(DatastoreService.RunQueryRequest request) {
        return RpcHandler.RequestPermissions.READ;
    }

    @VisibleForTesting
    QueryV4Normalizer getQueryNormalizer() {
        return this.queryNormalizer;
    }
}

