/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.AsyncCloudDatastoreV1ServiceImpl;
import com.google.appengine.api.datastore.AsyncDatastoreServiceImpl;
import com.google.appengine.api.datastore.AsyncDatastoreServiceInternal;
import com.google.appengine.api.datastore.CloudDatastoreV1Proxy;
import com.google.appengine.api.datastore.DatastoreService;
import com.google.appengine.api.datastore.DatastoreServiceConfig;
import com.google.appengine.api.datastore.DatastoreServiceImpl;
import com.google.appengine.api.datastore.IDatastoreServiceFactory;
import com.google.appengine.api.datastore.LocalCloudDatastoreV1Proxy;
import com.google.appengine.api.datastore.RemoteCloudDatastoreV1Proxy;
import com.google.appengine.api.datastore.TransactionStackImpl;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;

final class DatastoreServiceFactoryImpl
implements IDatastoreServiceFactory {
    private static final String MIXED_SERVICES_MESSAGE = "Cannot create both Cloud and non-Cloud Datastore services.";
    private static boolean constructedNonCloudService;
    private static boolean constructedCloudService;

    DatastoreServiceFactoryImpl() {
    }

    @Override
    public DatastoreService getDatastoreService(DatastoreServiceConfig config) {
        return new DatastoreServiceImpl(this.getAsyncDatastoreService(config));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AsyncDatastoreServiceInternal getAsyncDatastoreService(DatastoreServiceConfig config) {
        TransactionStackImpl txnStack = new TransactionStackImpl();
        CloudDatastoreV1Proxy cloudDatastoreProxy = config.getCloudDatastoreV1Proxy();
        DatastoreServiceConfig.ApiVersion apiVersion = config.getApiVersion();
        Class<DatastoreServiceFactoryImpl> clazz = DatastoreServiceFactoryImpl.class;
        synchronized (DatastoreServiceFactoryImpl.class) {
            if (apiVersion.isCloudService()) {
                if (constructedNonCloudService) {
                    throw new IllegalArgumentException(MIXED_SERVICES_MESSAGE);
                }
                constructedCloudService = true;
            } else {
                if (constructedCloudService) {
                    throw new IllegalArgumentException(MIXED_SERVICES_MESSAGE);
                }
                constructedNonCloudService = true;
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            switch (apiVersion) {
                case V3: {
                    Preconditions.checkState(cloudDatastoreProxy == null);
                    return new AsyncDatastoreServiceImpl(config, config.constructApiConfig(), txnStack);
                }
                case CLOUD_DATASTORE_V1_VIA_API_PROXY: {
                    Preconditions.checkState(cloudDatastoreProxy == null);
                    return new AsyncCloudDatastoreV1ServiceImpl(config, new LocalCloudDatastoreV1Proxy(config.constructApiConfig()), txnStack);
                }
                case CLOUD_DATASTORE_V1_REMOTE: {
                    if (cloudDatastoreProxy == null) {
                        cloudDatastoreProxy = RemoteCloudDatastoreV1Proxy.create(config);
                    }
                    return new AsyncCloudDatastoreV1ServiceImpl(config, cloudDatastoreProxy, txnStack);
                }
            }
            throw new IllegalArgumentException("Can't instantiate service with API version: " + (Object)((Object)apiVersion));
        }
    }

    static synchronized void resetConstructionStateForTest() {
        constructedNonCloudService = false;
        constructedCloudService = false;
    }
}

