/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.DataTypeTranslator;
import com.google.appengine.api.datastore.GeoPt;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.users.User;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.datastore.v1beta3.Value;
import com.google.appengine.repackaged.com.google.datastore.v1beta3.client.DatastoreHelper;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;

public final class RawValue
implements Serializable {
    private static final long serialVersionUID = 8176992854378814427L;
    private transient OnestoreEntity.PropertyValue valueV3 = null;
    private transient Value valueV1 = null;

    RawValue(OnestoreEntity.PropertyValue propertyValue) {
        this.valueV3 = Preconditions.checkNotNull(propertyValue);
    }

    RawValue(Value value) {
        this.valueV1 = Preconditions.checkNotNull(value);
    }

    public <T> T asStrictType(Class<T> type) {
        Object value = this.asType(type);
        if (value != null) {
            Preconditions.checkArgument(type.isAssignableFrom(value.getClass()), "Unsupported type: " + type);
        }
        return (T)value;
    }

    public Object asType(Class<?> type) {
        DataTypeTranslator.Type<?> typeAdapter = DataTypeTranslator.getTypeMap().get(type);
        Preconditions.checkArgument(typeAdapter != null, "Unsupported type: " + type);
        if (this.valueV3 != null) {
            if (typeAdapter.hasValue(this.valueV3)) {
                return typeAdapter.getValue(this.valueV3);
            }
        } else if (this.valueV1 != null && typeAdapter.hasValue(this.valueV1)) {
            return typeAdapter.getValue(this.valueV1);
        }
        Preconditions.checkArgument(this.getValue() == null, "Type mismatch.");
        return null;
    }

    public Object getValue() {
        if (this.valueV3 != null) {
            if (this.valueV3.hasBooleanValue()) {
                return this.valueV3.isBooleanValue();
            }
            if (this.valueV3.hasDoubleValue()) {
                return this.valueV3.getDoubleValue();
            }
            if (this.valueV3.hasInt64Value()) {
                return this.valueV3.getInt64Value();
            }
            if (this.valueV3.hasPointValue()) {
                return this.asType(GeoPt.class);
            }
            if (this.valueV3.hasReferenceValue()) {
                return this.asType(Key.class);
            }
            if (this.valueV3.hasStringValue()) {
                return this.valueV3.getStringValueAsBytes();
            }
            if (this.valueV3.hasUserValue()) {
                return this.asType(User.class);
            }
        } else if (this.valueV1 != null) {
            switch (this.valueV1.getValueTypeCase()) {
                case BOOLEAN_VALUE: {
                    return this.valueV1.getBooleanValue();
                }
                case DOUBLE_VALUE: {
                    return this.valueV1.getDoubleValue();
                }
                case INTEGER_VALUE: {
                    return this.valueV1.getIntegerValue();
                }
                case ENTITY_VALUE: {
                    if (this.valueV1.getMeaning() == 20) {
                        return this.asType(User.class);
                    }
                    throw new IllegalStateException("Raw entity value is not supported.");
                }
                case KEY_VALUE: {
                    return this.asType(Key.class);
                }
                case STRING_VALUE: {
                    return this.valueV1.getStringValueBytes().toByteArray();
                }
                case BLOB_VALUE: {
                    return this.valueV1.getBlobValue().toByteArray();
                }
                case TIMESTAMP_VALUE: {
                    return DatastoreHelper.getTimestamp(this.valueV1);
                }
                case GEO_POINT_VALUE: {
                    if (this.valueV1.getMeaning() != 0 && this.valueV1.getMeaning() != OnestoreEntity.Property.Meaning.INDEX_VALUE.getValue()) break;
                    return this.asType(GeoPt.class);
                }
                case ARRAY_VALUE: {
                    throw new IllegalStateException("Raw array value is not supported.");
                }
                default: {
                    return null;
                }
            }
        }
        return null;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (this.valueV3 != null) {
            out.write(1);
            this.valueV3.writeTo(out);
        } else {
            out.write(2);
            this.valueV1.writeTo(out);
        }
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int version = in.read();
        if (version == 1) {
            this.valueV3 = new OnestoreEntity.PropertyValue();
            this.valueV3.parseFrom(in);
        } else if (version == 2) {
            this.valueV1 = Value.PARSER.parseFrom(in);
        } else {
            Preconditions.checkArgument(false, "unknown RawValue format");
        }
        in.defaultReadObject();
    }

    public int hashCode() {
        Object value = this.getValue();
        return value == null ? 0 : value.hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RawValue other = (RawValue)obj;
        Object value = this.getValue();
        Object otherValue = other.getValue();
        if (value != null) {
            if (otherValue == null) return false;
            if (!(value instanceof byte[])) return value.equals(otherValue);
            if (!(otherValue instanceof byte[])) return false;
            return Arrays.equals((byte[])value, (byte[])otherValue);
        }
        if (otherValue != null) return false;
        return true;
    }

    public String toString() {
        return "RawValue [value=" + this.getValue() + "]";
    }
}

