/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.CloudDatastoreV1Proxy;
import com.google.appengine.api.datastore.DatastoreFailureException;
import com.google.appengine.api.datastore.DatastoreNeedIndexException;
import com.google.appengine.api.datastore.DatastoreServiceConfig;
import com.google.appengine.api.datastore.DatastoreTimeoutException;
import com.google.appengine.api.datastore.EnvProxy;
import com.google.appengine.repackaged.com.google.api.client.auth.oauth2.Credential;
import com.google.appengine.repackaged.com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.appengine.repackaged.com.google.api.client.googleapis.compute.ComputeCredential;
import com.google.appengine.repackaged.com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.appengine.repackaged.com.google.api.client.http.HttpRequest;
import com.google.appengine.repackaged.com.google.api.client.http.HttpRequestInitializer;
import com.google.appengine.repackaged.com.google.api.client.http.javanet.NetHttpTransport;
import com.google.appengine.repackaged.com.google.api.client.json.jackson.JacksonFactory;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.datastore.v1beta3.AllocateIdsRequest;
import com.google.appengine.repackaged.com.google.datastore.v1beta3.AllocateIdsResponse;
import com.google.appengine.repackaged.com.google.datastore.v1beta3.BeginTransactionRequest;
import com.google.appengine.repackaged.com.google.datastore.v1beta3.BeginTransactionResponse;
import com.google.appengine.repackaged.com.google.datastore.v1beta3.CommitRequest;
import com.google.appengine.repackaged.com.google.datastore.v1beta3.CommitResponse;
import com.google.appengine.repackaged.com.google.datastore.v1beta3.LookupRequest;
import com.google.appengine.repackaged.com.google.datastore.v1beta3.LookupResponse;
import com.google.appengine.repackaged.com.google.datastore.v1beta3.RollbackRequest;
import com.google.appengine.repackaged.com.google.datastore.v1beta3.RollbackResponse;
import com.google.appengine.repackaged.com.google.datastore.v1beta3.RunQueryRequest;
import com.google.appengine.repackaged.com.google.datastore.v1beta3.RunQueryResponse;
import com.google.appengine.repackaged.com.google.datastore.v1beta3.client.Datastore;
import com.google.appengine.repackaged.com.google.datastore.v1beta3.client.DatastoreException;
import com.google.appengine.repackaged.com.google.datastore.v1beta3.client.DatastoreFactory;
import com.google.appengine.repackaged.com.google.datastore.v1beta3.client.DatastoreOptions;
import com.google.appengine.repackaged.com.google.protobuf.InvalidProtocolBufferException;
import com.google.appengine.repackaged.com.google.protobuf.Message;
import com.google.apphosting.api.ApiProxy;
import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class RemoteCloudDatastoreV1Proxy
implements CloudDatastoreV1Proxy {
    private static final ExecutorService executor = Executors.newCachedThreadPool();
    private final Datastore datastore;
    private static final Pattern reasonPattern = Pattern.compile("\"reason\": \"(.*)\",?\\n");
    private static final Pattern messagePattern = Pattern.compile("\"message\": \"(.*)\",?\\n");

    RemoteCloudDatastoreV1Proxy(Datastore datastore) {
        this.datastore = Preconditions.checkNotNull(datastore);
    }

    static RemoteCloudDatastoreV1Proxy create(DatastoreServiceConfig config) {
        DatastoreOptions options;
        Preconditions.checkArgument(config.getApiVersion() == DatastoreServiceConfig.ApiVersion.CLOUD_DATASTORE_V1_REMOTE);
        try {
            options = RemoteCloudDatastoreV1Proxy.getDatastoreOptions();
        }
        catch (IOException | GeneralSecurityException e) {
            throw new RuntimeException("Could not get Cloud Datastore options from environment.", e);
        }
        RemoteCloudDatastoreV1Proxy.ensureApiProxyIsConfigured(options);
        return new RemoteCloudDatastoreV1Proxy(DatastoreFactory.get().create(options));
    }

    @Override
    public Future<BeginTransactionResponse> beginTransaction(final BeginTransactionRequest req) {
        return RemoteCloudDatastoreV1Proxy.makeCall(new Callable<BeginTransactionResponse>(){

            @Override
            public BeginTransactionResponse call() throws DatastoreException {
                return RemoteCloudDatastoreV1Proxy.this.datastore.beginTransaction(req);
            }
        });
    }

    @Override
    public Future<RollbackResponse> rollback(final RollbackRequest req) {
        return RemoteCloudDatastoreV1Proxy.makeCall(new Callable<RollbackResponse>(){

            @Override
            public RollbackResponse call() throws DatastoreException {
                return RemoteCloudDatastoreV1Proxy.this.datastore.rollback(req);
            }
        });
    }

    @Override
    public Future<RunQueryResponse> runQuery(final RunQueryRequest req) {
        return RemoteCloudDatastoreV1Proxy.makeCall(new Callable<RunQueryResponse>(){

            @Override
            public RunQueryResponse call() throws DatastoreException {
                return RemoteCloudDatastoreV1Proxy.this.datastore.runQuery(req);
            }
        });
    }

    @Override
    public Future<LookupResponse> lookup(final LookupRequest req) {
        return RemoteCloudDatastoreV1Proxy.makeCall(new Callable<LookupResponse>(){

            @Override
            public LookupResponse call() throws DatastoreException {
                return RemoteCloudDatastoreV1Proxy.this.datastore.lookup(req);
            }
        });
    }

    @Override
    public Future<AllocateIdsResponse> allocateIds(final AllocateIdsRequest req) {
        return RemoteCloudDatastoreV1Proxy.makeCall(new Callable<AllocateIdsResponse>(){

            @Override
            public AllocateIdsResponse call() throws DatastoreException {
                return RemoteCloudDatastoreV1Proxy.this.datastore.allocateIds(req);
            }
        });
    }

    @Override
    public Future<CommitResponse> commit(final CommitRequest req) {
        return RemoteCloudDatastoreV1Proxy.makeCall(new Callable<CommitResponse>(){

            @Override
            public CommitResponse call() throws DatastoreException {
                return RemoteCloudDatastoreV1Proxy.this.datastore.commit(req);
            }
        });
    }

    @Override
    public Future<CommitResponse> rawCommit(byte[] bytes) {
        try {
            return this.commit(CommitRequest.parseFrom(bytes));
        }
        catch (InvalidProtocolBufferException e) {
            throw new IllegalStateException(e);
        }
    }

    private static <T extends Message> Future<T> makeCall(final Callable<T> request) {
        return executor.submit(new Callable<T>(){

            @Override
            public T call() throws Exception {
                try {
                    return (Message)request.call();
                }
                catch (DatastoreException e) {
                    throw RemoteCloudDatastoreV1Proxy.extractException(e.getMessage(), e.getCode());
                }
            }
        });
    }

    protected static Exception extractException(String rawMessage, int httpCode) {
        Matcher msgMatcher = messagePattern.matcher(rawMessage);
        String message = msgMatcher.find() ? msgMatcher.group(1) : "[" + rawMessage + "]\n";
        switch (httpCode) {
            case 400: {
                return new IllegalArgumentException(message);
            }
            case 403: {
                Matcher reasonMatch = reasonPattern.matcher(rawMessage);
                if (reasonMatch.find() && reasonMatch.group(1).equals("DEADLINE_EXCEEDED")) {
                    return new DatastoreTimeoutException(message);
                }
                return new IllegalStateException(message);
            }
            case 412: {
                return new DatastoreNeedIndexException(message);
            }
            case 409: {
                return new ConcurrentModificationException(message);
            }
            case 503: {
                return new IllegalStateException(message);
            }
            case 500: {
                return new DatastoreFailureException(message);
            }
        }
        return new RuntimeException(message);
    }

    private static DatastoreOptions getDatastoreOptions() throws GeneralSecurityException, IOException {
        DatastoreOptions.Builder options = new DatastoreOptions.Builder();
        options.projectId(EnvProxy.getenv("DATASTORE_PROJECT_ID"));
        options.host(EnvProxy.getenv("DATASTORE_HOST"));
        String serviceAccount = EnvProxy.getenv("DATASTORE_SERVICE_ACCOUNT");
        String privateKeyFile = EnvProxy.getenv("DATASTORE_PRIVATE_KEY_FILE");
        Credential credential = Boolean.valueOf(EnvProxy.getenv("__DATASTORE_USE_STUB_CREDENTIAL_FOR_TEST")) != false ? null : (serviceAccount != null && privateKeyFile != null ? RemoteCloudDatastoreV1Proxy.getServiceAccountCredential(serviceAccount, privateKeyFile) : RemoteCloudDatastoreV1Proxy.getComputeEngineCredential());
        options.credential(credential);
        final String versionOverrideForTest = EnvProxy.getenv("__DATASTORE_VERSION_OVERRIDE_FOR_TEST");
        if (versionOverrideForTest != null) {
            options.initializer(new HttpRequestInitializer(){

                @Override
                public void initialize(HttpRequest request) throws IOException {
                    request.getUrl().setRawPath(request.getUrl().getRawPath().replaceFirst("v1beta3", versionOverrideForTest));
                }
            });
        }
        return options.build();
    }

    private static Credential getServiceAccountCredential(String account, String privateKeyFile) throws GeneralSecurityException, IOException {
        return new GoogleCredential.Builder().setTransport(GoogleNetHttpTransport.newTrustedTransport()).setJsonFactory(new JacksonFactory()).setServiceAccountId(account).setServiceAccountScopes(DatastoreOptions.SCOPES).setServiceAccountPrivateKeyFromP12File(new File(privateKeyFile)).build();
    }

    private static Credential getComputeEngineCredential() throws GeneralSecurityException, IOException {
        NetHttpTransport transport = GoogleNetHttpTransport.newTrustedTransport();
        try {
            ComputeCredential credential = new ComputeCredential(transport, new JacksonFactory());
            credential.refreshToken();
            return credential;
        }
        catch (IOException e) {
            return null;
        }
    }

    private static synchronized void ensureApiProxyIsConfigured(DatastoreOptions options) {
        boolean hasDelegate;
        boolean hasEnvironmentOrFactory = ApiProxy.getCurrentEnvironment() != null;
        boolean bl = hasDelegate = ApiProxy.getDelegate() != null;
        if (hasEnvironmentOrFactory && hasDelegate) {
            return;
        }
        if (hasEnvironmentOrFactory) {
            throw new IllegalStateException("An ApiProxy.Environment or ApiProxy.EnvironmentFactory was already installed. Cannot use Cloud Datastore.");
        }
        if (hasDelegate) {
            throw new IllegalStateException("An ApiProxy.Delegate was already installed. Cannot use Cloud Datastore.");
        }
        ApiProxy.setEnvironmentFactory(new StubApiProxyEnvironmentFactory(options.getProjectId()));
        ApiProxy.setDelegate(new StubApiProxyDelegate());
    }

    static class StubApiProxyEnvironment
    implements ApiProxy.Environment {
        private final Map<String, Object> attributes = new HashMap<String, Object>();
        private final String appId;

        public StubApiProxyEnvironment(String appId) {
            this.appId = appId;
        }

        @Override
        public boolean isLoggedIn() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isAdmin() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getVersionId() {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public String getRequestNamespace() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getRemainingMillis() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getModuleId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getEmail() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getAuthDomain() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, Object> getAttributes() {
            return this.attributes;
        }

        @Override
        public String getAppId() {
            return this.appId;
        }
    }

    static class StubApiProxyEnvironmentFactory
    implements ApiProxy.EnvironmentFactory {
        private final String appId;

        public StubApiProxyEnvironmentFactory(String appId) {
            this.appId = appId;
        }

        @Override
        public ApiProxy.Environment newEnvironment() {
            return new StubApiProxyEnvironment(this.appId);
        }
    }

    static class StubApiProxyDelegate
    implements ApiProxy.Delegate<ApiProxy.Environment> {
        private static final String UNSUPPORTED_API_PATTERN = "Calls to %s.%s are not supported under this configuration, only calls to Cloud Datastore. To use other APIs, first install the Remote API.";

        StubApiProxyDelegate() {
        }

        @Override
        public byte[] makeSyncCall(ApiProxy.Environment environment, String packageName, String methodName, byte[] request) throws ApiProxy.ApiProxyException {
            throw new UnsupportedOperationException(String.format(UNSUPPORTED_API_PATTERN, packageName, methodName));
        }

        @Override
        public Future<byte[]> makeAsyncCall(ApiProxy.Environment environment, String packageName, String methodName, byte[] request, ApiProxy.ApiConfig apiConfig) {
            throw new UnsupportedOperationException(String.format(UNSUPPORTED_API_PATTERN, packageName, methodName));
        }

        @Override
        public void log(ApiProxy.Environment environment, ApiProxy.LogRecord record) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void flushLogs(ApiProxy.Environment environment) {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Thread> getRequestThreads(ApiProxy.Environment environment) {
            throw new UnsupportedOperationException();
        }
    }
}

