/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.NormalizedQuery;
import com.google.appengine.repackaged.com.google.common.collect.Sets;
import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.api.DatastorePb;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.HashSet;
import java.util.Set;

class ValidatedQuery
extends NormalizedQuery {
    static final Set<DatastorePb.Query.Filter.Operator> UNSUPPORTED_OPERATORS = ValidatedQuery.makeImmutableSet(DatastorePb.Query.Filter.Operator.IN);

    ValidatedQuery(DatastorePb.Query query) {
        super(query);
        this.validateQuery();
    }

    private void validateQuery() {
        if (this.query.propertyNameSize() > 0 && this.query.isKeysOnly()) {
            throw new IllegalQueryException("projection and keys_only cannot both be set", IllegalQueryType.ILLEGAL_PROJECTION);
        }
        HashSet<String> projectionProperties = new HashSet<String>(this.query.propertyNameSize());
        for (String property : this.query.propertyNames()) {
            if (projectionProperties.add(property)) continue;
            throw new IllegalQueryException("cannot project a property multiple times", IllegalQueryType.ILLEGAL_PROJECTION);
        }
        HashSet<String> groupBySet = Sets.newHashSetWithExpectedSize(this.query.groupByPropertyNameSize());
        for (String name : this.query.groupByPropertyNames()) {
            if (!groupBySet.add(name)) {
                throw new IllegalQueryException("cannot group by a property multiple times", IllegalQueryType.ILLEGAL_GROUPBY);
            }
            if (!Entity.RESERVED_NAME.matcher(name).matches()) continue;
            throw new IllegalQueryException("group by is not supported for the property: " + name, IllegalQueryType.ILLEGAL_GROUPBY);
        }
        HashSet<String> groupByInOrderSet = Sets.newHashSetWithExpectedSize(this.query.groupByPropertyNameSize());
        for (DatastorePb.Query.Order order : this.query.orders()) {
            if (groupBySet.contains(order.getProperty())) {
                groupByInOrderSet.add(order.getProperty());
                continue;
            }
            if (groupByInOrderSet.size() == groupBySet.size()) continue;
            throw new IllegalQueryException("must specify all group by orderings before any non group by orderings", IllegalQueryType.ILLEGAL_GROUPBY);
        }
        if (this.query.hasTransaction() && !this.query.hasAncestor()) {
            throw new IllegalQueryException("Only ancestor queries are allowed inside transactions.", IllegalQueryType.TRANSACTION_REQUIRES_ANCESTOR);
        }
        if (!this.query.hasKind()) {
            for (DatastorePb.Query.Filter filter : this.query.filters()) {
                if (filter.getProperty(0).getName().equals("__key__")) continue;
                throw new IllegalQueryException("kind is required for non-__key__ filters", IllegalQueryType.KIND_REQUIRED);
            }
            for (DatastorePb.Query.Order order : this.query.orders()) {
                if (order.getProperty().equals("__key__") && order.getDirection() == DatastorePb.Query.Order.Direction.ASCENDING.getValue()) continue;
                throw new IllegalQueryException("kind is required for all orders except __key__ ascending", IllegalQueryType.KIND_REQUIRED);
            }
        }
        String ineqProp = null;
        boolean isGeo = false;
        for (DatastorePb.Query.Filter filter : this.query.filters()) {
            int numProps = filter.propertySize();
            if (numProps != 1) {
                throw new IllegalQueryException(String.format("Filter has %s properties, expected 1", numProps), IllegalQueryType.FILTER_WITH_MULTIPLE_PROPS);
            }
            OnestoreEntity.Property prop = filter.getProperty(0);
            String propName = prop.getName();
            if ("__key__".equals(propName)) {
                OnestoreEntity.PropertyValue value = prop.getValue();
                if (!value.hasReferenceValue()) {
                    throw new IllegalQueryException("__key__ filter value must be a Key", IllegalQueryType.ILLEGAL_VALUE);
                }
                OnestoreEntity.PropertyValue.ReferenceValue refVal = value.getReferenceValue();
                if (!refVal.getApp().equals(this.query.getApp())) {
                    throw new IllegalQueryException("__key__ filter app is " + refVal.getApp() + " but query app is " + this.query.getApp(), IllegalQueryType.ILLEGAL_VALUE);
                }
                if (!refVal.getNameSpace().equals(this.query.getNameSpace())) {
                    throw new IllegalQueryException("__key__ filter namespace is " + refVal.getNameSpace() + " but query namespace is " + this.query.getNameSpace(), IllegalQueryType.ILLEGAL_VALUE);
                }
            }
            if (INEQUALITY_OPERATORS.contains(filter.getOpEnum())) {
                if (ineqProp == null) {
                    ineqProp = propName;
                    continue;
                }
                if (ineqProp.equals(propName)) continue;
                throw new IllegalQueryException(String.format("Only one inequality filter per query is supported.  Encountered both %s and %s", ineqProp, propName), IllegalQueryType.MULTIPLE_INEQ_FILTERS);
            }
            if (filter.getOpEnum() == DatastorePb.Query.Filter.Operator.EQUAL) {
                if (projectionProperties.contains(propName)) {
                    throw new IllegalQueryException("cannot use projection on a property with an equality filter", IllegalQueryType.ILLEGAL_PROJECTION);
                }
                if (!groupBySet.contains(propName)) continue;
                throw new IllegalQueryException("cannot use group by on a property with an equality filter", IllegalQueryType.ILLEGAL_GROUPBY);
            }
            if (filter.getOpEnum() == DatastorePb.Query.Filter.Operator.CONTAINED_IN_REGION) {
                isGeo = true;
                if (!filter.hasGeoRegion() || prop.getValue().hasPointValue()) {
                    throw new IllegalQueryException(String.format("Geo-spatial filter on %s should specify GeoRegion rather than Property Value", propName), IllegalQueryType.UNSUPPORTED_FILTER);
                }
                DatastorePb.GeoRegion region = filter.getGeoRegion();
                if ((!region.hasCircle() || !region.hasRectangle()) && (region.hasCircle() || region.hasRectangle())) continue;
                throw new IllegalQueryException(String.format("Geo-spatial filter on %s should specify Circle or Rectangle, but not both", propName), IllegalQueryType.UNSUPPORTED_FILTER);
            }
            if (!UNSUPPORTED_OPERATORS.contains(filter.getOpEnum())) continue;
            throw new IllegalQueryException(String.format("Unsupported filter operator: %s", filter.getOp()), IllegalQueryType.UNSUPPORTED_FILTER);
        }
        if (isGeo) {
            if (ineqProp != null) {
                throw new IllegalQueryException("Inequality filter with geo-spatial query is not supported.", IllegalQueryType.UNSUPPORTED_FILTER);
            }
            if (this.query.hasAncestor()) {
                throw new IllegalQueryException("Geo-spatial filter on ancestor query is not supported.", IllegalQueryType.UNSUPPORTED_FILTER);
            }
            if (this.query.hasCompiledCursor() || this.query.hasEndCompiledCursor()) {
                throw new IllegalQueryException("Start and end cursors are not supported on geo-spatial queries.", IllegalQueryType.CURSOR_NOT_SUPPORTED);
            }
        }
        if (ineqProp != null && this.query.groupByPropertyNameSize() > 0 && !groupBySet.contains(ineqProp)) {
            throw new IllegalQueryException(String.format("Inequality filter on %s must also be a group by property when group by properties are set.", ineqProp), IllegalQueryType.ILLEGAL_GROUPBY);
        }
        if (ineqProp != null && this.query.orderSize() > 0 && !ineqProp.equals(this.query.getOrder(0).getProperty())) {
            throw new IllegalQueryException(String.format("The first sort property must be the same as the property to which the inequality filter is applied.  In your query the first sort property is %s but the inequality filter is on %s", this.query.getOrder(0).getProperty(), ineqProp), IllegalQueryType.FIRST_SORT_NEQ_INEQ_PROP);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ValidatedQuery that = (ValidatedQuery)o;
        return this.query.equals(that.query);
    }

    public int hashCode() {
        return this.query.hashCode();
    }

    static class IllegalQueryException
    extends ApiProxy.ApplicationException {
        private final IllegalQueryType illegalQueryType;

        IllegalQueryException(String errorDetail, IllegalQueryType illegalQueryType) {
            super(DatastorePb.Error.ErrorCode.BAD_REQUEST.getValue(), errorDetail);
            this.illegalQueryType = illegalQueryType;
        }

        IllegalQueryType getIllegalQueryType() {
            return this.illegalQueryType;
        }
    }

    static enum IllegalQueryType {
        KIND_REQUIRED,
        UNSUPPORTED_FILTER,
        FILTER_WITH_MULTIPLE_PROPS,
        MULTIPLE_INEQ_FILTERS,
        FIRST_SORT_NEQ_INEQ_PROP,
        TRANSACTION_REQUIRES_ANCESTOR,
        ILLEGAL_VALUE,
        ILLEGAL_PROJECTION,
        ILLEGAL_GROUPBY,
        CURSOR_NOT_SUPPORTED;

    }
}

