/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.util.concurrent;

import com.google.appengine.repackaged.com.google.common.annotations.GwtCompatible;
import com.google.appengine.repackaged.com.google.common.annotations.GwtIncompatible;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.util.concurrent.AbstractFuture;
import com.google.appengine.repackaged.com.google.common.util.concurrent.InterruptibleTask;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.RunnableFuture;
import javax.annotation.Nullable;

@GwtCompatible
class TrustedListenableFutureTask<V>
extends AbstractFuture.TrustedFuture<V>
implements RunnableFuture<V> {
    private TrutestedFutureInterruptibleTask task;

    static <V> TrustedListenableFutureTask<V> create(Callable<V> callable) {
        return new TrustedListenableFutureTask<V>(callable);
    }

    static <V> TrustedListenableFutureTask<V> create(Runnable runnable, @Nullable V result) {
        return new TrustedListenableFutureTask<V>(Executors.callable(runnable, result));
    }

    TrustedListenableFutureTask(Callable<V> callable) {
        this.task = new TrutestedFutureInterruptibleTask(callable);
    }

    @Override
    public void run() {
        TrutestedFutureInterruptibleTask localTask = this.task;
        if (localTask != null) {
            localTask.run();
        }
    }

    @Override
    void done() {
        super.done();
        this.task = null;
    }

    @Override
    @GwtIncompatible(value="Interruption not supported")
    protected final void interruptTask() {
        TrutestedFutureInterruptibleTask localTask = this.task;
        if (localTask != null) {
            localTask.interruptTask();
        }
    }

    void doRun(Callable<V> localTask) throws Exception {
        this.set(localTask.call());
    }

    final class TrutestedFutureInterruptibleTask
    extends InterruptibleTask {
        private final Callable<V> callable;

        TrutestedFutureInterruptibleTask(Callable<V> callable) {
            this.callable = Preconditions.checkNotNull(callable);
        }

        @Override
        void runInterruptibly() {
            if (!TrustedListenableFutureTask.this.isDone()) {
                try {
                    TrustedListenableFutureTask.this.doRun(this.callable);
                }
                catch (Throwable t) {
                    TrustedListenableFutureTask.this.setException(t);
                }
            }
        }

        @Override
        boolean wasInterrupted() {
            return TrustedListenableFutureTask.this.wasInterrupted();
        }
    }
}

