/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.datastore.v1beta3.client;

import com.google.appengine.repackaged.com.google.datastore.v1beta3.AllocateIdsRequest;
import com.google.appengine.repackaged.com.google.datastore.v1beta3.AllocateIdsResponse;
import com.google.appengine.repackaged.com.google.datastore.v1beta3.BeginTransactionRequest;
import com.google.appengine.repackaged.com.google.datastore.v1beta3.BeginTransactionResponse;
import com.google.appengine.repackaged.com.google.datastore.v1beta3.CommitRequest;
import com.google.appengine.repackaged.com.google.datastore.v1beta3.CommitResponse;
import com.google.appengine.repackaged.com.google.datastore.v1beta3.LookupRequest;
import com.google.appengine.repackaged.com.google.datastore.v1beta3.LookupResponse;
import com.google.appengine.repackaged.com.google.datastore.v1beta3.RollbackRequest;
import com.google.appengine.repackaged.com.google.datastore.v1beta3.RollbackResponse;
import com.google.appengine.repackaged.com.google.datastore.v1beta3.RunQueryRequest;
import com.google.appengine.repackaged.com.google.datastore.v1beta3.RunQueryResponse;
import com.google.appengine.repackaged.com.google.datastore.v1beta3.client.DatastoreException;
import com.google.appengine.repackaged.com.google.datastore.v1beta3.client.RemoteRpc;
import java.io.IOException;

public class Datastore {
    final RemoteRpc remoteRpc;

    Datastore(RemoteRpc remoteRpc) {
        this.remoteRpc = remoteRpc;
    }

    public void resetRpcCount() {
        this.remoteRpc.resetRpcCount();
    }

    public int getRpcCount() {
        return this.remoteRpc.getRpcCount();
    }

    private DatastoreException invalidResponseException(String method, IOException exception) {
        return RemoteRpc.makeException(this.remoteRpc.getUrl(), method, 503, "Invalid response", exception);
    }

    public AllocateIdsResponse allocateIds(AllocateIdsRequest request) throws DatastoreException {
        try {
            return AllocateIdsResponse.parseFrom(this.remoteRpc.call("allocateIds", request));
        }
        catch (IOException exception) {
            throw this.invalidResponseException("allocateIds", exception);
        }
    }

    public BeginTransactionResponse beginTransaction(BeginTransactionRequest request) throws DatastoreException {
        try {
            return BeginTransactionResponse.parseFrom(this.remoteRpc.call("beginTransaction", request));
        }
        catch (IOException exception) {
            throw this.invalidResponseException("beginTransaction", exception);
        }
    }

    public CommitResponse commit(CommitRequest request) throws DatastoreException {
        try {
            return CommitResponse.parseFrom(this.remoteRpc.call("commit", request));
        }
        catch (IOException exception) {
            throw this.invalidResponseException("commit", exception);
        }
    }

    public LookupResponse lookup(LookupRequest request) throws DatastoreException {
        try {
            return LookupResponse.parseFrom(this.remoteRpc.call("lookup", request));
        }
        catch (IOException exception) {
            throw this.invalidResponseException("lookup", exception);
        }
    }

    public RollbackResponse rollback(RollbackRequest request) throws DatastoreException {
        try {
            return RollbackResponse.parseFrom(this.remoteRpc.call("rollback", request));
        }
        catch (IOException exception) {
            throw this.invalidResponseException("rollback", exception);
        }
    }

    public RunQueryResponse runQuery(RunQueryRequest request) throws DatastoreException {
        try {
            return RunQueryResponse.parseFrom(this.remoteRpc.call("runQuery", request));
        }
        catch (IOException exception) {
            throw this.invalidResponseException("runQuery", exception);
        }
    }
}

