/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.org.joda.time;

import com.google.appengine.repackaged.org.joda.time.Chronology;
import com.google.appengine.repackaged.org.joda.time.DateTimeUtils;
import com.google.appengine.repackaged.org.joda.time.Instant;
import com.google.appengine.repackaged.org.joda.time.JodaTimePermission;
import com.google.appengine.repackaged.org.joda.time.LocalDateTime;
import com.google.appengine.repackaged.org.joda.time.ReadableInstant;
import com.google.appengine.repackaged.org.joda.time.chrono.BaseChronology;
import com.google.appengine.repackaged.org.joda.time.field.FieldUtils;
import com.google.appengine.repackaged.org.joda.time.format.DateTimeFormat;
import com.google.appengine.repackaged.org.joda.time.format.DateTimeFormatter;
import com.google.appengine.repackaged.org.joda.time.format.DateTimeFormatterBuilder;
import com.google.appengine.repackaged.org.joda.time.format.FormatUtils;
import com.google.appengine.repackaged.org.joda.time.tz.DefaultNameProvider;
import com.google.appengine.repackaged.org.joda.time.tz.FixedDateTimeZone;
import com.google.appengine.repackaged.org.joda.time.tz.NameProvider;
import com.google.appengine.repackaged.org.joda.time.tz.Provider;
import com.google.appengine.repackaged.org.joda.time.tz.UTCProvider;
import com.google.appengine.repackaged.org.joda.time.tz.ZoneInfoProvider;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.joda.convert.FromString;
import org.joda.convert.ToString;

public abstract class DateTimeZone
implements Serializable {
    private static final long serialVersionUID = 5546345482340108586L;
    public static final DateTimeZone UTC = new FixedDateTimeZone("UTC", "UTC", 0, 0);
    private static Provider cProvider;
    private static NameProvider cNameProvider;
    private static Set<String> cAvailableIDs;
    private static volatile DateTimeZone cDefault;
    private static DateTimeFormatter cOffsetFormatter;
    private static Map<String, SoftReference<DateTimeZone>> iFixedOffsetCache;
    private static Map<String, String> cZoneIdConversion;
    private final String iID;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DateTimeZone getDefault() {
        DateTimeZone zone = cDefault;
        if (zone != null) return zone;
        Class<DateTimeZone> clazz = DateTimeZone.class;
        synchronized (DateTimeZone.class) {
            zone = cDefault;
            if (zone != null) return zone;
            DateTimeZone temp = null;
            try {
                try {
                    String id = System.getProperty("user.timezone");
                    if (id != null) {
                        temp = DateTimeZone.forID(id);
                    }
                }
                catch (RuntimeException ex) {
                    // empty catch block
                }
                if (temp == null) {
                    temp = DateTimeZone.forTimeZone(TimeZone.getDefault());
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (temp == null) {
                temp = UTC;
            }
            cDefault = zone = temp;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return zone;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDefault(DateTimeZone zone) throws SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new JodaTimePermission("DateTimeZone.setDefault"));
        }
        if (zone == null) {
            throw new IllegalArgumentException("The datetime zone must not be null");
        }
        Class<DateTimeZone> clazz = DateTimeZone.class;
        synchronized (DateTimeZone.class) {
            cDefault = zone;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    @FromString
    public static DateTimeZone forID(String id) {
        if (id == null) {
            return DateTimeZone.getDefault();
        }
        if (id.equals("UTC")) {
            return UTC;
        }
        DateTimeZone zone = cProvider.getZone(id);
        if (zone != null) {
            return zone;
        }
        if (id.startsWith("+") || id.startsWith("-")) {
            int offset = DateTimeZone.parseOffset(id);
            if ((long)offset == 0L) {
                return UTC;
            }
            id = DateTimeZone.printOffset(offset);
            return DateTimeZone.fixedOffsetZone(id, offset);
        }
        String string = id;
        throw new IllegalArgumentException(new StringBuilder(41 + String.valueOf(string).length()).append("The datetime zone id '").append(string).append("' is not recognised").toString());
    }

    public static DateTimeZone forOffsetHours(int hoursOffset) throws IllegalArgumentException {
        return DateTimeZone.forOffsetHoursMinutes(hoursOffset, 0);
    }

    public static DateTimeZone forOffsetHoursMinutes(int hoursOffset, int minutesOffset) throws IllegalArgumentException {
        if (hoursOffset == 0 && minutesOffset == 0) {
            return UTC;
        }
        if (minutesOffset < 0 || minutesOffset > 59) {
            int n = minutesOffset;
            throw new IllegalArgumentException(new StringBuilder(33).append("Minutes out of range: ").append(n).toString());
        }
        int offset = 0;
        try {
            int hoursInMinutes = FieldUtils.safeMultiply(hoursOffset, 60);
            minutesOffset = hoursInMinutes < 0 ? FieldUtils.safeAdd(hoursInMinutes, -minutesOffset) : FieldUtils.safeAdd(hoursInMinutes, minutesOffset);
            offset = FieldUtils.safeMultiply(minutesOffset, 60000);
        }
        catch (ArithmeticException ex) {
            throw new IllegalArgumentException("Offset is too large");
        }
        return DateTimeZone.forOffsetMillis(offset);
    }

    public static DateTimeZone forOffsetMillis(int millisOffset) {
        String id = DateTimeZone.printOffset(millisOffset);
        return DateTimeZone.fixedOffsetZone(id, millisOffset);
    }

    public static DateTimeZone forTimeZone(TimeZone zone) {
        if (zone == null) {
            return DateTimeZone.getDefault();
        }
        String id = zone.getID();
        if (id.equals("UTC")) {
            return UTC;
        }
        DateTimeZone dtz = null;
        String convId = DateTimeZone.getConvertedId(id);
        if (convId != null) {
            dtz = cProvider.getZone(convId);
        }
        if (dtz == null) {
            dtz = cProvider.getZone(id);
        }
        if (dtz != null) {
            return dtz;
        }
        if (convId == null && ((convId = zone.getID()).startsWith("GMT+") || convId.startsWith("GMT-"))) {
            int offset = DateTimeZone.parseOffset(convId = convId.substring(3));
            if ((long)offset == 0L) {
                return UTC;
            }
            convId = DateTimeZone.printOffset(offset);
            return DateTimeZone.fixedOffsetZone(convId, offset);
        }
        throw new IllegalArgumentException(new StringBuilder(41 + String.valueOf(id).length()).append("The datetime zone id '").append(id).append("' is not recognised").toString());
    }

    private static synchronized DateTimeZone fixedOffsetZone(String id, int offset) {
        DateTimeZone zone;
        Reference ref;
        if (offset == 0) {
            return UTC;
        }
        if (iFixedOffsetCache == null) {
            iFixedOffsetCache = new HashMap<String, SoftReference<DateTimeZone>>();
        }
        if ((ref = (Reference)iFixedOffsetCache.get(id)) != null && (zone = (DateTimeZone)ref.get()) != null) {
            return zone;
        }
        zone = new FixedDateTimeZone(id, null, offset, offset);
        iFixedOffsetCache.put(id, new SoftReference<DateTimeZone>(zone));
        return zone;
    }

    public static Set<String> getAvailableIDs() {
        return cAvailableIDs;
    }

    public static Provider getProvider() {
        return cProvider;
    }

    public static void setProvider(Provider provider) throws SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new JodaTimePermission("DateTimeZone.setProvider"));
        }
        DateTimeZone.setProvider0(provider);
    }

    private static void setProvider0(Provider provider) {
        Set<String> ids;
        if (provider == null) {
            provider = DateTimeZone.getDefaultProvider();
        }
        if ((ids = provider.getAvailableIDs()) == null || ids.size() == 0) {
            throw new IllegalArgumentException("The provider doesn't have any available ids");
        }
        if (!ids.contains("UTC")) {
            throw new IllegalArgumentException("The provider doesn't support UTC");
        }
        if (!UTC.equals(provider.getZone("UTC"))) {
            throw new IllegalArgumentException("Invalid UTC zone provided");
        }
        cProvider = provider;
        cAvailableIDs = ids;
    }

    private static Provider getDefaultProvider() {
        Provider provider = null;
        try {
            String providerClass = System.getProperty("com.google.appengine.repackaged.org.joda.time.DateTimeZone.Provider");
            if (providerClass != null) {
                try {
                    provider = (Provider)Class.forName(providerClass).newInstance();
                }
                catch (Exception ex) {
                    Thread thread = Thread.currentThread();
                    thread.getThreadGroup().uncaughtException(thread, ex);
                }
            }
        }
        catch (SecurityException ex) {
            // empty catch block
        }
        if (provider == null) {
            try {
                provider = new ZoneInfoProvider("com/google/appengine/repackaged/org/joda/time/tz/data");
            }
            catch (Exception ex) {
                Thread thread = Thread.currentThread();
                thread.getThreadGroup().uncaughtException(thread, ex);
            }
        }
        if (provider == null) {
            provider = new UTCProvider();
        }
        return provider;
    }

    public static NameProvider getNameProvider() {
        return cNameProvider;
    }

    public static void setNameProvider(NameProvider nameProvider) throws SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new JodaTimePermission("DateTimeZone.setNameProvider"));
        }
        DateTimeZone.setNameProvider0(nameProvider);
    }

    private static void setNameProvider0(NameProvider nameProvider) {
        if (nameProvider == null) {
            nameProvider = DateTimeZone.getDefaultNameProvider();
        }
        cNameProvider = nameProvider;
    }

    private static NameProvider getDefaultNameProvider() {
        NameProvider nameProvider = null;
        try {
            String providerClass = System.getProperty("com.google.appengine.repackaged.org.joda.time.DateTimeZone.NameProvider");
            if (providerClass != null) {
                try {
                    nameProvider = (NameProvider)Class.forName(providerClass).newInstance();
                }
                catch (Exception ex) {
                    Thread thread = Thread.currentThread();
                    thread.getThreadGroup().uncaughtException(thread, ex);
                }
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (nameProvider == null) {
            nameProvider = new DefaultNameProvider();
        }
        return nameProvider;
    }

    private static synchronized String getConvertedId(String id) {
        Map<String, String> map = cZoneIdConversion;
        if (map == null) {
            map = new HashMap<String, String>();
            map.put("GMT", "UTC");
            map.put("WET", "WET");
            map.put("CET", "CET");
            map.put("MET", "CET");
            map.put("ECT", "CET");
            map.put("EET", "EET");
            map.put("MIT", "Pacific/Apia");
            map.put("HST", "Pacific/Honolulu");
            map.put("AST", "America/Anchorage");
            map.put("PST", "America/Los_Angeles");
            map.put("MST", "America/Denver");
            map.put("PNT", "America/Phoenix");
            map.put("CST", "America/Chicago");
            map.put("EST", "America/New_York");
            map.put("IET", "America/Indiana/Indianapolis");
            map.put("PRT", "America/Puerto_Rico");
            map.put("CNT", "America/St_Johns");
            map.put("AGT", "America/Argentina/Buenos_Aires");
            map.put("BET", "America/Sao_Paulo");
            map.put("ART", "Africa/Cairo");
            map.put("CAT", "Africa/Harare");
            map.put("EAT", "Africa/Addis_Ababa");
            map.put("NET", "Asia/Yerevan");
            map.put("PLT", "Asia/Karachi");
            map.put("IST", "Asia/Kolkata");
            map.put("BST", "Asia/Dhaka");
            map.put("VST", "Asia/Ho_Chi_Minh");
            map.put("CTT", "Asia/Shanghai");
            map.put("JST", "Asia/Tokyo");
            map.put("ACT", "Australia/Darwin");
            map.put("AET", "Australia/Sydney");
            map.put("SST", "Pacific/Guadalcanal");
            map.put("NST", "Pacific/Auckland");
            cZoneIdConversion = map;
        }
        return map.get(id);
    }

    private static int parseOffset(String str) {
        BaseChronology chrono = new BaseChronology(){

            @Override
            public DateTimeZone getZone() {
                return null;
            }

            @Override
            public Chronology withUTC() {
                return this;
            }

            @Override
            public Chronology withZone(DateTimeZone zone) {
                return this;
            }

            @Override
            public String toString() {
                return this.getClass().getName();
            }
        };
        return -((int)DateTimeZone.offsetFormatter().withChronology(chrono).parseMillis(str));
    }

    private static String printOffset(int offset) {
        StringBuffer buf = new StringBuffer();
        if (offset >= 0) {
            buf.append('+');
        } else {
            buf.append('-');
            offset = -offset;
        }
        int hours = offset / 3600000;
        FormatUtils.appendPaddedInteger(buf, hours, 2);
        int minutes = (offset -= hours * 3600000) / 60000;
        buf.append(':');
        FormatUtils.appendPaddedInteger(buf, minutes, 2);
        if ((offset -= minutes * 60000) == 0) {
            return buf.toString();
        }
        int seconds = offset / 1000;
        buf.append(':');
        FormatUtils.appendPaddedInteger(buf, seconds, 2);
        if ((offset -= seconds * 1000) == 0) {
            return buf.toString();
        }
        buf.append('.');
        FormatUtils.appendPaddedInteger(buf, offset, 3);
        return buf.toString();
    }

    private static synchronized DateTimeFormatter offsetFormatter() {
        if (cOffsetFormatter == null) {
            cOffsetFormatter = new DateTimeFormatterBuilder().appendTimeZoneOffset(null, true, 2, 4).toFormatter();
        }
        return cOffsetFormatter;
    }

    protected DateTimeZone(String id) {
        if (id == null) {
            throw new IllegalArgumentException("Id must not be null");
        }
        this.iID = id;
    }

    @ToString
    public final String getID() {
        return this.iID;
    }

    public abstract String getNameKey(long var1);

    public final String getShortName(long instant) {
        return this.getShortName(instant, null);
    }

    public String getShortName(long instant, Locale locale) {
        String nameKey;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if ((nameKey = this.getNameKey(instant)) == null) {
            return this.iID;
        }
        String name = cNameProvider.getShortName(locale, this.iID, nameKey);
        if (name != null) {
            return name;
        }
        return DateTimeZone.printOffset(this.getOffset(instant));
    }

    public final String getName(long instant) {
        return this.getName(instant, null);
    }

    public String getName(long instant, Locale locale) {
        String nameKey;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if ((nameKey = this.getNameKey(instant)) == null) {
            return this.iID;
        }
        String name = cNameProvider.getName(locale, this.iID, nameKey);
        if (name != null) {
            return name;
        }
        return DateTimeZone.printOffset(this.getOffset(instant));
    }

    public abstract int getOffset(long var1);

    public final int getOffset(ReadableInstant instant) {
        if (instant == null) {
            return this.getOffset(DateTimeUtils.currentTimeMillis());
        }
        return this.getOffset(instant.getMillis());
    }

    public abstract int getStandardOffset(long var1);

    public boolean isStandardOffset(long instant) {
        return this.getOffset(instant) == this.getStandardOffset(instant);
    }

    public int getOffsetFromLocal(long instantLocal) {
        int offsetPrev;
        int diff;
        long prev;
        long instantAdjusted;
        int offsetAdjusted;
        int offsetLocal = this.getOffset(instantLocal);
        if (offsetLocal != (offsetAdjusted = this.getOffset(instantAdjusted = instantLocal - (long)offsetLocal))) {
            long nextAdjusted;
            long nextLocal;
            if (offsetLocal - offsetAdjusted < 0 && (nextLocal = this.nextTransition(instantAdjusted)) != (nextAdjusted = this.nextTransition(instantLocal - (long)offsetAdjusted))) {
                return offsetLocal;
            }
        } else if (offsetLocal >= 0 && (prev = this.previousTransition(instantAdjusted)) < instantAdjusted && instantAdjusted - prev <= (long)(diff = (offsetPrev = this.getOffset(prev)) - offsetLocal)) {
            return offsetPrev;
        }
        return offsetAdjusted;
    }

    public long convertUTCToLocal(long instantUTC) {
        int offset = this.getOffset(instantUTC);
        long instantLocal = instantUTC + (long)offset;
        if ((instantUTC ^ instantLocal) < 0L && (instantUTC ^ (long)offset) >= 0L) {
            throw new ArithmeticException("Adding time zone offset caused overflow");
        }
        return instantLocal;
    }

    public long convertLocalToUTC(long instantLocal, boolean strict, long originalInstantUTC) {
        int offsetOriginal = this.getOffset(originalInstantUTC);
        long instantUTC = instantLocal - (long)offsetOriginal;
        int offsetLocalFromOriginal = this.getOffset(instantUTC);
        if (offsetLocalFromOriginal == offsetOriginal) {
            return instantUTC;
        }
        return this.convertLocalToUTC(instantLocal, strict);
    }

    public long convertLocalToUTC(long instantLocal, boolean strict) {
        long instantUTC;
        int offset;
        int offsetLocal = this.getOffset(instantLocal);
        if (offsetLocal != (offset = this.getOffset(instantLocal - (long)offsetLocal)) && (strict || offsetLocal < 0)) {
            long nextAdjusted;
            long nextLocal = this.nextTransition(instantLocal - (long)offsetLocal);
            if (nextLocal == instantLocal - (long)offsetLocal) {
                nextLocal = Long.MAX_VALUE;
            }
            if ((nextAdjusted = this.nextTransition(instantLocal - (long)offset)) == instantLocal - (long)offset) {
                nextAdjusted = Long.MAX_VALUE;
            }
            if (nextLocal != nextAdjusted) {
                if (strict) {
                    String string = DateTimeFormat.forPattern("yyyy-MM-dd'T'HH:mm:ss.SSS").print(new Instant(instantLocal));
                    String string2 = this.getID();
                    throw new IllegalArgumentException(new StringBuilder(55 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Illegal instant due to time zone offset transition: ").append(string).append(" (").append(string2).append(")").toString());
                }
                offset = offsetLocal;
            }
        }
        if ((instantLocal ^ (instantUTC = instantLocal - (long)offset)) < 0L && (instantLocal ^ (long)offset) < 0L) {
            throw new ArithmeticException("Subtracting time zone offset caused overflow");
        }
        return instantUTC;
    }

    public long getMillisKeepLocal(DateTimeZone newZone, long oldInstant) {
        if (newZone == null) {
            newZone = DateTimeZone.getDefault();
        }
        if (newZone == this) {
            return oldInstant;
        }
        long instantLocal = this.convertUTCToLocal(oldInstant);
        return newZone.convertLocalToUTC(instantLocal, false, oldInstant);
    }

    public boolean isLocalDateTimeGap(LocalDateTime localDateTime) {
        if (this.isFixed()) {
            return false;
        }
        try {
            localDateTime.toDateTime(this);
            return false;
        }
        catch (IllegalArgumentException ex) {
            return true;
        }
    }

    public long adjustOffset(long instant, boolean earlierOrLater) {
        long offsetAfter;
        long instantBefore = instant - 10800000L;
        long instantAfter = instant + 10800000L;
        long offsetBefore = this.getOffset(instantBefore);
        if (offsetBefore <= (offsetAfter = (long)this.getOffset(instantAfter))) {
            return instant;
        }
        long diff = offsetBefore - offsetAfter;
        long transition = this.nextTransition(instantBefore);
        long overlapStart = transition - diff;
        long overlapEnd = transition + diff;
        if (instant < overlapStart || instant >= overlapEnd) {
            return instant;
        }
        long afterStart = instant - overlapStart;
        if (afterStart >= diff) {
            return earlierOrLater ? instant : instant - diff;
        }
        return earlierOrLater ? instant + diff : instant;
    }

    public abstract boolean isFixed();

    public abstract long nextTransition(long var1);

    public abstract long previousTransition(long var1);

    public TimeZone toTimeZone() {
        return TimeZone.getTimeZone(this.iID);
    }

    public abstract boolean equals(Object var1);

    public int hashCode() {
        return 57 + this.getID().hashCode();
    }

    public String toString() {
        return this.getID();
    }

    protected Object writeReplace() throws ObjectStreamException {
        return new Stub(this.iID);
    }

    static {
        DateTimeZone.setProvider0(null);
        DateTimeZone.setNameProvider0(null);
    }

    private static final class Stub
    implements Serializable {
        private static final long serialVersionUID = -6471952376487863581L;
        private transient String iID;

        Stub(String id) {
            this.iID = id;
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.writeUTF(this.iID);
        }

        private void readObject(ObjectInputStream in) throws IOException {
            this.iID = in.readUTF();
        }

        private Object readResolve() throws ObjectStreamException {
            return DateTimeZone.forID(this.iID);
        }
    }
}

