/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.org.joda.time.chrono;

import com.google.appengine.repackaged.org.joda.time.Chronology;
import com.google.appengine.repackaged.org.joda.time.DateTimeFieldType;
import com.google.appengine.repackaged.org.joda.time.DateTimeZone;
import com.google.appengine.repackaged.org.joda.time.chrono.AssembledChronology;
import com.google.appengine.repackaged.org.joda.time.chrono.GregorianChronology;
import com.google.appengine.repackaged.org.joda.time.chrono.ISOYearOfEraDateTimeField;
import com.google.appengine.repackaged.org.joda.time.chrono.ZonedChronology;
import com.google.appengine.repackaged.org.joda.time.field.DividedDateTimeField;
import com.google.appengine.repackaged.org.joda.time.field.RemainderDateTimeField;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public final class ISOChronology
extends AssembledChronology {
    private static final long serialVersionUID = -6212696554273812441L;
    private static final ISOChronology INSTANCE_UTC;
    private static final int FAST_CACHE_SIZE = 64;
    private static final ISOChronology[] cFastCache;
    private static final Map<DateTimeZone, ISOChronology> cCache;

    public static ISOChronology getInstanceUTC() {
        return INSTANCE_UTC;
    }

    public static ISOChronology getInstance() {
        return ISOChronology.getInstance(DateTimeZone.getDefault());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ISOChronology getInstance(DateTimeZone zone) {
        int index;
        ISOChronology chrono;
        if (zone == null) {
            zone = DateTimeZone.getDefault();
        }
        if ((chrono = cFastCache[index = System.identityHashCode(zone) & 0x3F]) != null && chrono.getZone() == zone) {
            return chrono;
        }
        Map<DateTimeZone, ISOChronology> map = cCache;
        synchronized (map) {
            chrono = cCache.get(zone);
            if (chrono == null) {
                chrono = new ISOChronology(ZonedChronology.getInstance(INSTANCE_UTC, zone));
                cCache.put(zone, chrono);
            }
        }
        ISOChronology.cFastCache[index] = chrono;
        return chrono;
    }

    private ISOChronology(Chronology base) {
        super(base, null);
    }

    @Override
    public Chronology withUTC() {
        return INSTANCE_UTC;
    }

    @Override
    public Chronology withZone(DateTimeZone zone) {
        if (zone == null) {
            zone = DateTimeZone.getDefault();
        }
        if (zone == this.getZone()) {
            return this;
        }
        return ISOChronology.getInstance(zone);
    }

    @Override
    public String toString() {
        String str = "ISOChronology";
        DateTimeZone zone = this.getZone();
        if (zone != null) {
            String string = str;
            String string2 = zone.getID();
            str = new StringBuilder(2 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("[").append(string2).append("]").toString();
        }
        return str;
    }

    @Override
    protected void assemble(AssembledChronology.Fields fields) {
        if (this.getBase().getZone() == DateTimeZone.UTC) {
            fields.centuryOfEra = new DividedDateTimeField(ISOYearOfEraDateTimeField.INSTANCE, DateTimeFieldType.centuryOfEra(), 100);
            fields.yearOfCentury = new RemainderDateTimeField((DividedDateTimeField)fields.centuryOfEra, DateTimeFieldType.yearOfCentury());
            fields.weekyearOfCentury = new RemainderDateTimeField((DividedDateTimeField)fields.centuryOfEra, DateTimeFieldType.weekyearOfCentury());
            fields.centuries = fields.centuryOfEra.getDurationField();
        }
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public int hashCode() {
        return "ISO".hashCode() * 11 + this.getZone().hashCode();
    }

    private Object writeReplace() {
        return new Stub(this.getZone());
    }

    static {
        cCache = new HashMap<DateTimeZone, ISOChronology>();
        cFastCache = new ISOChronology[64];
        INSTANCE_UTC = new ISOChronology(GregorianChronology.getInstanceUTC());
        cCache.put(DateTimeZone.UTC, INSTANCE_UTC);
    }

    private static final class Stub
    implements Serializable {
        private static final long serialVersionUID = -6212696554273812441L;
        private transient DateTimeZone iZone;

        Stub(DateTimeZone zone) {
            this.iZone = zone;
        }

        private Object readResolve() {
            return ISOChronology.getInstance(this.iZone);
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.writeObject(this.iZone);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            this.iZone = (DateTimeZone)in.readObject();
        }
    }
}

