/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.client.datastoreservice.app;

import com.google.appengine.repackaged.com.google.common.base.Function;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableMap;
import com.google.appengine.repackaged.com.google.protobuf.MessageLite;
import com.google.apphosting.client.datastoreservice.app.AllocateIdsHandler;
import com.google.apphosting.client.datastoreservice.app.BeginTransactionHandler;
import com.google.apphosting.client.datastoreservice.app.BlindWriteHandler;
import com.google.apphosting.client.datastoreservice.app.CommitHandler;
import com.google.apphosting.client.datastoreservice.app.DatastoreV4Client;
import com.google.apphosting.client.datastoreservice.app.EntityTranslator;
import com.google.apphosting.client.datastoreservice.app.EntityV4Normalizer;
import com.google.apphosting.client.datastoreservice.app.InternDatastoreRpcService;
import com.google.apphosting.client.datastoreservice.app.LookupHandler;
import com.google.apphosting.client.datastoreservice.app.RollbackHandler;
import com.google.apphosting.client.datastoreservice.app.RunQueryHandler;
import com.google.apphosting.client.serviceapp.Clock;
import com.google.apphosting.client.serviceapp.RpcHandler;
import com.google.apphosting.client.serviceapp.RpcService;
import com.google.apphosting.client.serviceapp.ServiceRegistry;
import com.google.apphosting.datastore.DatastoreV4;
import com.google.apphosting.datastore.EntityV4;
import java.util.Map;

public class CloudDatastoreLegacyRpcService
implements RpcService {
    private static final int MAX_KEYS_PER_BATCH = 500;
    private final DatastoreV4Client datastoreClient;
    private final EntityV4Normalizer entityNormalizer;
    private static final Map<EntityTranslator.Format, Function<DatastoreV4.EntityResult, DatastoreV4.EntityResult>> resultTransforms;

    public CloudDatastoreLegacyRpcService(String defaultDatasetId, InternDatastoreRpcService internService, Clock clock) {
        this.entityNormalizer = new EntityV4Normalizer(EntityTranslator.DEFAULT, DatastoreV4Client.INTERNAL_FORMAT, defaultDatasetId);
        this.datastoreClient = new DatastoreV4Client(internService, clock);
    }

    AllocateIdsHandler newAllocateIdsHandler(int maxKeysPerBatch) {
        return new AllocateIdsHandler(this.datastoreClient, this.entityNormalizer, maxKeysPerBatch);
    }

    BeginTransactionHandler newBeginTransactionHandler() {
        return new BeginTransactionHandler(this.datastoreClient);
    }

    CommitHandler newCommitHandler(EntityTranslator.Format inputFormat) {
        return new CommitHandler(this.datastoreClient, this.entityNormalizer, inputFormat);
    }

    RollbackHandler newRollbackHandler() {
        return new RollbackHandler(this.datastoreClient);
    }

    LookupHandler newLookupHandler(EntityTranslator.Format outputFormat) {
        return new LookupHandler(this.datastoreClient, this.entityNormalizer, resultTransforms.get((Object)outputFormat));
    }

    RunQueryHandler newRunQueryHandler(EntityTranslator.Format outputFormat) {
        return new RunQueryHandler(this.datastoreClient, this.entityNormalizer, resultTransforms.get((Object)outputFormat));
    }

    @Override
    public void registerService(ServiceRegistry registry) {
        AllocateIdsHandler allocateIdsHandler = this.newAllocateIdsHandler(500);
        BeginTransactionHandler beginTransactionHandler = this.newBeginTransactionHandler();
        RollbackHandler rollbackHandler = this.newRollbackHandler();
        for (Version version : ImmutableList.of(Version.V1BETA1, Version.V1BETA2)) {
            this.registerHandler(registry, version, "allocateIds", allocateIdsHandler);
            this.registerHandler(registry, version, "beginTransaction", beginTransactionHandler);
            CommitHandler commitHandler = this.newCommitHandler(version.format);
            this.registerHandler(registry, version, "commit", commitHandler);
            this.registerHandler(registry, version, "rollback", rollbackHandler);
            this.registerHandler(registry, version, "lookup", this.newLookupHandler(version.format));
            this.registerHandler(registry, version, "runQuery", this.newRunQueryHandler(version.format));
            if (version != Version.V1BETA1) continue;
            this.registerHandler(registry, version, "blindWrite", new BlindWriteHandler(commitHandler));
        }
    }

    private <R extends MessageLite, S extends MessageLite> void registerHandler(ServiceRegistry registry, Version version, String methodName, RpcHandler<R, S> handler) {
        registry.registerHandler("datastore", version.name, methodName, handler);
    }

    static Function<DatastoreV4.EntityResult, DatastoreV4.EntityResult> newResultTransform(final EntityTranslator.Format format) {
        return new Function<DatastoreV4.EntityResult, DatastoreV4.EntityResult>(){

            @Override
            public DatastoreV4.EntityResult apply(DatastoreV4.EntityResult input) {
                EntityV4.Entity entity = format.convert(input.getEntity());
                return DatastoreV4.EntityResult.newBuilder().setEntity(entity).build();
            }
        };
    }

    static {
        ImmutableMap.Builder<EntityTranslator.Format, Function<DatastoreV4.EntityResult, DatastoreV4.EntityResult>> b = ImmutableMap.builder();
        for (EntityTranslator.Format format : EntityTranslator.Format.values()) {
            b.put(format, CloudDatastoreLegacyRpcService.newResultTransform(format));
        }
        resultTransforms = b.build();
    }

    private static enum Version {
        V1BETA1("v1beta1", EntityTranslator.Format.V1BETA1),
        V1BETA2("v1beta2", EntityTranslator.Format.V1BETA2);

        String name;
        EntityTranslator.Format format;

        private Version(String name, EntityTranslator.Format format) {
            this.name = name;
            this.format = format;
        }
    }
}

