/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.client.datastoreservice.app.mobile;

import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.repackaged.com.google.common.base.Function;
import com.google.appengine.repackaged.com.google.common.base.Predicates;
import com.google.appengine.repackaged.com.google.net.util.error.Codes;
import com.google.appengine.repackaged.com.google.protobuf.InvalidProtocolBufferException;
import com.google.appengine.repackaged.com.google.protobuf.MessageLite;
import com.google.appengine.repackaged.com.google.protobuf.Parser;
import com.google.appengine.repackaged.com.google.protos.gdata.proto2api.Core;
import com.google.apphosting.client.datastoreservice.app.EntityTranslator;
import com.google.apphosting.client.datastoreservice.app.mobile.DatastoreMobileClient;
import com.google.apphosting.client.datastoreservice.app.mobile.DatastoreMobileRpcHandler;
import com.google.apphosting.client.datastoreservice.app.mobile.DatastoreMobileValidator;
import com.google.apphosting.client.datastoreservice.app.mobile.MobileEntityV4Normalizer;
import com.google.apphosting.client.datastoreservice.app.mobile.MobileV4NormAuthenticator;
import com.google.apphosting.client.datastoreservice.mobile.DatastoreMobileService;
import com.google.apphosting.client.datastoreservice.proto.DatastoreService;
import com.google.apphosting.client.serviceapp.RpcException;
import com.google.apphosting.client.serviceapp.RpcHandler;
import com.google.apphosting.datastore.DatastoreV4;

class RunQueryHandler
extends DatastoreMobileRpcHandler<DatastoreMobileService.RunQueryRequest, DatastoreMobileService.RunQueryResponse> {
    private final Function<DatastoreV4.EntityResult, DatastoreV4.EntityResult> resultTransform;
    private final MobileV4NormAuthenticator normAuthenticator;
    private final DatastoreMobileValidator validator;

    public RunQueryHandler(DatastoreMobileClient datastoreMobileClient, MobileEntityV4Normalizer entityNormalizer, Function<DatastoreV4.EntityResult, DatastoreV4.EntityResult> resultTransform, DatastoreMobileValidator validator, EntityTranslator.Format inputFormat) {
        super(datastoreMobileClient);
        this.resultTransform = resultTransform;
        this.normAuthenticator = new MobileV4NormAuthenticator(entityNormalizer, inputFormat);
        this.validator = validator;
    }

    @Override
    public DatastoreMobileService.RunQueryResponse call(RpcHandler.CallOptions options, DatastoreMobileService.RunQueryRequest req) throws RpcException {
        this.validator.validateQueryRequest(req);
        DatastoreV4.RunQueryRequest normV4Query = this.normAuthenticator.normalizeAndAuthenticateRunQueryRequest(req);
        return ((DatastoreMobileClient)this.datastoreClient).runQuery(options, this.resultTransform, normV4Query, Predicates.alwaysTrue()).getQueryResponse();
    }

    @Override
    public Parser<DatastoreMobileService.RunQueryRequest> getParser() {
        return DatastoreMobileService.RunQueryRequest.PARSER;
    }

    @Override
    public Class<DatastoreMobileService.RunQueryRequest> getRequestClass() {
        return DatastoreMobileService.RunQueryRequest.class;
    }

    @Override
    public DatastoreMobileService.RunQueryResponse makeError(Codes.Code errorCode, String message) {
        Core.ErrorProto.Builder error = Core.ErrorProto.newBuilder().setDomain("util.error.Code").setExternalErrorMessage(message).setCode(errorCode.toString());
        return DatastoreMobileService.RunQueryResponse.newBuilder().setHeader(DatastoreMobileService.ResponseHeader.newBuilder().setErrors(Core.Errors.newBuilder().addError(error))).build();
    }

    public static DatastoreService.RunQueryRequest toDatastoreServiceRunQueryRequest(DatastoreMobileService.RunQueryRequest req) {
        DatastoreService.RunQueryRequest.Builder dsReq = DatastoreService.RunQueryRequest.newBuilder();
        if (req.hasPartitionId()) {
            dsReq.setPartitionId(req.getPartitionId());
        }
        if (req.hasQuery()) {
            dsReq.setQuery(req.getQuery());
        }
        if (req.hasReadOptions()) {
            dsReq.setReadOptions(req.getReadOptions());
        }
        if (req.hasGqlQuery()) {
            dsReq.setGqlQuery(req.getGqlQuery());
        }
        return dsReq.build();
    }

    @Override
    public RpcHandler.RequestPermissions getRequiredPermissions(DatastoreMobileService.RunQueryRequest request) {
        return RpcHandler.RequestPermissions.READ;
    }

    @Override
    @VisibleForTesting(productionVisibility=VisibleForTesting.Visibility.NONE)
    public DatastoreMobileService.RunQueryRequest deserializeWithHeader(byte[] body, DatastoreMobileService.RequestHeader hdr) throws InvalidProtocolBufferException {
        return this.getParser().parseFrom(body).toBuilder().setHeader(hdr).build();
    }

    @Override
    public MessageLite getRequestHeader(DatastoreMobileService.RunQueryRequest request) {
        return request.getHeader();
    }
}

