/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.client.searchservice.app;

import com.google.appengine.api.oauth.OAuthServiceFactory;
import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.repackaged.com.google.protobuf.MessageLite;
import com.google.apphosting.client.searchservice.app.CloudSearchRpcService;
import com.google.apphosting.client.serviceapp.AuthService;
import com.google.apphosting.client.serviceapp.AuthServiceImpl;
import com.google.apphosting.client.serviceapp.BaseApiServlet;
import com.google.apphosting.client.serviceapp.Clock;
import java.io.IOException;
import javax.servlet.http.HttpServletResponse;

public final class CloudSearchApiServlet
extends BaseApiServlet {
    @VisibleForTesting
    static final String[] OAUTH2_SCOPE_STRINGS = new String[]{"https://www.googleapis.com/auth/cloudsearch", "https://www.googleapis.com/auth/cloudsearch.readonly", "https://www.googleapis.com/auth/cloud-platform"};
    @VisibleForTesting
    static final String[] OAUTH2_SCOPE_CODES = new String[]{"47300", "47301", "35600"};
    @VisibleForTesting
    static final String API_HEADER = "X-AppEngine-Search-API";

    public CloudSearchApiServlet() {
        this(new AuthServiceImpl(OAuthServiceFactory.getOAuthService()));
    }

    @VisibleForTesting
    CloudSearchApiServlet(AuthService authService) {
        super(authService, Clock.SYSTEM_CLOCK, new CloudSearchRpcService());
    }

    @VisibleForTesting
    CloudSearchApiServlet(CloudSearchRpcService service, AuthService authService) {
        super(authService, Clock.SYSTEM_CLOCK, service);
    }

    @Override
    protected String getApiHeader() {
        return API_HEADER;
    }

    @Override
    protected String[] getOAuthScopeStrings() {
        return OAUTH2_SCOPE_STRINGS;
    }

    @Override
    protected String[] getOAuthScopeCodes() {
        return OAUTH2_SCOPE_CODES;
    }

    @Override
    protected void writeErrorResponseProto(MessageLite errorProtoResponse, HttpServletResponse httpResponse) throws IOException {
        this.writeResponseProto(errorProtoResponse, httpResponse);
        httpResponse.setStatus(500);
    }
}

