/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.client.searchservice.app;

import com.google.appengine.api.search.Document;
import com.google.appengine.api.search.Field;
import com.google.appengine.api.search.GeoPoint;
import com.google.appengine.api.search.Index;
import com.google.appengine.api.search.IndexSpec;
import com.google.appengine.api.search.SearchServiceFactory;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.io.BaseEncoding;
import com.google.appengine.repackaged.com.google.net.util.error.Codes;
import com.google.appengine.repackaged.com.google.protobuf.Timestamp;
import com.google.apphosting.client.serviceapp.RpcException;
import com.google.cloudsearch.v1.Document;
import com.google.cloudsearch.v1.FieldValue;
import com.google.cloudsearch.v1.FieldValueList;
import java.util.Map;

class InternalSearchApiUtils {
    private static final int NANOS_PER_MILLISECOND = 1000000;

    private InternalSearchApiUtils() {
    }

    static byte[] decodeBytes(String message) {
        return BaseEncoding.base64Url().omitPadding().decode(message);
    }

    static String encodeBytes(byte[] messageBytes) {
        return BaseEncoding.base64Url().omitPadding().encode(messageBytes);
    }

    static Index getIndex(String indexId) {
        IndexSpec indexSpec = IndexSpec.newBuilder().setName(indexId).build();
        return SearchServiceFactory.getSearchService().getIndex(indexSpec);
    }

    static void setIndexedDocument(Document.Builder docBuilder, Document dexterDocument) throws RpcException {
        docBuilder.setDocId(dexterDocument.getId());
        docBuilder.setRank(dexterDocument.getRank());
        Map<String, FieldValueList> fieldBuilder = docBuilder.getMutableFields();
        for (String fieldName : dexterDocument.getFieldNames()) {
            FieldValueList.Builder fieldValueListBuilder = FieldValueList.newBuilder();
            for (Field field : dexterDocument.getFields(fieldName)) {
                InternalSearchApiUtils.addDocumentField(fieldValueListBuilder, field, fieldName);
            }
            fieldBuilder.put(fieldName, fieldValueListBuilder.build());
        }
    }

    static void addDocumentField(FieldValueList.Builder fieldValueListBuilder, Field field, String fieldName) throws RpcException {
        FieldValue.Builder fieldValueBuilder = fieldValueListBuilder.addValuesBuilder();
        if (field.getLocale() != null) {
            fieldValueBuilder.setLang(field.getLocale().getLanguage());
        }
        switch (field.getType()) {
            case ATOM: {
                fieldValueBuilder.setStringValue(field.getAtom());
                fieldValueBuilder.setStringFormat(FieldValue.StringFormat.ATOM);
                break;
            }
            case DATE: {
                fieldValueBuilder.setTimestampValue(InternalSearchApiUtils.fromMillisecondsSinceEpoch(field.getDate().getTime()));
                break;
            }
            case GEO_POINT: {
                GeoPoint geoPoint = field.getGeoPoint();
                String string = String.valueOf(String.valueOf(geoPoint.getLatitude()));
                String string2 = String.valueOf(String.valueOf(geoPoint.getLongitude()));
                fieldValueBuilder.setGeoValue(new StringBuilder(2 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(", ").append(string2).toString());
                break;
            }
            case HTML: {
                fieldValueBuilder.setStringValue(field.getHTML());
                fieldValueBuilder.setStringFormat(FieldValue.StringFormat.HTML);
                break;
            }
            case NUMBER: {
                fieldValueBuilder.setNumberValue(field.getNumber());
                break;
            }
            case TEXT: {
                fieldValueBuilder.setStringValue(field.getText());
                fieldValueBuilder.setStringFormat(FieldValue.StringFormat.TEXT);
                break;
            }
            default: {
                String string = String.valueOf((Object)field.getType());
                throw new RpcException(Codes.Code.INTERNAL, new StringBuilder(57 + String.valueOf(string).length() + String.valueOf(fieldName).length()).append("unrecognized internal Document Field Type: ").append(string).append(", Field Name: ").append(fieldName).toString());
            }
        }
    }

    static Timestamp fromMillisecondsSinceEpoch(long milliseconds) {
        Preconditions.checkArgument(milliseconds >= 0L, "timestamp should be positive.");
        return Timestamp.newBuilder().setSeconds(milliseconds / 1000L).setNanos((int)(milliseconds % 1000L) * 1000000).build();
    }

    static long toMillisecondsSinceEpoch(Timestamp timestamp) {
        return timestamp.getSeconds() * 1000L + (long)(timestamp.getNanos() / 1000000);
    }
}

