/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.client.searchservice.app;

import com.google.appengine.api.search.Field;
import com.google.appengine.api.search.GetException;
import com.google.appengine.api.search.GetIndexesRequest;
import com.google.appengine.api.search.GetResponse;
import com.google.appengine.api.search.Index;
import com.google.appengine.api.search.OperationResult;
import com.google.appengine.api.search.Schema;
import com.google.appengine.api.search.SearchService;
import com.google.appengine.api.search.SearchServiceFactory;
import com.google.appengine.repackaged.com.google.common.base.MoreObjects;
import com.google.appengine.repackaged.com.google.common.base.Strings;
import com.google.appengine.repackaged.com.google.net.util.error.Codes;
import com.google.appengine.repackaged.com.google.protobuf.InvalidProtocolBufferException;
import com.google.appengine.repackaged.com.google.protobuf.Parser;
import com.google.apphosting.client.searchservice.app.CloudSearchRpcHandler;
import com.google.apphosting.client.searchservice.app.InternalSearchApiUtils;
import com.google.apphosting.client.searchservice.proto.CursorInternal;
import com.google.apphosting.client.serviceapp.RpcException;
import com.google.apphosting.client.serviceapp.RpcHandler;
import com.google.cloudsearch.v1.FieldNames;
import com.google.cloudsearch.v1.IndexInfo;
import com.google.cloudsearch.v1.ListIndexesRequest;
import com.google.cloudsearch.v1.ListIndexesResponse;
import java.util.Iterator;

class ListIndexesRpcHandler
extends CloudSearchRpcHandler<ListIndexesRequest, ListIndexesResponse> {
    private static final int DEFAULT_LISTINDEXES_PAGE_SIZE = 100;

    ListIndexesRpcHandler() {
    }

    @Override
    public ListIndexesResponse call(RpcHandler.CallOptions options, ListIndexesRequest req) throws RpcException {
        ListIndexesResponse.Builder respBuilder = ListIndexesResponse.newBuilder();
        SearchService searchService = SearchServiceFactory.getSearchService();
        try {
            GetIndexesRequest getRequest = this.createGetIndexesRequestFromProto(req);
            GetResponse<Index> listIndexResponse = searchService.getIndexes(getRequest);
            if (listIndexResponse == null) {
                String string = String.valueOf(getRequest.toString());
                throw new RpcException(Codes.Code.INTERNAL, string.length() != 0 ? "getIndexes returned null with request: ".concat(string) : new String("getIndexes returned null with request: "));
            }
            Index lastIndex = null;
            Iterator<Index> iterator = listIndexResponse.getResults().iterator();
            while (iterator.hasNext()) {
                Index index;
                lastIndex = index = iterator.next();
                ListIndexesRpcHandler.addIndexInfo(respBuilder.addIndexesBuilder(), index, req.getProjectId());
            }
            if (lastIndex != null) {
                this.setCursor(respBuilder, lastIndex.getName());
            }
        }
        catch (IllegalArgumentException e) {
            throw new RpcException(Codes.Code.INVALID_ARGUMENT, e.getMessage());
        }
        catch (GetException e) {
            OperationResult opResult = e.getOperationResult();
            throw new RpcException(ListIndexesRpcHandler.fromInternalCode(opResult.getCode()), MoreObjects.firstNonNull(opResult.getMessage(), ""));
        }
        return respBuilder.build();
    }

    private GetIndexesRequest createGetIndexesRequestFromProto(ListIndexesRequest req) throws RpcException {
        GetIndexesRequest.Builder getRequestBuilder = GetIndexesRequest.newBuilder();
        if (!Strings.isNullOrEmpty(req.getIndexNamePrefix())) {
            getRequestBuilder.setIndexNamePrefix(req.getIndexNamePrefix());
        }
        getRequestBuilder.setLimit(req.getPageSize() == 0 ? 100 : req.getPageSize());
        getRequestBuilder.setSchemaFetched(req.getView() == ListIndexesRequest.IndexInfoView.FULL);
        if (!Strings.isNullOrEmpty(req.getPageToken())) {
            getRequestBuilder.setIncludeStartIndex(false);
            this.setStartIndexName(getRequestBuilder, req.getPageToken());
        }
        return getRequestBuilder.build();
    }

    private void setCursor(ListIndexesResponse.Builder respBuilder, String indexName) {
        CursorInternal.ListIndexesCursor.Builder cursorBuilder = CursorInternal.ListIndexesCursor.newBuilder();
        cursorBuilder.setCursor(indexName);
        String encodedCursor = InternalSearchApiUtils.encodeBytes(cursorBuilder.build().toByteArray());
        respBuilder.setNextPageToken(encodedCursor);
    }

    private void setStartIndexName(GetIndexesRequest.Builder getRequestBuilder, String encodedCursor) throws RpcException {
        byte[] decodedCursor = InternalSearchApiUtils.decodeBytes(encodedCursor);
        CursorInternal.ListIndexesCursor.Builder cursorBuilder = CursorInternal.ListIndexesCursor.newBuilder();
        try {
            cursorBuilder.mergeFrom(decodedCursor);
            CursorInternal.ListIndexesCursor cursor = cursorBuilder.build();
            getRequestBuilder.setStartIndexName(cursor.getCursor());
        }
        catch (InvalidProtocolBufferException e2) {
            throw new RpcException(Codes.Code.INVALID_ARGUMENT, "Invalid ListIndexesCursor");
        }
    }

    public static void addIndexInfo(IndexInfo.Builder indexInfoBuilder, Index index, String projectId) throws RpcException {
        indexInfoBuilder.setProjectId(projectId);
        indexInfoBuilder.setIndexId(index.getName());
        Schema schema = index.getSchema();
        if (schema == null) {
            return;
        }
        FieldNames.Builder indexedFieldNamesBuilder = indexInfoBuilder.getIndexedFieldBuilder();
        for (String fieldName : schema.getFieldNames()) {
            for (Field.FieldType fieldType : schema.getFieldTypes(fieldName)) {
                ListIndexesRpcHandler.addFieldType(indexedFieldNamesBuilder, fieldType, fieldName);
            }
        }
    }

    public static void addFieldType(FieldNames.Builder indexedFieldNamesBuilder, Field.FieldType fieldType, String fieldName) throws RpcException {
        switch (fieldType) {
            case ATOM: {
                indexedFieldNamesBuilder.addAtomFields(fieldName);
                break;
            }
            case DATE: {
                indexedFieldNamesBuilder.addDateFields(fieldName);
                break;
            }
            case GEO_POINT: {
                indexedFieldNamesBuilder.addGeoFields(fieldName);
                break;
            }
            case HTML: {
                indexedFieldNamesBuilder.addHtmlFields(fieldName);
                break;
            }
            case NUMBER: {
                indexedFieldNamesBuilder.addNumberFields(fieldName);
                break;
            }
            case TEXT: {
                indexedFieldNamesBuilder.addTextFields(fieldName);
                break;
            }
            default: {
                String string = String.valueOf((Object)fieldType);
                throw new RpcException(Codes.Code.INTERNAL, new StringBuilder(65 + String.valueOf(string).length() + String.valueOf(fieldName).length()).append("unrecognized internal Scored Document Field Type ").append(string).append(" for fieldName: ").append(fieldName).toString());
            }
        }
    }

    @Override
    public Parser<ListIndexesRequest> getParser() {
        return ListIndexesRequest.PARSER;
    }

    @Override
    public Class<ListIndexesRequest> getRequestClass() {
        return ListIndexesRequest.class;
    }

    @Override
    public RpcHandler.RequestPermissions getRequiredPermissions(ListIndexesRequest request) {
        return RpcHandler.RequestPermissions.READ;
    }
}

