/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.client.serviceapp;

import com.google.appengine.api.oauth.OAuthRequestException;
import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.repackaged.com.google.net.util.error.Codes;
import com.google.appengine.repackaged.com.google.protobuf.MessageLite;
import com.google.appengine.repackaged.com.google.protobuf.Parser;
import com.google.appengine.repackaged.org.joda.time.Instant;
import com.google.apphosting.client.serviceapp.AuthService;
import com.google.apphosting.client.serviceapp.Clock;
import com.google.apphosting.client.serviceapp.RpcException;
import com.google.apphosting.client.serviceapp.RpcHandler;
import com.google.apphosting.client.serviceapp.RpcService;
import com.google.apphosting.client.serviceapp.ServiceRegistry;
import com.google.apphosting.client.serviceapp.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class BaseApiServlet
extends HttpServlet
implements ServiceRegistry {
    private static final Logger logger = Logger.getLogger(BaseApiServlet.class.getName());
    private static final Pattern URI_PATTERN = Pattern.compile("/([^/]*/[^/]*/[^/]*)");
    private static final Pattern APIARY_URI_PATTERN = Pattern.compile("/([^/]*/[^/]*)/(?:datasets|projects)/([^/]*)(/[^/]*)");
    private static final String PROTOBUF_CONTENT_TYPE = "application/x-protobuf";
    public static final String DEADLINE_HEADER = "X-Datastore-Deadline";
    private final Map<String, RpcHandler<?, ?>> rpcHandlerMap = new HashMap();
    protected final AuthService authService;
    private final Clock clock;

    protected BaseApiServlet(AuthService authService, Clock clock, RpcService ... services) {
        this.authService = authService;
        this.clock = clock;
        for (RpcService service : services) {
            service.registerService(this);
        }
    }

    @Override
    public <R extends MessageLite, S extends MessageLite> void registerHandler(String service, String version, String method, RpcHandler<R, S> handler) {
        String uri = String.format("%s/%s/%s", service, version, method);
        if (!Utils.isDevelopmentEnvironment()) {
            uri = uri.toLowerCase();
        }
        this.rpcHandlerMap.put(uri, handler);
    }

    protected void doGet(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        logger.fine("ApiServlet GET");
        try {
            RpcHandler<?, ?> rpcHandler = this.getHandler(httpRequest.getRequestURI());
            try {
                this.authenticate(RpcHandler.RequestPermissions.READ, null);
                BaseApiServlet.writeTextResponse(httpResponse, 200, "Valid RPC");
            }
            catch (RpcException e) {
                this.writeErrorResponse(rpcHandler, httpRequest, httpResponse, e.getErrorCode(), e.getMessage());
            }
        }
        catch (IOException e) {
            logger.log(Level.INFO, e.getMessage());
            BaseApiServlet.writeTextResponse(httpResponse, 400, e.getMessage());
        }
    }

    public void doPost(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        RpcHandler<?, ?> rpcHandler;
        logger.fine("ApiServlet POST");
        try {
            rpcHandler = this.getHandler(httpRequest.getRequestURI());
        }
        catch (IOException e) {
            logger.log(Level.INFO, e.getMessage());
            BaseApiServlet.writeTextResponse(httpResponse, 400, e.getMessage());
            return;
        }
        this.authenticateAndDoCall(rpcHandler, httpRequest, httpResponse);
    }

    public <R extends MessageLite, S extends MessageLite> void authenticateAndDoCall(RpcHandler<R, S> rpcHandler, HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        S response;
        MessageLite requestHeader;
        R request;
        try {
            request = BaseApiServlet.readRequestProto(rpcHandler.getParser(), httpRequest);
            requestHeader = rpcHandler.getRequestHeader(request);
        }
        catch (IOException exception) {
            logger.log(Level.INFO, "Exception reading rpc request message.", exception);
            this.writeErrorResponse(rpcHandler, httpRequest, httpResponse, Codes.Code.INVALID_ARGUMENT, exception.getMessage());
            return;
        }
        try {
            this.authenticate(rpcHandler.getRequiredPermissions(request), requestHeader);
        }
        catch (RpcException e) {
            this.writeErrorResponse(rpcHandler, httpRequest, httpResponse, e.getErrorCode(), e.getMessage());
            return;
        }
        Double deadline = BaseApiServlet.getDeadlineFromHttpRequest(httpRequest);
        RpcHandler.CallOptions callOptions = this.createCallOptions(deadline);
        try {
            response = BaseApiServlet.call(rpcHandler, request, callOptions);
        }
        catch (RpcException exception) {
            logger.log(Level.INFO, "Exception executing rpc.", exception);
            this.writeErrorResponse(rpcHandler, httpRequest, httpResponse, exception.getErrorCode(), exception.getMessage());
            return;
        }
        catch (IOException exception) {
            logger.log(Level.INFO, "Exception executing rpc.", exception);
            this.writeErrorResponse(rpcHandler, httpRequest, httpResponse, Codes.Code.INVALID_ARGUMENT, exception.getMessage());
            return;
        }
        try {
            this.writeResponseProto((MessageLite)response, httpResponse);
        }
        catch (IOException exception) {
            logger.log(Level.INFO, "Exception sending rpc response message.", exception);
        }
    }

    private String getMethodSpec(String uri) throws IOException {
        Matcher uriMatcher;
        if (!Utils.isDevelopmentEnvironment() && (uriMatcher = URI_PATTERN.matcher(uri)).matches()) {
            return uriMatcher.group(1);
        }
        uriMatcher = APIARY_URI_PATTERN.matcher(uri);
        if (uriMatcher.matches()) {
            String requestedProjectId = uriMatcher.group(2);
            String hostedProjectId = Utils.getHostedProjectId();
            if (!hostedProjectId.equals(requestedProjectId)) {
                throw new IOException(String.format("Hosted project, %s, does not match requested project, %s.", hostedProjectId, requestedProjectId));
            }
            String string = String.valueOf(uriMatcher.group(1));
            String string2 = String.valueOf(uriMatcher.group(3));
            return string2.length() != 0 ? string.concat(string2) : new String(string);
        }
        String string = String.valueOf(uri);
        throw new IOException(string.length() != 0 ? "Malformed uri: ".concat(string) : new String("Malformed uri: "));
    }

    protected RpcHandler<?, ?> getHandler(String uri) throws IOException {
        RpcHandler<?, ?> rpcHandler;
        String methodSpec = this.getMethodSpec(uri);
        if (!Utils.isDevelopmentEnvironment()) {
            methodSpec = methodSpec.toLowerCase();
        }
        if ((rpcHandler = this.rpcHandlerMap.get(methodSpec)) == null) {
            String string = String.valueOf(methodSpec);
            throw new IOException(string.length() != 0 ? "unknown rpc: ".concat(string) : new String("unknown rpc: "));
        }
        return rpcHandler;
    }

    private static <R extends MessageLite, S extends MessageLite> S call(RpcHandler<R, S> rpcHandler, R request, RpcHandler.CallOptions callOptions) throws RpcException, IOException {
        return rpcHandler.call(callOptions, request);
    }

    @VisibleForTesting
    public RpcHandler.CallOptions createCallOptions(Double deadlineInSeconds) {
        RpcHandler.CallOptions callOptions;
        if (deadlineInSeconds != null) {
            Instant now = this.clock.now();
            Instant deadline = now.plus((long)(deadlineInSeconds * 1000.0));
            callOptions = new RpcHandler.CallOptions(0x1E00000, deadline);
        } else {
            callOptions = RpcHandler.CallOptions.DEFAULT;
        }
        return callOptions;
    }

    protected void authenticate(RpcHandler.RequestPermissions requiredPermissions, @Nullable MessageLite requestHeader) throws RpcException {
        boolean needWriterPermission = requiredPermissions == RpcHandler.RequestPermissions.READ_WRITE;
        AuthService.UserPermissions userPermissions = null;
        try {
            userPermissions = this.authService.getUserPermissions(this.getOAuthScopeCodes(), needWriterPermission);
        }
        catch (OAuthRequestException e) {
            try {
                userPermissions = this.authService.getUserPermissions(this.getOAuthScopeStrings(), needWriterPermission);
            }
            catch (OAuthRequestException oAuthRequestException) {
                // empty catch block
            }
        }
        if (userPermissions == null || !userPermissions.isAuthorized(needWriterPermission)) {
            String errorMessage = needWriterPermission && userPermissions != null && userPermissions.isAuthorized(false) ? "Your account has permission as a viewer but is attempting to perform a write operataion." : "Unauthorized.";
            throw new RpcException(Codes.Code.PERMISSION_DENIED, errorMessage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeResponseProto(MessageLite protoResponse, HttpServletResponse httpResponse) throws IOException {
        httpResponse.setStatus(200);
        httpResponse.setContentType(PROTOBUF_CONTENT_TYPE);
        try (ServletOutputStream outputStream = null;){
            outputStream = httpResponse.getOutputStream();
            protoResponse.writeTo((OutputStream)outputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <R extends MessageLite> R readRequestProto(Parser<R> parser, HttpServletRequest httpRequest) throws IOException {
        String contentType = httpRequest.getContentType();
        if (contentType != null && !contentType.equals(PROTOBUF_CONTENT_TYPE)) {
            String string = String.valueOf(contentType);
            throw new IOException(string.length() != 0 ? "unsupported content-type: ".concat(string) : new String("unsupported content-type: "));
        }
        ServletInputStream inputStream = null;
        try {
            MessageLite requestProto;
            inputStream = httpRequest.getInputStream();
            MessageLite messageLite = requestProto = (MessageLite)parser.parseFrom((InputStream)inputStream);
            return (R)messageLite;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException exception) {
                    logger.log(Level.INFO, "Exception at end of reading rpc request proto message.", exception);
                }
            }
        }
    }

    @VisibleForTesting
    public static Double getDeadlineFromHttpRequest(HttpServletRequest httpRequest) {
        Double deadlineValue;
        String deadlineString = httpRequest.getHeader(DEADLINE_HEADER);
        if (deadlineString == null) {
            return null;
        }
        try {
            deadlineValue = Double.parseDouble(deadlineString);
        }
        catch (Exception e) {
            deadlineValue = null;
            logger.log(Level.WARNING, "Deadline value not a number.");
        }
        return deadlineValue;
    }

    protected abstract String getApiHeader();

    protected abstract String[] getOAuthScopeStrings();

    protected abstract String[] getOAuthScopeCodes();

    private void writeErrorResponse(RpcHandler<?, ?> rpcHandler, HttpServletRequest httpRequest, HttpServletResponse httpResponse, Codes.Code code, String message) {
        String string = String.valueOf(code.toString());
        logger.log(Level.SEVERE, new StringBuilder(2 + String.valueOf(string).length() + String.valueOf(message).length()).append(string).append(": ").append(message).toString());
        if (httpRequest.getHeader(this.getApiHeader()) != null) {
            try {
                this.writeErrorResponseProto(rpcHandler.makeError(code, message), httpResponse);
            }
            catch (IOException exception) {
                logger.log(Level.INFO, "IO Exception sending rpc error proto message", exception);
            }
        } else {
            int httpErrorCode;
            switch (code) {
                case INVALID_ARGUMENT: {
                    httpErrorCode = 400;
                    break;
                }
                case PERMISSION_DENIED: {
                    httpErrorCode = 403;
                    break;
                }
                case RESOURCE_EXHAUSTED: {
                    httpErrorCode = 402;
                    break;
                }
                case FAILED_PRECONDITION: {
                    httpErrorCode = 412;
                    break;
                }
                case ABORTED: {
                    httpErrorCode = 409;
                    break;
                }
                case DEADLINE_EXCEEDED: {
                    httpErrorCode = 403;
                    break;
                }
                case UNAVAILABLE: {
                    httpErrorCode = 503;
                    break;
                }
                default: {
                    httpErrorCode = 500;
                }
            }
            String errorMessage = String.format("{\n  \"error\": {\n    \"errors\": [\n     {\n       \"domain\": \"global\",\n       \"reason\": \"%s\",\n       \"message\": \"%s\"\n     }\n    ],\n    \"code\": %d,\n    \"message\": \"%s\"\n  }\n}\n", code.toString(), message, httpErrorCode, message);
            BaseApiServlet.writeTextResponse(httpResponse, httpErrorCode, errorMessage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeTextResponse(HttpServletResponse httpResponse, int httpStatusCode, String message) {
        httpResponse.setStatus(httpStatusCode);
        httpResponse.setContentType("text/plain");
        try (ServletOutputStream outputStream = null;){
            outputStream = httpResponse.getOutputStream();
            outputStream.print(message);
        }
        catch (IOException exception) {
            logger.log(Level.INFO, "IO Exception sending error text", exception);
        }
    }

    protected void writeErrorResponseProto(MessageLite errorProtoResponse, HttpServletResponse httpResponse) throws IOException {
        this.writeResponseProto(errorProtoResponse, httpResponse);
    }
}

