/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.io.protocol;

import com.google.appengine.repackaged.com.google.common.collect.Lists;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolMessage;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolSupport;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.appengine.repackaged.com.google.protobuf.CodedInputStream;
import com.google.appengine.repackaged.com.google.protobuf.Descriptors;
import com.google.appengine.repackaged.com.google.protobuf.ExtensionRegistryLite;
import com.google.appengine.repackaged.com.google.protobuf.InvalidProtocolBufferException;
import com.google.appengine.repackaged.com.google.protobuf.Message;
import com.google.appengine.repackaged.com.google.protobuf.MutableMessage;
import com.google.appengine.repackaged.com.google.protobuf.UninitializedMessageException;
import com.google.appengine.repackaged.com.google.protobuf.UnknownFieldSet;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;

final class Proto2BuilderAdapter<T extends ProtocolMessage>
implements Message.Builder {
    private T proto;
    private static final String PARSING_ERROR = "Error parsing protocol message";

    Proto2BuilderAdapter(T proto) {
        this.proto = proto;
    }

    @Override
    public Message getDefaultInstanceForType() {
        return ((ProtocolMessage)this.proto).getDefaultInstanceForType();
    }

    @Override
    public Message.Builder clear() {
        ((ProtocolMessage)this.proto).clear();
        return this;
    }

    @Override
    public Message build() {
        if (!((ProtocolMessage)this.proto).isInitialized()) {
            throw new UninitializedMessageException(Lists.newArrayList(((ProtocolMessage)this.proto).findInitializationError()));
        }
        T result = this.proto;
        this.proto = null;
        return result;
    }

    @Override
    public Message buildPartial() {
        return this.proto;
    }

    @Override
    public Message.Builder clone() {
        return new Proto2BuilderAdapter<MutableMessage>(((ProtocolMessage)this.proto).clone());
    }

    @Override
    public boolean isInitialized() {
        return ((ProtocolMessage)this.proto).isInitialized();
    }

    @Override
    public Message.Builder mergeFrom(CodedInputStream input) throws IOException {
        if (!((ProtocolMessage)this.proto).mergeFrom(ProtocolSupport.readCodedInputToProtocolSource(input))) {
            throw new InvalidProtocolBufferException(PARSING_ERROR);
        }
        return this;
    }

    @Override
    public Message.Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return this.mergeFrom(input);
    }

    @Override
    public Message.Builder mergeFrom(ByteString data) throws InvalidProtocolBufferException {
        try {
            CodedInputStream input = data.newCodedInput();
            Message.Builder builder = this.mergeFrom(input);
            input.checkLastTagWas(0);
            return builder;
        }
        catch (InvalidProtocolBufferException ex) {
            throw ex;
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    public Message.Builder mergeFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return this.mergeFrom(data);
    }

    @Override
    public Message.Builder mergeFrom(byte[] data) throws InvalidProtocolBufferException {
        if (!((ProtocolMessage)this.proto).mergeFrom(data)) {
            throw new InvalidProtocolBufferException(PARSING_ERROR);
        }
        return this;
    }

    @Override
    public Message.Builder mergeFrom(byte[] data, int off, int len) throws InvalidProtocolBufferException {
        if (!((ProtocolMessage)this.proto).mergeFrom(data, off, len)) {
            throw new InvalidProtocolBufferException(PARSING_ERROR);
        }
        return this;
    }

    @Override
    public Message.Builder mergeFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return this.mergeFrom(data);
    }

    @Override
    public Message.Builder mergeFrom(byte[] data, int off, int len, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return this.mergeFrom(data, off, len);
    }

    @Override
    public Message.Builder mergeFrom(InputStream input) throws IOException {
        if (!((ProtocolMessage)this.proto).mergeFrom(input)) {
            throw new IOException(PARSING_ERROR);
        }
        return this;
    }

    @Override
    public Message.Builder mergeFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return this.mergeFrom(input);
    }

    @Override
    public boolean mergeDelimitedFrom(InputStream input) throws IOException {
        int firstByte = input.read();
        if (firstByte == -1) {
            return false;
        }
        int size = CodedInputStream.readRawVarint32(firstByte, input);
        if (size < 0) {
            throw new IOException("Negative message size read from stream: " + size);
        }
        byte[] bytes = new byte[size];
        int remaining = size;
        int off = 0;
        while (remaining > 0) {
            int bytesRead = input.read(bytes, off, remaining);
            if (bytesRead == -1) {
                throw new IOException("EOF reached unexpectedly at position " + off);
            }
            remaining -= bytesRead;
            off += bytesRead;
        }
        this.mergeFrom(bytes);
        return true;
    }

    @Override
    public boolean mergeDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return this.mergeDelimitedFrom(input);
    }

    @Override
    public List<String> findInitializationErrors() {
        throw new UnsupportedOperationException("not implemented for proto1");
    }

    @Override
    public String getInitializationErrorString() {
        throw new UnsupportedOperationException("not implemented for proto1");
    }

    @Override
    public Map<Descriptors.FieldDescriptor, Object> getAllFields() {
        throw new UnsupportedOperationException("not implemented for proto1");
    }

    @Override
    public boolean hasField(Descriptors.FieldDescriptor field) {
        throw new UnsupportedOperationException("not implemented for proto1");
    }

    @Override
    public Object getField(Descriptors.FieldDescriptor field) {
        throw new UnsupportedOperationException("not implemented for proto1");
    }

    @Override
    public int getRepeatedFieldCount(Descriptors.FieldDescriptor field) {
        throw new UnsupportedOperationException("not implemented for proto1");
    }

    @Override
    public Object getRepeatedField(Descriptors.FieldDescriptor field, int index) {
        throw new UnsupportedOperationException("not implemented for proto1");
    }

    @Override
    public UnknownFieldSet getUnknownFields() {
        throw new UnsupportedOperationException("not implemented for proto1");
    }

    @Override
    public Message.Builder mergeFrom(Message other) {
        throw new UnsupportedOperationException("not implemented for proto1");
    }

    @Override
    public Descriptors.Descriptor getDescriptorForType() {
        throw new UnsupportedOperationException("not implemented for proto1");
    }

    @Override
    public Message.Builder newBuilderForField(Descriptors.FieldDescriptor field) {
        throw new UnsupportedOperationException("not implemented for proto1");
    }

    @Override
    public Message.Builder getFieldBuilder(Descriptors.FieldDescriptor field) {
        throw new UnsupportedOperationException("not implemented for proto1");
    }

    @Override
    public Message.Builder setField(Descriptors.FieldDescriptor field, Object value) {
        throw new UnsupportedOperationException("not implemented for proto1");
    }

    @Override
    public Message.Builder clearField(Descriptors.FieldDescriptor field) {
        throw new UnsupportedOperationException("not implemented for proto1");
    }

    @Override
    public Message.Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
        throw new UnsupportedOperationException("not implemented for proto1");
    }

    @Override
    public Message.Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
        throw new UnsupportedOperationException("not implemented for proto1");
    }

    @Override
    public Message.Builder setUnknownFields(UnknownFieldSet unknownFields) {
        throw new UnsupportedOperationException("not implemented for proto1");
    }

    @Override
    public Message.Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
        throw new UnsupportedOperationException("not implemented for proto1");
    }
}

