/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.channel;

import com.google.appengine.api.channel.ChannelPresence;
import com.google.appengine.api.utils.HttpRequestParser;
import java.io.IOException;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMultipart;
import javax.servlet.http.HttpServletRequest;

class ChannelPresenceParser
extends HttpRequestParser {
    ChannelPresenceParser() {
    }

    static ChannelPresence parsePresence(HttpServletRequest request) throws IOException {
        try {
            boolean isConnected;
            MimeMultipart multipart = ChannelPresenceParser.parseMultipartRequest(request);
            if (multipart == null) {
                throw new IllegalArgumentException("No arguments provided in request.");
            }
            if (request.getRequestURI().endsWith("/channel/connected/")) {
                isConnected = true;
            } else if (request.getRequestURI().endsWith("/channel/disconnected/")) {
                isConnected = false;
            } else {
                String string = String.valueOf(request.getRequestURI());
                throw new IllegalArgumentException(string.length() != 0 ? "Can't determine the type of channel presence from the path: ".concat(string) : new String("Can't determine the type of channel presence from the path: "));
            }
            int parts = multipart.getCount();
            for (int i = 0; i < parts; ++i) {
                BodyPart part = multipart.getBodyPart(i);
                if (!"from".equals(ChannelPresenceParser.getFieldName(part))) continue;
                return new ChannelPresence(isConnected, ChannelPresenceParser.getTextContent(part));
            }
            String string = String.valueOf(String.valueOf(multipart));
            throw new IllegalArgumentException(new StringBuilder(44 + string.length()).append("Can't determine clientId from request body: ").append(string).toString());
        }
        catch (MessagingException ex) {
            IOException ex2 = new IOException("Could not parse incoming request.");
            ex2.initCause(ex);
            throw ex2;
        }
    }
}

