/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.search;

import java.util.Iterator;
import java.util.LinkedList;

final class Util {
    static boolean equalObjects(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }

    static <T> T defaultIfNull(T value, T defaultValue) {
        return value == null ? defaultValue : value;
    }

    static <T> String iterableToString(Iterable<T> objects, int limit) {
        StringBuilder builder = new StringBuilder().append("[");
        String sep = "";
        int head = limit <= 0 ? Integer.MAX_VALUE : (limit + 1) / 2;
        int tail = limit <= 0 ? 0 : limit - head;
        Iterator<T> iter = objects.iterator();
        while (iter.hasNext() && --head >= 0) {
            builder.append(sep).append(iter.next());
            sep = ", ";
        }
        LinkedList<T> tailMembers = new LinkedList<T>();
        int seen = 0;
        while (iter.hasNext()) {
            tailMembers.add(iter.next());
            if (++seen <= tail) continue;
            tailMembers.removeFirst();
        }
        if (seen > tail) {
            builder.append(", ...");
        }
        for (Object o : tailMembers) {
            builder.append(sep).append(o);
            sep = ", ";
        }
        return builder.append("]").toString();
    }

    private Util() {
    }

    static class ToStringHelper {
        private final StringBuilder sb;
        private boolean first = true;
        private boolean done = false;

        ToStringHelper(String objectName) {
            this.sb = new StringBuilder(String.valueOf(objectName).concat("("));
        }

        ToStringHelper addField(String fieldName, Object value) {
            if (this.done) {
                throw new IllegalStateException();
            }
            if (value != null) {
                if (this.first) {
                    this.first = false;
                } else {
                    this.sb.append(", ");
                }
                this.sb.append(fieldName).append("=").append(value);
            }
            return this;
        }

        ToStringHelper addIterableField(String fieldName, Iterable<?> objects, int max) {
            if (this.done) {
                throw new IllegalStateException();
            }
            Iterator<?> iterator = objects.iterator();
            if (iterator.hasNext()) {
                if (this.first) {
                    this.first = false;
                } else {
                    this.sb.append(", ");
                }
                this.sb.append(fieldName).append("=").append(Util.iterableToString(objects, max));
            }
            return this;
        }

        ToStringHelper addIterableField(String fieldName, Iterable<?> objects) {
            return this.addIterableField(fieldName, objects, 0);
        }

        String finish() {
            this.done = true;
            this.sb.append(")");
            return this.sb.toString();
        }

        public String toString() {
            String string;
            if (this.done) {
                string = this.sb.toString();
            } else {
                String string2 = String.valueOf(String.valueOf(this.sb));
                string = new StringBuilder(1 + string2.length()).append(string2).append(")").toString();
            }
            return string;
        }
    }
}

