/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.search.checkers;

import com.google.appengine.api.search.checkers.FieldChecker;
import com.google.appengine.api.search.checkers.Preconditions;
import com.google.apphosting.api.AppEngineInternal;
import com.google.apphosting.api.search.DocumentPb;

@AppEngineInternal
public final class FacetChecker {
    public static String checkFacetName(String name) {
        return FacetChecker.checkFacetName(name, "facet name");
    }

    public static String checkFacetName(String name, String callerContext) {
        Preconditions.checkNotNull(name, "Name is null");
        return FieldChecker.checkFieldName(name, callerContext);
    }

    public static String checkAtom(String value) {
        Preconditions.checkNotNull(value, "Value is null");
        FieldChecker.checkAtom(value);
        Preconditions.checkArgument(!value.isEmpty(), "Value is empty");
        return value;
    }

    public static Double checkNumber(Double value) {
        return FieldChecker.checkNumber(value);
    }

    public static DocumentPb.FacetValue checkFacetValue(DocumentPb.FacetValue value) {
        if (value != null) {
            switch (value.getType()) {
                case ATOM: {
                    FacetChecker.checkAtom(value.getStringValue());
                    break;
                }
                case NUMBER: {
                    FacetChecker.checkNumber(Double.parseDouble(value.getStringValue()));
                    break;
                }
                default: {
                    String string = String.valueOf(String.valueOf(value.getType()));
                    throw new IllegalArgumentException(new StringBuilder(24 + string.length()).append("Unsupported facet type: ").append(string).toString());
                }
            }
        }
        return value;
    }

    public static DocumentPb.Facet checkValid(DocumentPb.Facet facet) {
        FacetChecker.checkFacetName(facet.getName());
        FacetChecker.checkFacetValue(facet.getValue());
        return facet;
    }

    private FacetChecker() {
    }
}

