/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.socket;

import com.google.appengine.api.socket.SocketApiHelper;
import com.google.appengine.api.socket.SocketServicePb;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.List;
import sun.net.spi.nameservice.NameService;

class NameServiceImpl
implements NameService {
    private static final byte[] LOCAL_HOST_ADDR = new byte[]{127, 0, 0, 1};
    private static final String LOCAL_HOST = "localhost";
    private final SocketApiHelper socketHelper;

    NameServiceImpl(SocketApiHelper socketHelper) {
        if (socketHelper == null) {
            throw new IllegalArgumentException("socketHelper must not be null.");
        }
        this.socketHelper = socketHelper;
    }

    SocketApiHelper getSocketApiHelper() {
        return this.socketHelper;
    }

    public InetAddress[] lookupAllHostAddr(String host) throws UnknownHostException {
        if (host.equals(LOCAL_HOST)) {
            InetAddress[] result = new InetAddress[]{InetAddress.getByAddress(host, LOCAL_HOST_ADDR)};
            return result;
        }
        SocketServicePb.ResolveRequest request = new SocketServicePb.ResolveRequest().setName(host);
        request.mutableAddressFamiliess().addAll(Arrays.asList(SocketServicePb.CreateSocketRequest.SocketFamily.IPv4.getValue(), SocketServicePb.CreateSocketRequest.SocketFamily.IPv6.getValue()));
        SocketServicePb.ResolveReply response = new SocketServicePb.ResolveReply();
        try {
            SocketServicePb.RemoteSocketServiceError serviceError = new SocketServicePb.RemoteSocketServiceError();
            if (!this.socketHelper.makeSyncCall("Resolve", request, response, serviceError)) {
                SocketServicePb.ResolveReply.ErrorCode errorCode = SocketServicePb.ResolveReply.ErrorCode.valueOf(serviceError.getSystemError());
                if (errorCode == null) {
                    String string = String.valueOf(String.valueOf(host));
                    String string2 = String.valueOf(String.valueOf(serviceError.toFlatString()));
                    throw new RuntimeException(new StringBuilder(24 + string.length() + string2.length()).append("Resolve failed: host:'").append(string).append("' ").append(string2).toString());
                }
                switch (SocketServicePb.ResolveReply.ErrorCode.valueOf(serviceError.getSystemError())) {
                    case SOCKET_EAI_NONAME: 
                    case SOCKET_EAI_AGAIN: {
                        throw new UnknownHostException(host);
                    }
                }
                String string = String.valueOf(String.valueOf(host));
                String string3 = String.valueOf(String.valueOf(serviceError.toFlatString()));
                throw new RuntimeException(new StringBuilder(24 + string.length() + string3.length()).append("Resolve failed: host:'").append(string).append("' ").append(string3).toString());
            }
        }
        catch (SocketException e) {
            String errorCode = String.valueOf(String.valueOf(host));
            String string = String.valueOf(String.valueOf(e));
            throw new RuntimeException(new StringBuilder(35 + errorCode.length() + string.length()).append("Resolve failed: Request=").append(errorCode).append(" Exception=").append(string).toString());
        }
        if (response.packedAddresssAsBytes().isEmpty()) {
            throw new UnknownHostException(host);
        }
        List<byte[]> addresses = response.packedAddresssAsBytes();
        InetAddress[] result = new InetAddress[addresses.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = InetAddress.getByAddress(host, addresses.get(i));
        }
        return result;
    }

    public String getHostByAddr(byte[] addr) throws UnknownHostException {
        if (Arrays.equals(LOCAL_HOST_ADDR, addr)) {
            return LOCAL_HOST;
        }
        if (addr.length == 4) {
            return NameServiceImpl.getHostAddrForPackedAddr(addr);
        }
        if (addr.length == 16) {
            return NameServiceImpl.getHostAddrForPackedAddr(addr);
        }
        throw new UnknownHostException(NameServiceImpl.getHostAddrForPackedAddr(addr));
    }

    static String getHostAddrForPackedAddr(byte[] addr) {
        StringBuilder builder = new StringBuilder();
        if (addr.length == 16) {
            String separator = "";
            for (int i = 0; i < 16; i += 2) {
                int val = ((addr[i] & 0xFF) << 8) + (addr[i + 1] & 0xFF);
                builder.append(separator);
                separator = ":";
                builder.append(Integer.toHexString(val));
            }
        } else {
            String separator = "";
            for (byte val : addr) {
                builder.append(separator);
                separator = ".";
                builder.append(val & 0xFF);
            }
        }
        return builder.toString();
    }
}

