/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.client.datastoreservice.app;

import com.google.appengine.repackaged.com.google.common.base.CaseFormat;
import com.google.appengine.repackaged.com.google.datastore.v1.AllocateIdsRequest;
import com.google.appengine.repackaged.com.google.datastore.v1.AllocateIdsResponse;
import com.google.appengine.repackaged.com.google.datastore.v1.BeginTransactionRequest;
import com.google.appengine.repackaged.com.google.datastore.v1.BeginTransactionResponse;
import com.google.appengine.repackaged.com.google.datastore.v1.CommitRequest;
import com.google.appengine.repackaged.com.google.datastore.v1.CommitResponse;
import com.google.appengine.repackaged.com.google.datastore.v1.Datastore;
import com.google.appengine.repackaged.com.google.datastore.v1.LookupRequest;
import com.google.appengine.repackaged.com.google.datastore.v1.LookupResponse;
import com.google.appengine.repackaged.com.google.datastore.v1.RollbackRequest;
import com.google.appengine.repackaged.com.google.datastore.v1.RollbackResponse;
import com.google.appengine.repackaged.com.google.datastore.v1.RunQueryRequest;
import com.google.appengine.repackaged.com.google.datastore.v1.RunQueryResponse;
import com.google.appengine.repackaged.com.google.protobuf.MessageLite;
import com.google.appengine.repackaged.com.google.protobuf.Parser;
import com.google.apphosting.client.datastoreservice.app.CloudDatastoreV1Beta3RpcHandler;
import com.google.apphosting.client.datastoreservice.app.InternDatastoreRpcService;
import com.google.apphosting.client.serviceapp.Clock;
import com.google.apphosting.client.serviceapp.RpcHandler;
import com.google.apphosting.client.serviceapp.RpcService;
import com.google.apphosting.client.serviceapp.ServiceRegistry;
import com.google.apphosting.client.serviceapp.Utils;

public class CloudDatastoreV1Beta3RpcService
implements RpcService {
    private static final String CLOUD_DATASTORE_V1_PKG = "cloud_datastore_v1";
    private static final InternDatastoreRpcService.RpcSpec<AllocateIdsResponse> ALLOCATE_IDS_RPC_SPEC = CloudDatastoreV1Beta3RpcService.createRpcSpec(Datastore.Method.AllocateIds, AllocateIdsResponse.PARSER);
    private static final InternDatastoreRpcService.RpcSpec<BeginTransactionResponse> BEGIN_TXN_RPC_SPEC = CloudDatastoreV1Beta3RpcService.createRpcSpec(Datastore.Method.BeginTransaction, BeginTransactionResponse.PARSER);
    private static final InternDatastoreRpcService.RpcSpec<CommitResponse> COMMIT_RPC_SPEC = CloudDatastoreV1Beta3RpcService.createRpcSpec(Datastore.Method.Commit, CommitResponse.PARSER);
    private static final InternDatastoreRpcService.RpcSpec<LookupResponse> LOOKUP_RPC_SPEC = CloudDatastoreV1Beta3RpcService.createRpcSpec(Datastore.Method.Lookup, LookupResponse.PARSER);
    private static final InternDatastoreRpcService.RpcSpec<RollbackResponse> ROLLBACK_RPC_SPEC = CloudDatastoreV1Beta3RpcService.createRpcSpec(Datastore.Method.Rollback, RollbackResponse.PARSER);
    private static final InternDatastoreRpcService.RpcSpec<RunQueryResponse> RUN_QUERY_RPC_SPEC = CloudDatastoreV1Beta3RpcService.createRpcSpec(Datastore.Method.RunQuery, RunQueryResponse.PARSER);
    private final InternDatastoreRpcService internService;
    private final Clock clock;

    private static <S extends MessageLite> InternDatastoreRpcService.RpcSpec<S> createRpcSpec(Datastore.Method method, Parser<S> responseParser) {
        return InternDatastoreRpcService.createRpcSpec(CLOUD_DATASTORE_V1_PKG, method.toString(), responseParser);
    }

    public CloudDatastoreV1Beta3RpcService(InternDatastoreRpcService internService, Clock clock) {
        this.internService = internService;
        this.clock = clock;
    }

    @Override
    public void registerService(ServiceRegistry registry) {
        if (!Utils.isDevelopmentEnvironment()) {
            return;
        }
        this.registerHandler(registry, Datastore.Method.AllocateIds, new SimpleRpcHandler<AllocateIdsRequest, AllocateIdsResponse>(ALLOCATE_IDS_RPC_SPEC, this.internService, AllocateIdsRequest.PARSER, AllocateIdsRequest.class, RpcHandler.RequestPermissions.READ_WRITE, this.clock){

            @Override
            protected AllocateIdsRequest populateProjectId(AllocateIdsRequest request) {
                AllocateIdsRequest.Builder builder = request.toBuilder();
                builder.setProjectId(Utils.getHostedProjectId());
                return builder.build();
            }
        });
        this.registerHandler(registry, Datastore.Method.BeginTransaction, new SimpleRpcHandler<BeginTransactionRequest, BeginTransactionResponse>(BEGIN_TXN_RPC_SPEC, this.internService, BeginTransactionRequest.PARSER, BeginTransactionRequest.class, RpcHandler.RequestPermissions.READ, this.clock){

            @Override
            protected BeginTransactionRequest populateProjectId(BeginTransactionRequest request) {
                BeginTransactionRequest.Builder builder = request.toBuilder();
                builder.setProjectId(Utils.getHostedProjectId());
                return builder.build();
            }
        });
        this.registerHandler(registry, Datastore.Method.Commit, new CommitHandler(this.internService, this.clock));
        this.registerHandler(registry, Datastore.Method.Lookup, new SimpleRpcHandler<LookupRequest, LookupResponse>(LOOKUP_RPC_SPEC, this.internService, LookupRequest.PARSER, LookupRequest.class, RpcHandler.RequestPermissions.READ, this.clock){

            @Override
            protected LookupRequest populateProjectId(LookupRequest request) {
                LookupRequest.Builder builder = request.toBuilder();
                builder.setProjectId(Utils.getHostedProjectId());
                return builder.build();
            }
        });
        this.registerHandler(registry, Datastore.Method.Rollback, new SimpleRpcHandler<RollbackRequest, RollbackResponse>(ROLLBACK_RPC_SPEC, this.internService, RollbackRequest.PARSER, RollbackRequest.class, RpcHandler.RequestPermissions.READ, this.clock){

            @Override
            protected RollbackRequest populateProjectId(RollbackRequest request) {
                RollbackRequest.Builder builder = request.toBuilder();
                builder.setProjectId(Utils.getHostedProjectId());
                return builder.build();
            }
        });
        this.registerHandler(registry, Datastore.Method.RunQuery, new SimpleRpcHandler<RunQueryRequest, RunQueryResponse>(RUN_QUERY_RPC_SPEC, this.internService, RunQueryRequest.PARSER, RunQueryRequest.class, RpcHandler.RequestPermissions.READ, this.clock){

            @Override
            protected RunQueryRequest populateProjectId(RunQueryRequest request) {
                RunQueryRequest.Builder builder = request.toBuilder();
                builder.setProjectId(Utils.getHostedProjectId());
                return builder.build();
            }
        });
    }

    private <R extends MessageLite, S extends MessageLite> void registerHandler(ServiceRegistry registry, Datastore.Method method, RpcHandler<R, S> handler) {
        String methodName = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, method.toString());
        registry.registerHandler("datastore", "v1beta3", methodName, ServiceRegistry.ApiFormat.V2, handler);
    }

    private static class CommitHandler
    extends CloudDatastoreV1Beta3RpcHandler<CommitRequest, CommitResponse> {
        public CommitHandler(InternDatastoreRpcService internService, Clock clock) {
            super(COMMIT_RPC_SPEC, internService, clock);
        }

        @Override
        public Parser<CommitRequest> getParser() {
            return CommitRequest.PARSER;
        }

        @Override
        public Class<CommitRequest> getRequestClass() {
            return CommitRequest.class;
        }

        @Override
        protected CommitRequest populateProjectId(CommitRequest request) {
            CommitRequest.Builder builder = request.toBuilder();
            builder.setProjectId(Utils.getHostedProjectId());
            return builder.build();
        }

        @Override
        public RpcHandler.RequestPermissions getRequiredPermissions(CommitRequest request) {
            return request.getMutationsList().isEmpty() ? RpcHandler.RequestPermissions.READ : RpcHandler.RequestPermissions.READ_WRITE;
        }
    }

    private static abstract class SimpleRpcHandler<R extends MessageLite, S extends MessageLite>
    extends CloudDatastoreV1Beta3RpcHandler<R, S> {
        private final Parser<R> requestParser;
        private final Class<R> requestClass;
        private final RpcHandler.RequestPermissions requiredPermissions;

        public SimpleRpcHandler(InternDatastoreRpcService.RpcSpec<S> rpcSpec, InternDatastoreRpcService internService, Parser<R> requestParser, Class<R> requestClass, RpcHandler.RequestPermissions requiredPermissions, Clock clock) {
            super(rpcSpec, internService, clock);
            this.requestParser = requestParser;
            this.requestClass = requestClass;
            this.requiredPermissions = requiredPermissions;
        }

        @Override
        public Parser<R> getParser() {
            return this.requestParser;
        }

        @Override
        public Class<R> getRequestClass() {
            return this.requestClass;
        }

        @Override
        public RpcHandler.RequestPermissions getRequiredPermissions(R request) {
            return this.requiredPermissions;
        }
    }
}

