/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.client.searchservice.app;

import com.google.appengine.api.search.GetException;
import com.google.appengine.api.search.Index;
import com.google.appengine.api.search.OperationResult;
import com.google.appengine.repackaged.com.google.common.base.MoreObjects;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.base.Strings;
import com.google.appengine.repackaged.com.google.net.util.error.Codes;
import com.google.appengine.repackaged.com.google.protobuf.Parser;
import com.google.apphosting.client.searchservice.app.CloudSearchRpcHandler;
import com.google.apphosting.client.searchservice.app.InternalSearchApiUtils;
import com.google.apphosting.client.serviceapp.RpcException;
import com.google.apphosting.client.serviceapp.RpcHandler;
import com.google.cloudsearch.v1.Document;
import com.google.cloudsearch.v1.GetDocumentRequest;

class GetDocumentRpcHandler
extends CloudSearchRpcHandler<GetDocumentRequest, Document> {
    GetDocumentRpcHandler() {
    }

    @Override
    public Document call(RpcHandler.CallOptions options, GetDocumentRequest req) throws RpcException {
        Document.Builder respBuilder = Document.newBuilder();
        Index index = InternalSearchApiUtils.getIndex(req.getIndexId());
        Preconditions.checkArgument(!Strings.isNullOrEmpty(req.getDocId()), "docId is required.");
        try {
            com.google.appengine.api.search.Document doc = index.get(req.getDocId());
            if (doc == null) {
                throw new RpcException(Codes.Code.NOT_FOUND, String.format("document id %s does not exist", req.getDocId()));
            }
            InternalSearchApiUtils.setIndexedDocument(respBuilder, doc);
        }
        catch (GetException e) {
            OperationResult opResult = e.getOperationResult();
            throw new RpcException(GetDocumentRpcHandler.fromInternalCode(opResult.getCode()), MoreObjects.firstNonNull(opResult.getMessage(), ""));
        }
        return respBuilder.build();
    }

    @Override
    public Parser<GetDocumentRequest> getParser() {
        return GetDocumentRequest.PARSER;
    }

    @Override
    public Class<GetDocumentRequest> getRequestClass() {
        return GetDocumentRequest.class;
    }

    @Override
    public RpcHandler.RequestPermissions getRequiredPermissions(GetDocumentRequest request) {
        return RpcHandler.RequestPermissions.READ;
    }
}

