/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.AppIdNamespace;
import com.google.appengine.api.datastore.BaseAsyncDatastoreServiceImpl;
import com.google.appengine.api.datastore.Batcher;
import com.google.appengine.api.datastore.DatastoreApiHelper;
import com.google.appengine.api.datastore.DatastoreAttributes;
import com.google.appengine.api.datastore.DatastoreFailureException;
import com.google.appengine.api.datastore.DatastoreService;
import com.google.appengine.api.datastore.DatastoreServiceConfig;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.EntityTranslator;
import com.google.appengine.api.datastore.FetchOptions;
import com.google.appengine.api.datastore.FutureHelper;
import com.google.appengine.api.datastore.Index;
import com.google.appengine.api.datastore.IndexTranslator;
import com.google.appengine.api.datastore.InternalTransactionV3;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.KeyRange;
import com.google.appengine.api.datastore.KeyTranslator;
import com.google.appengine.api.datastore.Query;
import com.google.appengine.api.datastore.QueryRunnerV3;
import com.google.appengine.api.datastore.ReadPolicy;
import com.google.appengine.api.datastore.Transaction;
import com.google.appengine.api.datastore.TransactionImpl;
import com.google.appengine.api.datastore.TransactionOptions;
import com.google.appengine.api.datastore.TransactionStack;
import com.google.appengine.api.utils.FutureWrapper;
import com.google.appengine.repackaged.com.google.common.collect.Lists;
import com.google.appengine.repackaged.com.google.common.collect.Maps;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolMessage;
import com.google.apphosting.api.ApiBasePb;
import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.api.DatastorePb;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;

class AsyncDatastoreServiceImpl
extends BaseAsyncDatastoreServiceImpl {
    private final V3KeyBatcher<DatastorePb.DeleteResponse, DatastorePb.DeleteRequest> deleteBatcher = new V3KeyBatcher<DatastorePb.DeleteResponse, DatastorePb.DeleteRequest>(){

        @Override
        void addToBatch(OnestoreEntity.Reference value, DatastorePb.DeleteRequest batch) {
            batch.addKey(value);
        }

        @Override
        int getMaxCount() {
            return AsyncDatastoreServiceImpl.this.datastoreServiceConfig.maxBatchWriteEntities;
        }

        @Override
        protected Future<DatastorePb.DeleteResponse> makeCall(DatastorePb.DeleteRequest batch) {
            return DatastoreApiHelper.makeAsyncCall(AsyncDatastoreServiceImpl.this.apiConfig, DatastorePb.DatastoreService_3.Method.Delete, batch, new DatastorePb.DeleteResponse());
        }
    };
    private final V3KeyBatcher<DatastorePb.GetResponse, DatastorePb.GetRequest> getByKeyBatcher = new V3KeyBatcher<DatastorePb.GetResponse, DatastorePb.GetRequest>(){

        @Override
        void addToBatch(OnestoreEntity.Reference value, DatastorePb.GetRequest batch) {
            batch.addKey(value);
        }

        @Override
        int getMaxCount() {
            return AsyncDatastoreServiceImpl.this.datastoreServiceConfig.maxBatchReadEntities;
        }

        @Override
        protected Future<DatastorePb.GetResponse> makeCall(DatastorePb.GetRequest batch) {
            return DatastoreApiHelper.makeAsyncCall(AsyncDatastoreServiceImpl.this.apiConfig, DatastorePb.DatastoreService_3.Method.Get, batch, new DatastorePb.GetResponse());
        }
    };
    private final V3Batcher<DatastorePb.GetResponse, DatastorePb.GetRequest, OnestoreEntity.Reference, OnestoreEntity.Reference> getByReferenceBatcher = new V3Batcher<DatastorePb.GetResponse, DatastorePb.GetRequest, OnestoreEntity.Reference, OnestoreEntity.Reference>(){

        @Override
        final Object getGroup(OnestoreEntity.Reference value) {
            return value.getPath().getElement(0);
        }

        @Override
        final OnestoreEntity.Reference toPb(OnestoreEntity.Reference value) {
            return value;
        }

        @Override
        void addToBatch(OnestoreEntity.Reference value, DatastorePb.GetRequest batch) {
            batch.addKey(value);
        }

        @Override
        int getMaxCount() {
            return AsyncDatastoreServiceImpl.this.datastoreServiceConfig.maxBatchReadEntities;
        }

        @Override
        protected Future<DatastorePb.GetResponse> makeCall(DatastorePb.GetRequest batch) {
            return DatastoreApiHelper.makeAsyncCall(AsyncDatastoreServiceImpl.this.apiConfig, DatastorePb.DatastoreService_3.Method.Get, batch, new DatastorePb.GetResponse());
        }
    };
    private final V3Batcher<DatastorePb.PutResponse, DatastorePb.PutRequest, Entity, OnestoreEntity.EntityProto> putBatcher = new V3Batcher<DatastorePb.PutResponse, DatastorePb.PutRequest, Entity, OnestoreEntity.EntityProto>(){

        @Override
        Object getGroup(Entity value) {
            return value.getKey().getRootKey();
        }

        @Override
        void addToBatch(OnestoreEntity.EntityProto value, DatastorePb.PutRequest batch) {
            batch.addEntity(value);
        }

        @Override
        int getMaxCount() {
            return AsyncDatastoreServiceImpl.this.datastoreServiceConfig.maxBatchWriteEntities;
        }

        @Override
        protected Future<DatastorePb.PutResponse> makeCall(DatastorePb.PutRequest batch) {
            return DatastoreApiHelper.makeAsyncCall(AsyncDatastoreServiceImpl.this.apiConfig, DatastorePb.DatastoreService_3.Method.Put, batch, new DatastorePb.PutResponse());
        }

        @Override
        OnestoreEntity.EntityProto toPb(Entity value) {
            return EntityTranslator.convertToPb(value);
        }
    };
    private final ApiProxy.ApiConfig apiConfig;

    public AsyncDatastoreServiceImpl(DatastoreServiceConfig datastoreServiceConfig, ApiProxy.ApiConfig apiConfig, TransactionStack defaultTxnProvider) {
        super(datastoreServiceConfig, defaultTxnProvider, new QueryRunnerV3(datastoreServiceConfig, apiConfig));
        this.apiConfig = apiConfig;
    }

    @Override
    protected TransactionImpl.InternalTransaction doBeginTransaction(TransactionOptions options) {
        DatastorePb.Transaction remoteTxn = new DatastorePb.Transaction();
        DatastorePb.BeginTransactionRequest request = new DatastorePb.BeginTransactionRequest();
        request.setApp(this.datastoreServiceConfig.getAppIdNamespace().getAppId());
        request.setAllowMultipleEg(options.isXG());
        Future<DatastorePb.Transaction> future = DatastoreApiHelper.makeAsyncCall(this.apiConfig, DatastorePb.DatastoreService_3.Method.BeginTransaction, request, remoteTxn);
        return new InternalTransactionV3(this.apiConfig, request.getApp(), future);
    }

    @Override
    protected final Future<Map<Key, Entity>> doBatchGet(Transaction txn, final Set<Key> keysToGet, final Map<Key, Entity> resultMap) {
        final DatastorePb.GetRequest baseReq = new DatastorePb.GetRequest();
        baseReq.setAllowDeferred(true);
        if (txn != null) {
            TransactionImpl.ensureTxnActive(txn);
            baseReq.setTransaction(InternalTransactionV3.localTxnToRemoteTxn(txn));
        }
        if (this.datastoreServiceConfig.getReadPolicy().getConsistency() == ReadPolicy.Consistency.EVENTUAL) {
            baseReq.setFailoverMs(-1L);
            baseReq.setStrong(false);
        }
        final boolean shouldUseMultipleBatches = this.getDatastoreType() != DatastoreAttributes.DatastoreType.MASTER_SLAVE && txn == null && this.datastoreServiceConfig.getReadPolicy().getConsistency() != ReadPolicy.Consistency.EVENTUAL;
        Iterator<DatastorePb.GetRequest> batches = this.getByKeyBatcher.getBatches(keysToGet, baseReq, baseReq.getSerializedSize(), shouldUseMultipleBatches);
        List futures = this.getByKeyBatcher.makeCalls(batches);
        return this.registerInTransaction(txn, new FutureHelper.MultiFuture<DatastorePb.GetResponse, Map<Key, Entity>>(futures){
            private Map<OnestoreEntity.Reference, Key> keyMapIgnoringAppId;

            @Override
            public Map<Key, Entity> get() throws InterruptedException, ExecutionException {
                try {
                    this.aggregate(this.futures, null, null);
                }
                catch (TimeoutException e) {
                    throw new RuntimeException(e);
                }
                return resultMap;
            }

            @Override
            public Map<Key, Entity> get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                this.aggregate(this.futures, timeout, unit);
                return resultMap;
            }

            private void aggregate(Iterable<Future<DatastorePb.GetResponse>> currentFutures, Long timeout, TimeUnit timeoutUnit) throws ExecutionException, InterruptedException, TimeoutException {
                while (true) {
                    LinkedList<OnestoreEntity.Reference> deferredRefs = Lists.newLinkedList();
                    for (Future<DatastorePb.GetResponse> currentFuture : currentFutures) {
                        DatastorePb.GetResponse resp = this.getFutureWithOptionalTimeout(currentFuture, timeout, timeoutUnit);
                        this.addEntitiesToResultMap(resp);
                        deferredRefs.addAll(resp.deferreds());
                    }
                    if (deferredRefs.isEmpty()) break;
                    Iterator<DatastorePb.GetRequest> followupBatches = AsyncDatastoreServiceImpl.this.getByReferenceBatcher.getBatches(deferredRefs, baseReq, baseReq.getSerializedSize(), shouldUseMultipleBatches);
                    currentFutures = AsyncDatastoreServiceImpl.this.getByReferenceBatcher.makeCalls(followupBatches);
                }
            }

            private DatastorePb.GetResponse getFutureWithOptionalTimeout(Future<DatastorePb.GetResponse> future, Long timeout, TimeUnit timeoutUnit) throws ExecutionException, InterruptedException, TimeoutException {
                if (timeout == null) {
                    return future.get();
                }
                return future.get(timeout, timeoutUnit);
            }

            private void addEntitiesToResultMap(DatastorePb.GetResponse response) {
                for (DatastorePb.GetResponse.Entity entityResult : response.entitys()) {
                    if (!entityResult.hasEntity()) continue;
                    Entity responseEntity = EntityTranslator.createFromPb(entityResult.getEntity());
                    Key responseKey = responseEntity.getKey();
                    if (!keysToGet.contains(responseKey)) {
                        responseKey = this.findKeyFromRequestIgnoringAppId(entityResult.getEntity().getKey());
                    }
                    resultMap.put(responseKey, responseEntity);
                }
            }

            private Key findKeyFromRequestIgnoringAppId(OnestoreEntity.Reference referenceFromResponse) {
                Key result;
                if (this.keyMapIgnoringAppId == null) {
                    this.keyMapIgnoringAppId = Maps.newHashMap();
                    for (Key requestKey : keysToGet) {
                        OnestoreEntity.Reference requestKeyAsRefWithoutApp = KeyTranslator.convertToPb(requestKey).clearApp();
                        this.keyMapIgnoringAppId.put(requestKeyAsRefWithoutApp, requestKey);
                    }
                }
                if ((result = this.keyMapIgnoringAppId.get(referenceFromResponse.clearApp())) == null) {
                    throw new DatastoreFailureException("Internal error");
                }
                return result;
            }
        });
    }

    @Override
    protected Future<List<Key>> doBatchPut(Transaction txn, final List<Entity> entities) {
        DatastorePb.PutRequest baseReq = new DatastorePb.PutRequest();
        if (txn != null) {
            TransactionImpl.ensureTxnActive(txn);
            baseReq.setTransaction(InternalTransactionV3.localTxnToRemoteTxn(txn));
        }
        boolean group = !baseReq.hasTransaction();
        ArrayList<Integer> order = Lists.newArrayListWithCapacity(entities.size());
        Iterator<DatastorePb.PutRequest> batches = this.putBatcher.getBatches(entities, baseReq, baseReq.getSerializedSize(), group, order);
        List futures = this.putBatcher.makeCalls(batches);
        return this.registerInTransaction(txn, new Batcher.ReorderingMultiFuture<DatastorePb.PutResponse, List<Key>>(futures, order){

            @Override
            protected List<Key> aggregate(DatastorePb.PutResponse intermediateResult, Iterator<Integer> indexItr, List<Key> result) {
                for (OnestoreEntity.Reference reference : intermediateResult.keys()) {
                    int index = indexItr.next();
                    Key key = ((Entity)entities.get(index)).getKey();
                    KeyTranslator.updateKey(reference, key);
                    result.set(index, key);
                }
                return result;
            }

            @Override
            protected List<Key> initResult(int size) {
                ArrayList<Object> result = new ArrayList<Object>(Collections.nCopies(size, null));
                return result;
            }
        });
    }

    @Override
    protected Future<Void> doBatchDelete(Transaction txn, Collection<Key> keys) {
        DatastorePb.DeleteRequest baseReq = new DatastorePb.DeleteRequest();
        if (txn != null) {
            TransactionImpl.ensureTxnActive(txn);
            baseReq.setTransaction(InternalTransactionV3.localTxnToRemoteTxn(txn));
        }
        boolean group = !baseReq.hasTransaction();
        Iterator<DatastorePb.DeleteRequest> batches = this.deleteBatcher.getBatches(keys, baseReq, baseReq.getSerializedSize(), group);
        List futures = this.deleteBatcher.makeCalls(batches);
        return this.registerInTransaction(txn, new FutureHelper.MultiFuture<DatastorePb.DeleteResponse, Void>(futures){

            @Override
            public Void get() throws InterruptedException, ExecutionException {
                for (Future future : this.futures) {
                    future.get();
                }
                return null;
            }

            @Override
            public Void get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                for (Future future : this.futures) {
                    future.get(timeout, unit);
                }
                return null;
            }
        });
    }

    static OnestoreEntity.Reference buildAllocateIdsRef(Key parent, String kind, AppIdNamespace appIdNamespace) {
        if (parent != null && !parent.isComplete()) {
            throw new IllegalArgumentException("parent key must be complete");
        }
        Key key = new Key(kind, parent, 0L, "ignored", appIdNamespace);
        return KeyTranslator.convertToPb(key);
    }

    @Override
    public Future<KeyRange> allocateIds(final Key parent, final String kind, long num) {
        if (num <= 0L) {
            throw new IllegalArgumentException("num must be > 0");
        }
        if (num > 1000000000L) {
            throw new IllegalArgumentException("num must be < 1 billion");
        }
        final AppIdNamespace appIdNamespace = this.datastoreServiceConfig.getAppIdNamespace();
        OnestoreEntity.Reference allocateIdsRef = AsyncDatastoreServiceImpl.buildAllocateIdsRef(parent, kind, appIdNamespace);
        DatastorePb.AllocateIdsRequest req = new DatastorePb.AllocateIdsRequest().setSize(num).setModelKey(allocateIdsRef);
        DatastorePb.AllocateIdsResponse resp = new DatastorePb.AllocateIdsResponse();
        Future<DatastorePb.AllocateIdsResponse> future = DatastoreApiHelper.makeAsyncCall(this.apiConfig, DatastorePb.DatastoreService_3.Method.AllocateIds, req, resp);
        return new FutureWrapper<DatastorePb.AllocateIdsResponse, KeyRange>(future){

            @Override
            protected KeyRange wrap(DatastorePb.AllocateIdsResponse resp) throws Exception {
                return new KeyRange(parent, kind, resp.getStart(), resp.getEnd(), appIdNamespace);
            }

            @Override
            protected Throwable convertException(Throwable cause) {
                return cause;
            }
        };
    }

    @Override
    public Future<DatastoreService.KeyRangeState> allocateIdRange(final KeyRange range) {
        Key parent = range.getParent();
        final String kind = range.getKind();
        final long start = range.getStart().getId();
        long end = range.getEnd().getId();
        DatastorePb.AllocateIdsRequest req = new DatastorePb.AllocateIdsRequest().setModelKey(AsyncDatastoreServiceImpl.buildAllocateIdsRef(parent, kind, null)).setMax(end);
        DatastorePb.AllocateIdsResponse resp = new DatastorePb.AllocateIdsResponse();
        Future<DatastorePb.AllocateIdsResponse> future = DatastoreApiHelper.makeAsyncCall(this.apiConfig, DatastorePb.DatastoreService_3.Method.AllocateIds, req, resp);
        return new FutureWrapper<DatastorePb.AllocateIdsResponse, DatastoreService.KeyRangeState>(future){

            @Override
            protected DatastoreService.KeyRangeState wrap(DatastorePb.AllocateIdsResponse resp) throws Exception {
                Query query = new Query(kind).setKeysOnly();
                query.addFilter("__key__", Query.FilterOperator.GREATER_THAN_OR_EQUAL, range.getStart());
                query.addFilter("__key__", Query.FilterOperator.LESS_THAN_OR_EQUAL, range.getEnd());
                List<Entity> collision = AsyncDatastoreServiceImpl.this.prepare(query).asList(FetchOptions.Builder.withLimit(1));
                if (!collision.isEmpty()) {
                    return DatastoreService.KeyRangeState.COLLISION;
                }
                boolean raceCondition = start < resp.getStart();
                return raceCondition ? DatastoreService.KeyRangeState.CONTENTION : DatastoreService.KeyRangeState.EMPTY;
            }

            @Override
            protected Throwable convertException(Throwable cause) {
                return cause;
            }
        };
    }

    @Override
    public Future<Map<Index, Index.IndexState>> getIndexes() {
        ApiBasePb.StringProto req = new ApiBasePb.StringProto();
        req.setValue(this.datastoreServiceConfig.getAppIdNamespace().getAppId());
        return new FutureWrapper<DatastorePb.CompositeIndices, Map<Index, Index.IndexState>>(DatastoreApiHelper.makeAsyncCall(this.apiConfig, DatastorePb.DatastoreService_3.Method.GetIndices, req, new DatastorePb.CompositeIndices())){

            @Override
            protected Map<Index, Index.IndexState> wrap(DatastorePb.CompositeIndices indices) throws Exception {
                LinkedHashMap<Index, Index.IndexState> answer = new LinkedHashMap<Index, Index.IndexState>();
                block6: for (OnestoreEntity.CompositeIndex ci : indices.indexs()) {
                    Index index = IndexTranslator.convertFromPb(ci);
                    switch (ci.getStateEnum()) {
                        case DELETED: {
                            answer.put(index, Index.IndexState.DELETING);
                            continue block6;
                        }
                        case ERROR: {
                            answer.put(index, Index.IndexState.ERROR);
                            continue block6;
                        }
                        case READ_WRITE: {
                            answer.put(index, Index.IndexState.SERVING);
                            continue block6;
                        }
                        case WRITE_ONLY: {
                            answer.put(index, Index.IndexState.BUILDING);
                            continue block6;
                        }
                    }
                    String string = String.valueOf(String.valueOf(index));
                    AsyncDatastoreServiceImpl.this.logger.log(Level.WARNING, new StringBuilder(29 + string.length()).append("Unrecognized index state for ").append(string).toString());
                }
                return answer;
            }

            @Override
            protected Throwable convertException(Throwable cause) {
                return cause;
            }
        };
    }

    private abstract class V3KeyBatcher<S extends ProtocolMessage<S>, R extends ProtocolMessage<R>>
    extends V3Batcher<S, R, Key, OnestoreEntity.Reference> {
        private V3KeyBatcher() {
        }

        @Override
        final Object getGroup(Key value) {
            return value.getRootKey();
        }

        @Override
        final OnestoreEntity.Reference toPb(Key value) {
            return KeyTranslator.convertToPb(value);
        }
    }

    private abstract class V3Batcher<S extends ProtocolMessage<S>, R extends ProtocolMessage<R>, F, T extends ProtocolMessage<T>>
    extends BaseAsyncDatastoreServiceImpl.BaseRpcBatcher<S, R, F, T> {
        private V3Batcher() {
            super(AsyncDatastoreServiceImpl.this);
        }

        @Override
        final R newBatch(R baseBatch) {
            return (R)((ProtocolMessage)baseBatch).clone();
        }
    }
}

