/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.FetchOptions;
import com.google.appengine.api.datastore.PreparedQuery;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.io.BaseEncoding;
import com.google.appengine.repackaged.com.google.common.io.ByteStreams;
import com.google.appengine.repackaged.com.google.common.util.Base64;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public final class Cursor
implements Serializable {
    static final long serialVersionUID = 3515556366838971499L;
    private ByteString cursorBytes;

    Cursor() {
        this.cursorBytes = ByteString.EMPTY;
    }

    Cursor(Cursor previousCursor) {
        this(previousCursor.cursorBytes);
    }

    Cursor(ByteString cursorBytes) {
        Preconditions.checkNotNull(cursorBytes);
        this.cursorBytes = cursorBytes;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.write(this.cursorBytes.toByteArray());
    }

    private void readObject(ObjectInputStream in) throws IOException {
        this.cursorBytes = ByteString.copyFrom(ByteStreams.toByteArray(in));
    }

    Cursor advance(int n, PreparedQuery query) {
        if (n == 0) {
            return this;
        }
        if (n > 0) {
            return query.asQueryResultIterator(FetchOptions.Builder.withStartCursor(this).offset(n).limit(0)).getCursor();
        }
        int n2 = n;
        throw new IllegalArgumentException(new StringBuilder(47).append("Unable to offset cursor by ").append(n2).append(" results.").toString());
    }

    @Deprecated
    public Cursor reverse() {
        return this;
    }

    public String toWebSafeString() {
        return BaseEncoding.base64Url().omitPadding().encode(this.cursorBytes.toByteArray());
    }

    public static Cursor fromWebSafeString(String encodedCursor) {
        Preconditions.checkNotNull(encodedCursor, "encodedCursor must not be null");
        try {
            return new Cursor(ByteString.copyFrom(Base64.decodeWebSafe(encodedCursor)));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Unable to decode provided cursor.", e);
        }
    }

    ByteString toByteString() {
        return ByteString.copyFrom(this.cursorBytes.toByteArray());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        return this.cursorBytes.equals(((Cursor)obj).cursorBytes);
    }

    public int hashCode() {
        return this.cursorBytes.hashCode();
    }

    public String toString() {
        return this.cursorBytes.toString();
    }
}

